/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.refit;

import cfca.com.itextpdf.text.BaseColor;
import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.pdf.BaseFont;
import cfca.com.itextpdf.text.pdf.ByteBuffer;
import cfca.com.itextpdf.text.pdf.IntHashtable;
import cfca.com.itextpdf.text.pdf.PRStream;
import cfca.com.itextpdf.text.pdf.PRTokeniser;
import cfca.com.itextpdf.text.pdf.PdfArray;
import cfca.com.itextpdf.text.pdf.PdfContentByte;
import cfca.com.itextpdf.text.pdf.PdfContentParser;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfLiteral;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfObject;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.PdfStamper;
import cfca.com.itextpdf.text.pdf.RandomAccessFileOrArray;
import cfca.com.itextpdf.text.pdf.parser.PdfReaderContentParser;
import cfca.seal.sadk.refit.LocationTextRefitStrategy;
import cfca.seal.sadk.refit.RefitLocationInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class PdfTextRefit {
    private PdfStamper stamper;
    private RefitLocationInfo refitLocationInfo;
    private ArrayList<PdfContentByte> pdfContentByteList = new ArrayList();

    public PdfTextRefit(PdfReader reader, OutputStream os) throws DocumentException, IOException {
        this.stamper = new PdfStamper(reader, os);
    }

    public RefitLocationInfo targetText(int page, boolean isOverContent, String targetText, BaseColor strokeColor, BaseColor fillColor) throws IOException, DocumentException {
        PdfContentByte pdfContentByte;
        PdfReader reader = this.stamper.getReader();
        PdfReaderContentParser pdfReaderContentParser = new PdfReaderContentParser(reader);
        if (targetText == null || targetText.length() == 0) {
            throw new DocumentException("target text can not be null or empty!");
        }
        this.refitLocationInfo = new RefitLocationInfo();
        int numberOfPages = reader.getNumberOfPages();
        if (page != -1 && (page <= 0 || page > numberOfPages)) {
            throw new DocumentException("page must be -1 or positive page within the document!");
        }
        if (-1 != page) {
            RefitLocationInfo tmpRefittingLocationInfo = pdfReaderContentParser.processContent(page, new LocationTextRefitStrategy(targetText, page, reader.getPageRotation(page))).getResultantRefitWord();
            this.refitLocationInfo.addRefitLocationInfo(tmpRefittingLocationInfo);
            pdfContentByte = isOverContent ? this.stamper.getOverContent(page) : this.stamper.getUnderContent(page);
            this.pdfContentByteList.add(pdfContentByte);
        } else {
            for (int i = 1; i < numberOfPages + 1; ++i) {
                page = i;
                RefitLocationInfo tmpRefittingLocationInfo = pdfReaderContentParser.processContent(page, new LocationTextRefitStrategy(targetText, page, reader.getPageRotation(i))).getResultantRefitWord();
                this.refitLocationInfo.addRefitLocationInfo(tmpRefittingLocationInfo);
                pdfContentByte = isOverContent ? this.stamper.getOverContent(page) : this.stamper.getUnderContent(page);
                this.pdfContentByteList.add(pdfContentByte);
            }
        }
        HashMap<Integer, ArrayList<RefitLocationInfo.RefitFloat>> tmpRefitLocMap = this.refitLocationInfo.getRefitLocationMap();
        int mapKeySize = tmpRefitLocMap.size();
        if (mapKeySize == 0) {
            throw new DocumentException("target text:" + targetText + " not found!");
        }
        Integer[] pages = tmpRefitLocMap.keySet().toArray(new Integer[0]);
        int len = pages.length;
        for (int i = 0; i < len; ++i) {
            pdfContentByte = this.pdfContentByteList.get(i);
            pdfContentByte.saveState();
            ArrayList<RefitLocationInfo.RefitFloat> tmpRectanges = tmpRefitLocMap.get(pages[i]);
            int size = tmpRectanges.size();
            for (int j = 0; j < size; ++j) {
                RefitLocationInfo.RefitFloat tmpRefitFloat = tmpRectanges.get(j);
                float x = tmpRefitFloat.x;
                float y = tmpRefitFloat.y;
                float w = tmpRefitFloat.width;
                float h = tmpRefitFloat.height;
                float baseline = tmpRefitFloat.baseline;
                float descent = tmpRefitFloat.descent;
                pdfContentByte.rectangle(x, y, w, h + baseline - descent);
            }
            strokeColor = strokeColor == null ? (strokeColor = BaseColor.WHITE) : strokeColor;
            pdfContentByte.setColorStroke(strokeColor);
            fillColor = fillColor == null ? (fillColor = BaseColor.WHITE) : fillColor;
            pdfContentByte.setColorFill(fillColor);
            pdfContentByte.fill();
            pdfContentByte.restoreState();
        }
        return this.refitLocationInfo;
    }

    public RefitLocationInfo placeText(RefitLocationInfo refitLocationInfo, String placeText, BaseColor strokeColor, BaseColor fillColor, BaseFont baseFont, float fontSize, int fontStyle) throws DocumentException, IOException {
        HashMap<Integer, ArrayList<RefitLocationInfo.RefitFloat>> tmpRefitLocMap = refitLocationInfo.getRefitLocationMap();
        Integer[] pages = tmpRefitLocMap.keySet().toArray(new Integer[0]);
        int len = pages.length;
        for (int i = 0; i < len; ++i) {
            ArrayList<RefitLocationInfo.RefitFloat> tmpRectanges = tmpRefitLocMap.get(pages[i]);
            int size = tmpRectanges.size();
            PdfContentByte pdfContentByte = this.pdfContentByteList.get(i);
            for (int j = 0; j < size; ++j) {
                float hScale;
                pdfContentByte.beginText();
                RefitLocationInfo.RefitFloat tmpRefitFloat = tmpRectanges.get(j);
                float x = tmpRefitFloat.x;
                float y = tmpRefitFloat.y;
                float ascend = tmpRefitFloat.ascend;
                float baseline = tmpRefitFloat.baseline;
                float descent = tmpRefitFloat.descent;
                if (fillColor == null) {
                    fillColor = BaseColor.BLACK;
                }
                pdfContentByte.setColorFill(fillColor);
                if (strokeColor == null) {
                    strokeColor = BaseColor.BLACK;
                }
                pdfContentByte.setColorStroke(strokeColor);
                if (baseFont == null) {
                    baseFont = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", false);
                }
                if ((double)Math.abs(fontSize) < 0.01) {
                    fontSize = ascend - descent;
                }
                if (fontStyle == -1) {
                    fontStyle = 0;
                }
                if (fontStyle == 0) {
                    pdfContentByte.setTextMatrix(x, y + baseline - descent);
                } else if (fontStyle == 1) {
                    pdfContentByte.setTextRenderingMode(2);
                    pdfContentByte.setLineWidth(fontSize / 30.0f);
                    pdfContentByte.setTextMatrix(x, y + baseline - descent);
                } else if (fontStyle == 2) {
                    hScale = 1.0f;
                    pdfContentByte.setTextMatrix(hScale, 0.0f, fontSize / 30.0f, 1.0f, x, y + baseline - descent);
                } else if (fontStyle == 3) {
                    pdfContentByte.setTextRenderingMode(2);
                    pdfContentByte.setLineWidth(fontSize / 30.0f);
                    hScale = 1.0f;
                    pdfContentByte.setTextMatrix(hScale, 0.0f, fontSize / 30.0f, 1.0f, x, y + baseline - descent);
                }
                pdfContentByte.setFontAndSize(baseFont, fontSize);
                pdfContentByte.showText(placeText);
                pdfContentByte.endText();
            }
        }
        return refitLocationInfo;
    }

    public RefitLocationInfo eraseText(RefitLocationInfo refitLocationInfo, String text) throws IOException, InterruptedException {
        PdfReader reader = this.stamper.getReader();
        HashMap<Integer, ArrayList<RefitLocationInfo.RefitFloat>> tmpRefitLocMap = refitLocationInfo.getRefitLocationMap();
        Integer[] pages = tmpRefitLocMap.keySet().toArray(new Integer[0]);
        IntHashtable tableUsedRef = new IntHashtable();
        PdfName prevName = null;
        PdfName prntName = null;
        for (int i = 0; i < pages.length; ++i) {
            PdfDictionary pageN = reader.getPageN(pages[i]);
            PdfDictionary resources = pageN.getAsDict(PdfName.RESOURCES);
            this.eraseRefitText(pageN.getDirectObject(PdfName.CONTENTS), tableUsedRef, prevName, prntName, resources);
        }
        return refitLocationInfo;
    }

    private void eraseRefitText(PdfObject pdfObj, IntHashtable tableUsedRef, PdfName prevName, PdfName prntName, PdfDictionary resources) throws IOException, InterruptedException {
        block7: {
            block6: {
                LinkedBlockingQueue<String> lbq = new LinkedBlockingQueue<String>();
                if (!(pdfObj instanceof PRStream)) break block6;
                PRStream stream = (PRStream)pdfObj;
                byte[] stmBytes = PdfReader.getStreamBytes(stream);
                RandomAccessFileOrArray rafa = new RandomAccessFileOrArray(stmBytes);
                PRTokeniser tokeniser = new PRTokeniser(rafa);
                PdfContentParser contentParser = new PdfContentParser(tokeniser);
                PdfObject obj = null;
                ArrayList<PdfObject> updatedObjs = new ArrayList<PdfObject>();
                while ((obj = contentParser.readPRObject()) != null) {
                    String objString = obj.toString();
                    if ("Do".equals(objString)) {
                        PdfName doName = (PdfName)updatedObjs.get(updatedObjs.size() - 1);
                        String doString = doName.toString();
                        lbq.put(doString);
                    }
                    updatedObjs.add(obj);
                }
                PdfObject[] arrObjs = updatedObjs.toArray(new PdfObject[0]);
                ByteBuffer baos = new ByteBuffer();
                for (int i = 0; i < arrObjs.length; ++i) {
                    PdfObject aObj = arrObjs[i];
                    aObj.toPdf(null, baos);
                    if (aObj instanceof PdfLiteral) {
                        baos.write(13);
                        continue;
                    }
                    baos.write(32);
                }
                stream.setData(baos.toByteArray());
                while (!lbq.isEmpty()) {
                    String xfn = (String)lbq.poll();
                    String tmpXfn = xfn.substring(1);
                    if (null == resources) continue;
                    PdfDictionary xobj = resources.getAsDict(PdfName.XOBJECT);
                    PRStream tmpStream = (PRStream)xobj.getAsStream(new PdfName(tmpXfn));
                    PdfDictionary tmpResources = tmpStream.getAsDict(PdfName.RESOURCES);
                    PdfName subTypeName = tmpStream.getAsName(PdfName.SUBTYPE);
                    if (PdfName.IMAGE.equals(subTypeName)) continue;
                    this.eraseRefitText(tmpStream, tableUsedRef, prevName, prntName, tmpResources);
                }
                break block7;
            }
            if (!(pdfObj instanceof PdfArray)) break block7;
            PdfArray pdfArray = (PdfArray)pdfObj;
            int size = pdfArray.size();
            for (int i = 0; i < size; ++i) {
                PRStream stream = (PRStream)pdfArray.getAsStream(i);
                this.eraseRefitText(stream, tableUsedRef, prevName, prntName, resources);
            }
        }
    }

    public void close() throws DocumentException, IOException {
        this.stamper.close();
    }
}

