/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.sample.sfview;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.sample.sfview.TaggedData;
import cfca.sadk.com.google.typography.font.sfntly.table.FontDataTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.AlternateSubst;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.ChainContextSubst;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.ClassDefTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.ContextSubst;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.CoverageTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.ExtensionSubst;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.FeatureListTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.FeatureTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.GSubTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.LangSysTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.LigatureSubst;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.LookupListTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.LookupTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.MultipleSubst;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.NullTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.ReverseChainSingleSubst;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.ScriptListTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.ScriptTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.SingleSubst;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.SubstSubtable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubClassRule;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubClassSet;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubRule;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubRuleSet;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.classdef.InnerArrayFmt1;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.HeaderTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.NumRecordTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.OneToManySubst;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.RangeRecordTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.contextsubst.DoubleRecordTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.contextsubst.SubClassRule;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.contextsubst.SubClassSet;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.contextsubst.SubGenericRuleSet;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.contextsubst.SubRule;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.contextsubst.SubRuleSet;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.ligaturesubst.Ligature;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.ligaturesubst.LigatureSet;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.singlesubst.HeaderFmt1;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.singlesubst.InnerArrayFmt2;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class OtTableTagger {
    private final TaggedData td;
    private final Map<Class<? extends FontDataTable>, TagMethod> tagMethodRegistry;
    private final List<String> tableCache = new ArrayList<String>();
    private static final Comparator<Class<? extends FontDataTable>> CLASS_NAME_COMPARATOR = new Comparator<Class<? extends FontDataTable>>(){

        @Override
        public int compare(Class<? extends FontDataTable> o1, Class<? extends FontDataTable> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static Set<Class<? extends FontDataTable>> missedClasses = new TreeSet<Class<? extends FontDataTable>>(CLASS_NAME_COMPARATOR);

    OtTableTagger(TaggedData tdata) {
        this.td = tdata;
        this.tagMethodRegistry = new HashMap<Class<? extends FontDataTable>, TagMethod>();
        this.registerTagMethods();
    }

    void tag(GSubTable gsub) {
        if (gsub == null) {
            return;
        }
        this.tagTable(gsub.scriptList());
        this.tagTable(gsub.featureList());
        this.tagTable(gsub.lookupList());
    }

    private void tagTable(FontDataTable table) {
        if (table == null) {
            return;
        }
        ReadableFontData data = table.readFontData();
        if (data == null) {
            return;
        }
        if (this.tableCache.contains(table.toString())) {
            return;
        }
        this.tableCache.add(table.toString());
        TagMethod tm = this.getTagMethod(table);
        if (tm == null) {
            this.td.pushRange(table.getClass().getSimpleName(), data);
        } else {
            this.td.pushRange(tm.tableLabel(table), data);
            tm.tag(table);
        }
        this.td.popRange();
    }

    private void register(TagMethod m) {
        this.tagMethodRegistry.put(m.clzz, m);
    }

    private final void register(TagMethod m, Class<? extends FontDataTable> ... clzzes) {
        this.tagMethodRegistry.put(m.clzz, m);
        for (Class<? extends FontDataTable> clzz : clzzes) {
            this.tagMethodRegistry.put(clzz, m);
        }
    }

    void registerTagMethods() {
        this.register(new TagMethod(ScriptListTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                ScriptListTable table = (ScriptListTable)fdt;
                int scriptCount = OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "script count");
                for (int i = 0; i < scriptCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.TAG, null);
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                }
                for (ScriptTable st : table) {
                    OtTableTagger.this.tagTable(st);
                }
            }
        });
        this.register(new TagMethod(ScriptTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                ScriptTable table = (ScriptTable)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "default lang sys");
                int langCount = OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "language count");
                for (int i = 0; i < langCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.TAG, null);
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                }
                for (LangSysTable lst : table) {
                    OtTableTagger.this.tagTable(lst);
                }
                OtTableTagger.this.tagTable(table.defaultLangSysTable());
            }
        });
        this.register(new TagMethod(LangSysTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                LangSysTable table = (LangSysTable)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT_IGNORED, "lookup order");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT_IGNORED_FFFF, "required feature");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "feature count");
                for (int i = 0; i < table.recordList.count(); ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, null);
                }
            }
        });
        this.register(new TagMethod(FeatureListTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                FeatureListTable table = (FeatureListTable)fdt;
                int featureCount = OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "feature count");
                for (int i = 0; i < featureCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.TAG, "index: " + i);
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                }
                for (FeatureTable ft : table) {
                    OtTableTagger.this.tagTable(ft);
                }
            }
        });
        this.register(new TagMethod(FeatureTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                FeatureTable table = (FeatureTable)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "feature params");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookup count");
                for (int i = 0; i < table.recordList.count(); ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, null);
                }
            }
        });
        this.register(new TagMethod(LookupListTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                LookupListTable table = (LookupListTable)fdt;
                int lookupCount = OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookup count");
                for (i = 0; i < lookupCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET, "index: " + i);
                }
                for (i = 0; i < lookupCount; ++i) {
                    LookupTable lookup = (LookupTable)table.subTableAt(i);
                    if (lookup == null) continue;
                    OtTableTagger.this.tagTable(lookup);
                }
            }
        });
        this.register(new TagMethod(LookupTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                LookupTable table = (LookupTable)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookup type");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookup flags");
                int subTableCount = OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subtable count");
                for (i = 0; i < subTableCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                }
                for (i = 0; i < subTableCount; ++i) {
                    SubstSubtable subTable = (SubstSubtable)table.subTableAt(i);
                    OtTableTagger.this.tagTable(subTable);
                }
            }
        });
        this.register(new TagMethod(LigatureSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                LigatureSubst table = (LigatureSubst)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subst format");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                OtTableTagger.this.tagTable(table.coverage());
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subtable count");
                int subTableCount = table.subTableCount();
                for (i = 0; i < subTableCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                }
                for (i = 0; i < subTableCount; ++i) {
                    LigatureSet subTable = table.subTableAt(i);
                    OtTableTagger.this.tagTable(subTable);
                }
            }
        });
        this.register(new TagMethod(LigatureSet.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                LigatureSet table = (LigatureSet)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookup count");
                for (i = 0; i < table.recordList.count(); ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                }
                for (i = 0; i < table.recordList.count(); ++i) {
                    Ligature lookup = (Ligature)table.subTableAt(i);
                    if (lookup == null) continue;
                    OtTableTagger.this.tagTable(lookup);
                }
            }
        });
        this.register(new TagMethod(Ligature.class){

            @Override
            protected void tag(FontDataTable fdt) {
                Ligature table = (Ligature)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.GLYPH, "lig glyph");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "glyph count + 1");
                for (int i = 0; i < table.recordList.count(); ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                }
            }
        });
        this.register(new TagMethod(SingleSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                SingleSubst table = (SingleSubst)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "format");
                switch (table.format) {
                    case 1: {
                        HeaderFmt1 tableFmt1 = table.fmt1Table();
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                        OtTableTagger.this.tagTable(tableFmt1.coverage);
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "delta glyph id");
                        break;
                    }
                    case 2: {
                        InnerArrayFmt2 tableFmt2 = table.fmt2Table();
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                        OtTableTagger.this.tagTable(tableFmt2.coverage);
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "glyph count");
                        for (int i = 0; i < tableFmt2.recordList.count(); ++i) {
                            OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                        }
                        break;
                    }
                }
            }
        });
        this.register(new TagMethod(MultipleSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                OneToManySubst table = (OneToManySubst)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subst format");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                OtTableTagger.this.tagTable(table.coverage());
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "sequence count");
                int subTableCount = table.recordList().count();
                for (i = 0; i < subTableCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                }
                for (i = 0; i < subTableCount; ++i) {
                    NumRecordTable subTable = table.subTableAt(i);
                    OtTableTagger.this.tagTable(subTable);
                }
            }
        }, AlternateSubst.class);
        this.register(new TagMethod(NumRecordTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                NumRecordTable table = (NumRecordTable)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "glyph count");
                for (int i = 0; i < table.recordList.count(); ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                }
            }
        });
        this.register(new TagMethod(ContextSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                ContextSubst table = (ContextSubst)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subst format");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                OtTableTagger.this.tagTable(table.coverage());
                if (table.format == 2) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "class def offset");
                    OtTableTagger.this.tagTable(table.classDef());
                }
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "sub rule set count");
                int subTableCount = table.recordList().count();
                for (i = 0; i < subTableCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "for inital class: " + i);
                }
                for (i = 0; i < subTableCount; ++i) {
                    SubGenericRuleSet<? extends DoubleRecordTable> subTable = table.subTableAt(i);
                    if (subTable == null) continue;
                    OtTableTagger.this.tagTable(subTable);
                }
            }
        });
        this.register(new TagMethod(SubRuleSet.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                SubGenericRuleSet table = (SubGenericRuleSet)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "sub rule count");
                int subTableCount = table.recordList.count();
                for (i = 0; i < subTableCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                }
                for (i = 0; i < subTableCount; ++i) {
                    DoubleRecordTable subTable = (DoubleRecordTable)table.subTableAt(i);
                    OtTableTagger.this.tagTable(subTable);
                }
            }
        }, SubClassSet.class);
        this.register(new TagMethod(SubRule.class){

            @Override
            protected void tag(FontDataTable fdt) {
                SubRule table = (SubRule)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "input glyph count + 1");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subst lookup record count");
                int glyphCount = table.inputGlyphs.count();
                for (int i = 0; i < glyphCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.GLYPH, "glyph id");
                }
                int lookupCount = table.lookupRecords.count();
                for (int i = 0; i < lookupCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "sequence index");
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookup list index");
                }
            }
        });
        this.register(new TagMethod(SubClassRule.class){

            @Override
            protected void tag(FontDataTable fdt) {
                SubClassRule table = (SubClassRule)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "input class count + 1");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subst lookup record count");
                int glyphCount = table.inputGlyphs.count();
                for (int i = 0; i < glyphCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "class id");
                }
                int lookupCount = table.lookupRecords.count();
                for (int i = 0; i < lookupCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "sequence index");
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookup list index");
                }
            }
        });
        this.register(new TagMethod(ChainContextSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                HeaderTable subTable;
                int i;
                int subTableCount;
                ChainContextSubst table = (ChainContextSubst)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subst format");
                if (table.format == 1 || table.format == 2) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "coverage offset");
                    OtTableTagger.this.tagTable(table.coverage());
                    subTableCount = table.recordList().count();
                    if (table.format == 1) {
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "chain sub rule set count");
                    }
                    if (table.format == 2) {
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "backtrack class def offset");
                        OtTableTagger.this.tagTable(table.backtrackClassDef());
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "input class def offset");
                        OtTableTagger.this.tagTable(table.inputClassDef());
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "look ahead class def offset");
                        OtTableTagger.this.tagTable(table.lookAheadClassDef());
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "chain sub class set count");
                    }
                    for (i = 0; i < subTableCount; ++i) {
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                    }
                    for (i = 0; i < subTableCount; ++i) {
                        subTable = table.subTableAt(i);
                        if (subTable == null) continue;
                        OtTableTagger.this.tagTable(subTable);
                    }
                }
                if (table.format == 3) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "backtrackGlyphs coverage count");
                    subTableCount = table.fmt3Array.backtrackGlyphs.recordList.count();
                    for (i = 0; i < subTableCount; ++i) {
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                        subTable = (CoverageTable)table.fmt3Array.backtrackGlyphs.subTableAt(i);
                        if (subTable == null) continue;
                        OtTableTagger.this.tagTable(subTable);
                    }
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "input glyphs coverage count");
                    subTableCount = table.fmt3Array.inputGlyphs.recordList.count();
                    for (i = 0; i < subTableCount; ++i) {
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                        subTable = (CoverageTable)table.fmt3Array.inputGlyphs.subTableAt(i);
                        if (subTable == null) continue;
                        OtTableTagger.this.tagTable(subTable);
                    }
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookahead glyphs coverage count");
                    subTableCount = table.fmt3Array.lookAheadGlyphs.recordList.count();
                    for (i = 0; i < subTableCount; ++i) {
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                        subTable = (CoverageTable)table.fmt3Array.lookAheadGlyphs.subTableAt(i);
                        if (subTable == null) continue;
                        OtTableTagger.this.tagTable(subTable);
                    }
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subst lookup record count");
                    int lookupCount = table.fmt3Array.lookupRecords.count();
                    for (int i2 = 0; i2 < lookupCount; ++i2) {
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "sequence index");
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookup list index");
                    }
                }
            }
        });
        this.register(new TagMethod(ChainSubRuleSet.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                ChainSubRuleSet table = (ChainSubRuleSet)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "sub rule count");
                int subTableCount = table.recordList.count();
                for (i = 0; i < subTableCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                }
                for (i = 0; i < subTableCount; ++i) {
                    ChainSubRule subTable = (ChainSubRule)table.subTableAt(i);
                    OtTableTagger.this.tagTable(subTable);
                }
            }
        });
        this.register(new TagMethod(ChainSubRule.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                ChainSubRule table = (ChainSubRule)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "backtrack glyph count");
                int glyphCount = table.backtrackGlyphs.count();
                for (i = 0; i < glyphCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                }
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "input glyph count");
                glyphCount = table.inputClasses.count();
                for (i = 0; i < glyphCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                }
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "look ahead glyph count");
                glyphCount = table.lookAheadGlyphs.count();
                for (i = 0; i < glyphCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                }
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subst lookup record count");
                int lookupCount = table.lookupRecords.count();
                for (int i2 = 0; i2 < lookupCount; ++i2) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "sequence index");
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookup list index");
                }
            }
        });
        this.register(new TagMethod(ChainSubClassSet.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                ChainSubClassSet table = (ChainSubClassSet)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "sub class count");
                int subTableCount = table.recordList.count();
                for (i = 0; i < subTableCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET, null);
                }
                for (i = 0; i < subTableCount; ++i) {
                    ChainSubClassRule subTable = (ChainSubClassRule)table.subTableAt(i);
                    OtTableTagger.this.tagTable(subTable);
                }
            }
        });
        this.register(new TagMethod(ChainSubClassRule.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                ChainSubClassRule table = (ChainSubClassRule)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "backtrack glyph class count");
                int glyphCount = table.backtrackGlyphs.count();
                for (i = 0; i < glyphCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "class id");
                }
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "input glyph class count");
                glyphCount = table.inputClasses.count();
                for (i = 0; i < glyphCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "class id");
                }
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "look ahead glyph class count");
                glyphCount = table.lookAheadGlyphs.count();
                for (i = 0; i < glyphCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "class id");
                }
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subst lookup record count");
                int lookupCount = table.lookupRecords.count();
                for (int i2 = 0; i2 < lookupCount; ++i2) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "sequence index");
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookup list index");
                }
            }
        });
        this.register(new TagMethod(ExtensionSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                ExtensionSubst table = (ExtensionSubst)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "format");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookup type");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET32, "lookup offset");
                SubstSubtable subTable = table.subTable();
                OtTableTagger.this.tagTable(subTable);
            }
        });
        this.register(new TagMethod(ReverseChainSingleSubst.class){

            @Override
            protected void tag(FontDataTable fdt) {
                CoverageTable subTable;
                int i;
                ReverseChainSingleSubst table = (ReverseChainSingleSubst)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subst format");
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, "input coverage offset");
                OtTableTagger.this.tagTable(table.coverage);
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "backtrack glyphs coverages count");
                int subTableCount = table.backtrackGlyphs.recordList.count();
                for (i = 0; i < subTableCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                    subTable = (CoverageTable)table.backtrackGlyphs.subTableAt(i);
                    if (subTable == null) continue;
                    OtTableTagger.this.tagTable(subTable);
                }
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "lookahead glyphs coverages count");
                subTableCount = table.lookAheadGlyphs.recordList.count();
                for (i = 0; i < subTableCount; ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.OFFSET_NONZERO, null);
                    subTable = (CoverageTable)table.lookAheadGlyphs.subTableAt(i);
                    if (subTable == null) continue;
                    OtTableTagger.this.tagTable(subTable);
                }
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "subst glyph count");
                for (i = 0; i < table.substitutes.recordList.count(); ++i) {
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                }
            }
        });
        this.register(new TagMethod(CoverageTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                CoverageTable table = (CoverageTable)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "format");
                if (table.format == 1) {
                    NumRecordTable tableFmt1 = (NumRecordTable)table.array;
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "glyph count");
                    for (i = 0; i < tableFmt1.recordList.count(); ++i) {
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.GLYPH, null);
                    }
                }
                if (table.format == 2) {
                    RangeRecordTable tableFmt2 = (RangeRecordTable)table.array;
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "range count");
                    for (i = 0; i < tableFmt2.recordList.count(); ++i) {
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "start");
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "end");
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "offset");
                    }
                }
            }
        });
        this.register(new TagMethod(ClassDefTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
                int i;
                ClassDefTable table = (ClassDefTable)fdt;
                OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "format");
                if (table.format == 1) {
                    InnerArrayFmt1 tableFmt1 = (InnerArrayFmt1)table.array;
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "start glyph");
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "glyph count");
                    for (i = 0; i < tableFmt1.recordList.count(); ++i) {
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, null);
                    }
                }
                if (table.format == 2) {
                    RangeRecordTable tableFmt2 = (RangeRecordTable)table.array;
                    OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "class range count");
                    for (i = 0; i < tableFmt2.recordList.count(); ++i) {
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "start");
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "end");
                        OtTableTagger.this.td.tagRangeField(TaggedData.FieldType.SHORT, "class");
                    }
                }
            }
        });
        this.register(new TagMethod(NullTable.class){

            @Override
            protected void tag(FontDataTable fdt) {
            }
        });
    }

    private TagMethod getTagMethod(FontDataTable table) {
        Class<?> clzz = table.getClass();
        TagMethod tm = this.tagMethodRegistry.get(clzz);
        if (tm == null && !missedClasses.contains(clzz)) {
            missedClasses.add(clzz);
            System.out.println("unregistered class: " + clzz.getName());
        }
        return tm;
    }

    abstract class TagMethod {
        private final Class<? extends FontDataTable> clzz;

        private TagMethod(Class<? extends FontDataTable> clzz) {
            this.clzz = clzz;
        }

        private String tableLabel(FontDataTable table) {
            Class<?> clzz = table.getClass();
            Class<?> encl = clzz.getEnclosingClass();
            if (encl == null) {
                return clzz.getSimpleName();
            }
            return encl.getSimpleName() + "." + clzz.getSimpleName();
        }

        protected abstract void tag(FontDataTable var1);
    }
}

