/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.ofd;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.common.Dom4jUtil;
import cfca.sadk.ofd.base.common.KMPUtil;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.ofd.OFDContentParser;
import cfca.sadk.ofd.base.ofd.Rectangle;
import cfca.sadk.ofd.base.ofd.TextLocation;
import cfca.sadk.ofd.base.seal.SealXMLUtil;
import cfca.sadk.ofd.util.SysEnv;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class SimpleTextParser {
    private static Logger businessLog = LoggerFactory.getLogger(SimpleTextParser.class);
    private final List<TextLocation> locationalResult = new ArrayList<TextLocation>();
    private String keyword;
    private int[] kmpnext;
    private OFDContentParser parser = new OFDContentParser();

    public Map<String, List<Rectangle>> locationExtraction(Map<String, byte[]> filesMap, List<String> keywordList, int pageNum) throws DocumentException, SealException {
        int[] pageNums = null;
        if (pageNum == -1) {
            int totalPages = SealXMLUtil.getTotalPages(filesMap);
            pageNums = new int[]{totalPages};
            for (int i = 1; i <= totalPages; ++i) {
                pageNums[i - 1] = i;
            }
        } else {
            pageNums = new int[]{pageNum};
        }
        return this.locationExtraction(filesMap, keywordList, pageNums);
    }

    public Map<String, List<Rectangle>> locationExtraction(Map<String, byte[]> filesMap, List<String> keywordList, int[] pageNums) throws DocumentException, SealException {
        long start = System.currentTimeMillis();
        businessLog.info("parsePageText start...");
        HashMap<String, List<Rectangle>> mutiKeywordMap = new HashMap<String, List<Rectangle>>();
        if (null == keywordList || keywordList.isEmpty()) {
            throw new IllegalArgumentException("keywordList is null!");
        }
        String baseDir = SealXMLUtil.getBaseDir(filesMap);
        Element root = SealXMLUtil.getDocument(filesMap, baseDir);
        try {
            Map<String, String> templateMap = SealXMLUtil.getTemplates(root, baseDir);
            Element docRes = SealXMLUtil.getDocumentRes(filesMap, baseDir);
            for (int k = 0; k < keywordList.size(); ++k) {
                this.keyword = keywordList.get(k);
                Map<String, String> pageMap = SealXMLUtil.getPageRefIds(root, baseDir);
                Iterator<Map.Entry<String, String>> iterator = pageMap.entrySet().iterator();
                this.kmpnext = KMPUtil.kmpnext(this.keyword);
                ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
                while (iterator.hasNext()) {
                    byte[] fileData;
                    boolean isContinue;
                    String oneFilePath;
                    Map.Entry<String, String> entry = iterator.next();
                    String filePath = entry.getKey();
                    boolean isPageContent = filePath.contains("Content");
                    if (!isPageContent) continue;
                    businessLog.info("process page:" + filePath);
                    long startTime = System.currentTimeMillis();
                    int pageNo = Integer.parseInt(entry.getValue());
                    String pathKey = entry.getKey();
                    String string = oneFilePath = pathKey.contains(baseDir) ? pathKey : baseDir + pathKey;
                    if (oneFilePath.startsWith("/")) {
                        oneFilePath = oneFilePath.substring(1);
                    }
                    int newPageNum = StringUtil.getSingleNum(oneFilePath);
                    Arrays.sort(pageNums);
                    boolean bl = isContinue = Arrays.binarySearch(pageNums, newPageNum + 1) >= 0;
                    if (isContinue && null != (fileData = filesMap.get(oneFilePath))) {
                        Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(fileData));
                        Element body = document.getRootElement();
                        Element content = body.element("Content");
                        List templateList = body.elements("Template");
                        if (null != templateList) {
                            for (int m = 0; m < templateList.size(); ++m) {
                                Element template = (Element)templateList.get(m);
                                if (null == template) continue;
                                String templateid = template.attributeValue("TemplateID");
                                String templatePath = baseDir + templateMap.get(templateid);
                                byte[] templateData = filesMap.get(templatePath);
                                if (templateData != null) {
                                    Document documentTmpl = Dom4jUtil.parseFile(new ByteArrayInputStream(templateData));
                                    Element bodyTmpl = documentTmpl.getRootElement();
                                    Element contentbodyTmpl = bodyTmpl.element("Content");
                                    this.parseCompositeObject(filesMap, (Node)bodyTmpl, docRes, pageNo, filePath, content, retval);
                                    this.parseOnePage(filesMap, pageNo, filePath, contentbodyTmpl, retval);
                                    continue;
                                }
                                businessLog.warn(templatePath + " is not found!");
                            }
                        }
                        this.parseCompositeObject(filesMap, (Node)body, docRes, pageNo, filePath, content, retval);
                        this.parseOnePage(filesMap, pageNo, filePath, content, retval);
                    }
                    long end = System.currentTimeMillis();
                    businessLog.info("parse page = " + filePath + " cost= " + (end - startTime) + "ms");
                }
                Collections.sort(retval, new Comparator<Rectangle>(){

                    @Override
                    public int compare(Rectangle l1, Rectangle l2) {
                        if (l1.getPageNum() == l2.getPageNum()) {
                            if (l1.getY() == l2.getY()) {
                                return l1.getX() == l2.getX() ? 0 : (l1.getX() > l2.getX() ? 1 : -1);
                            }
                            return l1.getY() > l2.getY() ? 1 : -1;
                        }
                        return l1.getPageNum() > l2.getPageNum() ? 1 : -1;
                    }
                });
                mutiKeywordMap.put(this.keyword, retval);
            }
            HashMap<String, List<Rectangle>> hashMap = mutiKeywordMap;
            return hashMap;
        }
        catch (Throwable e) {
            businessLog.error("parsePageText failed", e);
            throw new SealException("", e);
        }
        finally {
            this.parser.destroy();
            this.locationalResult.clear();
            long end = System.currentTimeMillis();
            businessLog.info("update parsePageText end...cost=" + (end - start) + " ms");
        }
    }

    public List<Rectangle> locationExtraction(Map<String, byte[]> filesMap, String keyword, int pageNum) throws DocumentException, SealException {
        ArrayList<String> keywordList = new ArrayList<String>();
        keywordList.add(keyword);
        Map<String, List<Rectangle>> resultMap = this.locationExtraction(filesMap, keywordList, pageNum);
        return resultMap.get(keyword);
    }

    public List<Rectangle> locationExtraction(Map<String, byte[]> filesMap, String keyword, int[] pageNums) throws DocumentException, SealException {
        ArrayList<String> keywordList = new ArrayList<String>();
        keywordList.add(keyword);
        Map<String, List<Rectangle>> resultMap = this.locationExtraction(filesMap, keywordList, pageNums);
        return resultMap.get(keyword);
    }

    private List<Rectangle> getKeywordList(Map<String, byte[]> filesMap, String pageWords, HashMap<Integer, Integer> chunkPositions, String keyword, int[] kmpnext) throws IOException {
        long start = System.currentTimeMillis();
        boolean flag = true;
        ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
        String sourceStr = pageWords;
        int charLastIndex = 0;
        int markChunkIndex = -1;
        while (flag) {
            int charStartIndex = KMPUtil.kmp(sourceStr, keyword, kmpnext);
            if (charStartIndex == -1) {
                flag = false;
                continue;
            }
            charStartIndex = charLastIndex + charStartIndex;
            int charEndIndex = charStartIndex + kmpnext.length;
            int chunkStartIndex = charStartIndex;
            try {
                chunkStartIndex = chunkPositions.get(charStartIndex);
            }
            catch (NullPointerException e) {
                chunkStartIndex = chunkPositions.get(charStartIndex - 1);
            }
            if (chunkStartIndex <= markChunkIndex) {
                charLastIndex = charEndIndex;
                sourceStr = pageWords.substring(charEndIndex);
                continue;
            }
            markChunkIndex = chunkStartIndex;
            int chunkEndIndex = chunkStartIndex;
            if (kmpnext.length != 1) {
                chunkEndIndex = charEndIndex - 1;
                try {
                    chunkEndIndex = chunkPositions.get(chunkEndIndex);
                }
                catch (NullPointerException e) {
                    chunkEndIndex = chunkPositions.get(chunkEndIndex + 1);
                }
            } else {
                chunkEndIndex = chunkPositions.get(charEndIndex - 1);
            }
            for (Rectangle r : this.getKeywordRectangleList(filesMap, this.getSubChunkList(this.locationalResult, chunkStartIndex, chunkEndIndex))) {
                retval.add(r);
            }
            charLastIndex = charEndIndex;
            sourceStr = pageWords.substring(charEndIndex);
        }
        long end = System.currentTimeMillis();
        businessLog.info("getKeywordList cost=" + (end - start) + " ms");
        return retval;
    }

    protected List<TextLocation> getSubChunkList(List<TextLocation> chunkList, int startIndex, int endIndex) {
        ArrayList<TextLocation> subChunkList = new ArrayList<TextLocation>();
        TextLocation lastChunk = chunkList.get(startIndex);
        subChunkList.add(lastChunk);
        for (int i = startIndex + 1; i <= endIndex; ++i) {
            TextLocation curChunk = chunkList.get(i);
            subChunkList.add(curChunk);
            lastChunk = curChunk;
        }
        return subChunkList;
    }

    protected List<Rectangle> getKeywordRectangleList(Map<String, byte[]> filesMap, List<TextLocation> cris) throws IOException {
        ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
        if (cris.isEmpty()) {
            return retval;
        }
        int chunkSize = cris.size();
        TextLocation firstChunk = cris.get(0);
        TextLocation lastChunk = cris.get(chunkSize - 1);
        if (chunkSize > 1) {
            TextLocation tmpChunk;
            boolean hasSameLineChunk = false;
            for (int i = 1; i < chunkSize && this.isSameLine(firstChunk, tmpChunk = cris.get(i)); ++i) {
                lastChunk = tmpChunk;
                hasSameLineChunk = true;
            }
            if (!hasSameLineChunk) {
                lastChunk = firstChunk;
            }
            String firstWord = this.keyword.substring(0, 1);
            int startIndex = firstChunk.getText().lastIndexOf(firstWord);
            String[] deltaXArray = firstChunk.getDeltaXArray();
            float keywordX = firstChunk.getX() > 0.0f ? firstChunk.getX() : 0.0f;
            String firstCtm = firstChunk.getCtm();
            float firstCoefficient = 1.0f;
            if (firstCtm != null) {
                firstCoefficient = Float.valueOf(firstCtm.split(" ")[0]).floatValue();
                keywordX = firstCoefficient * keywordX;
            }
            float boundaeyHeight = firstChunk.getRect().getHeight();
            for (int i = 0; i < startIndex; ++i) {
                float oneDeltaX = firstCoefficient * Float.valueOf(deltaXArray[i]).floatValue();
                if (oneDeltaX > boundaeyHeight) {
                    oneDeltaX = boundaeyHeight;
                }
                keywordX += oneDeltaX;
            }
            String lastWord = this.keyword.substring(this.keyword.length() - 1);
            int lastIndex = lastChunk.getText().lastIndexOf(lastWord);
            float offset = 0.0f;
            String lastCtm = lastChunk.getCtm();
            float coefficient = 1.0f;
            if (lastCtm != null) {
                coefficient = Float.valueOf(lastCtm.split(" ")[0]).floatValue();
            }
            deltaXArray = lastChunk.getDeltaXArray();
            float lastChunkWidth = 0.0f;
            if (lastIndex != -1) {
                for (int i = lastIndex; i < deltaXArray.length; ++i) {
                    float oneDeltaX = Float.valueOf(coefficient).floatValue() * Float.valueOf(deltaXArray[i]).floatValue();
                    offset += oneDeltaX;
                }
                if ((double)Math.abs(offset) < 1.0E-4) {
                    lastChunkWidth = this.calculateRealChunkWidth(filesMap, lastChunk);
                }
            } else {
                lastChunkWidth = this.calculateRealChunkWidth(filesMap, lastChunk);
            }
            float y = Math.min(firstChunk.getRect().getY(), lastChunk.getRect().getY());
            float width = lastChunk.getRect().getX() - firstChunk.getRect().getX() + offset - keywordX + lastChunkWidth + lastChunk.getX();
            float height = Math.max(lastChunk.getRect().getHeight(), firstChunk.getRect().getHeight());
            Rectangle keywordRect = new Rectangle(firstChunk.getRect().getX() + keywordX, y, width, height);
            keywordRect.setPageNum(lastChunk.getPageNo());
            keywordRect.setPageFilePath(lastChunk.getPageFilePath());
            retval.add(keywordRect);
        } else {
            Rectangle rect = firstChunk.getRect();
            String ctm = firstChunk.getCtm();
            float coefficient = 1.0f;
            if (null != ctm) {
                coefficient = Float.valueOf(firstChunk.getCtm().split(" ")[0]).floatValue();
            }
            float startOffset = rect.getX() + firstChunk.getX() * coefficient;
            String[] deltaXArray = firstChunk.getDeltaXArray();
            String chunkText = firstChunk.getText();
            int startIndex = chunkText.indexOf(this.keyword);
            String leftText = chunkText;
            boolean flag = startIndex != -1;
            float keywordWidth = 0.0f;
            String[] dest = new String[chunkText.length()];
            if (deltaXArray.length + 1 == chunkText.length()) {
                System.arraycopy(deltaXArray, 0, dest, 0, deltaXArray.length);
            }
            float startOffsetX = 0.0f;
            float[] widthX = this.calculateWrodWidth(chunkText, dest, coefficient, rect.getWidth());
            float sumDeltaX = 0.0f;
            for (int i = 0; i < widthX.length - 1; ++i) {
                sumDeltaX += widthX[i];
            }
            if (SysEnv.isParseFontInfo()) {
                widthX[widthX.length - 1] = this.parser.getFontWidth(filesMap, firstChunk.getFontId(), chunkText.substring(widthX.length - 1), firstChunk.getFontSize()) * coefficient;
            }
            if (widthX[widthX.length - 1] == 0.0f || !SysEnv.isParseFontInfo()) {
                widthX[widthX.length - 1] = rect.getWidth() - (sumDeltaX + coefficient * firstChunk.getX());
                if (widthX.length > 1 && widthX[widthX.length - 1] - widthX[widthX.length - 2] > 1.0f) {
                    widthX[widthX.length - 1] = widthX[widthX.length - 2];
                }
            }
            for (int j = startIndex; j < startIndex + this.kmpnext.length; ++j) {
                if (j - startIndex >= widthX.length) continue;
                if (j >= 0) {
                    float oneDeltaX = widthX[j];
                    keywordWidth += oneDeltaX;
                    continue;
                }
                keywordWidth = widthX[0];
            }
            int lastIndex = 0;
            int count = 0;
            while (flag) {
                for (int i = lastIndex + count; i < lastIndex + startIndex + count; ++i) {
                    float oneDeltaX = widthX[i];
                    startOffsetX += oneDeltaX;
                }
                Rectangle oneKeywordRect = new Rectangle(startOffsetX + startOffset, rect.getY(), keywordWidth, rect.getHeight());
                oneKeywordRect.setPageNum(firstChunk.getPageNo());
                oneKeywordRect.setPageFilePath(firstChunk.getPageFilePath());
                retval.add(oneKeywordRect);
                lastIndex = startIndex + this.kmpnext.length;
                leftText = leftText.substring(lastIndex);
                startOffset = oneKeywordRect.getX() + keywordWidth;
                startOffsetX = 0.0f;
                startIndex = leftText.indexOf(this.keyword);
                flag = startIndex != -1;
                ++count;
            }
        }
        return retval;
    }

    private boolean isSameLine(TextLocation firstChunk, TextLocation lastChunk) {
        float distPerpendicularDiff = firstChunk.getRect().getY() - lastChunk.getRect().getY();
        String lastText = lastChunk.getText();
        if (lastText != null && lastText.replaceAll(" ", "").equals("") && distPerpendicularDiff < 0.0f) {
            distPerpendicularDiff = 0.0f;
        }
        Rectangle firstRect = firstChunk.getRect();
        float firstY = firstRect.getY();
        Rectangle lastRect = lastChunk.getRect();
        float lastY = lastRect.getY();
        float minFontSize = Math.min(firstRect.getHeight(), lastRect.getHeight());
        if ((double)Math.abs(minFontSize) < 1.0E-4) {
            minFontSize = Math.max(firstRect.getHeight(), lastRect.getHeight());
        }
        return Math.abs(distPerpendicularDiff) < minFontSize || Math.abs(firstY - lastY) < 2.0f;
    }

    private float calculateRealChunkWidth(Map<String, byte[]> filesMap, TextLocation firstChunk) {
        float boundaeyHeight;
        String[] deltaXArray = firstChunk.getDeltaXArray();
        String chunkText = firstChunk.getText();
        String fontID = firstChunk.getFontId();
        float x = firstChunk.getX();
        float fontSize = firstChunk.getFontSize();
        if (fontSize > (boundaeyHeight = firstChunk.getRect().getHeight())) {
            fontSize = boundaeyHeight;
        }
        int wordCount = chunkText.length();
        float sumWidth = 0.0f;
        float lastDeltaX = 0.0f;
        String firstCtm = firstChunk.getCtm();
        float firstCoefficient = 1.0f;
        if (firstCtm != null) {
            firstCoefficient = Float.valueOf(firstCtm.split(" ")[0]).floatValue();
        }
        for (int i = 0; i < wordCount - 1; ++i) {
            float singleWidth = Float.valueOf(deltaXArray[i]).floatValue() * firstCoefficient;
            sumWidth += singleWidth;
            if (i != wordCount - 2) continue;
            lastDeltaX = singleWidth;
        }
        if (wordCount - 2 > 0) {
            float tmpLength;
            String lastText = chunkText.substring(wordCount - 2);
            if (SysEnv.isParseFontInfo() && (tmpLength = this.parser.getFontWidth(filesMap, fontID, lastText, fontSize)) != 0.0f) {
                lastDeltaX = tmpLength;
            }
        }
        if (sumWidth == 0.0f) {
            sumWidth = firstChunk.getRect().getWidth();
        }
        return sumWidth + lastDeltaX - x;
    }

    private float[] calculateWrodWidth(String text, String[] deltaX, float coefficient, float boundaryWidth) throws IOException {
        float[] widthX = new float[deltaX.length];
        float singleWidth = boundaryWidth / (float)deltaX.length;
        for (int j = 0; j < deltaX.length - 1; ++j) {
            widthX[j] = deltaX[j] != null && StringUtil.isNumber(deltaX[j]) ? Float.valueOf(deltaX[j]).floatValue() * coefficient : singleWidth;
        }
        return widthX;
    }

    private void parseTextObject(List list, Map<String, byte[]> filesMap, StringBuilder onePageText, int totalChars, int pageNo, String filePath, HashMap<Integer, Integer> chunkPositions) throws IOException, FontFormatException {
        long parseStart = System.currentTimeMillis();
        for (int i = 0; i < list.size(); ++i) {
            String newText;
            Element ontTextObj = (Element)list.get(i);
            String boundary = ontTextObj.attributeValue("Boundary");
            String ctm = ontTextObj.attributeValue("CTM");
            String fontSize = ontTextObj.attributeValue("Size");
            String fontID = ontTextObj.attributeValue("Font");
            Element cgTransform = ontTextObj.element("CGTransform");
            String glyphs = null;
            if (cgTransform != null) {
                glyphs = cgTransform.element("Glyphs").getStringValue();
            }
            List textCodeList = ontTextObj.elements("TextCode");
            StringBuffer oneTextObjText = new StringBuffer();
            float textObjX = 0.0f;
            float textObjY = 0.0f;
            float textObjLastX = 0.0f;
            String deltaX = null;
            StringBuffer textObjDeltaX = new StringBuffer();
            for (int m = 0; m < textCodeList.size(); ++m) {
                Element textCode = (Element)textCodeList.get(m);
                String text = textCode.getText();
                oneTextObjText.append(text);
                float x = Float.valueOf(textCode.attributeValue("X")).floatValue();
                float y = Float.valueOf(textCode.attributeValue("Y")).floatValue();
                if (m == 0) {
                    textObjX = x;
                    textObjY = y;
                    deltaX = textCode.attributeValue("DeltaX");
                    if (deltaX == null) {
                        deltaX = "0";
                    }
                } else if (m < textCodeList.size() - 1) {
                    textObjDeltaX.append(String.valueOf(x - textObjLastX) + " ");
                } else {
                    textObjDeltaX.append(String.valueOf(x - textObjLastX));
                }
                textObjLastX = x;
            }
            if (textCodeList.size() > 1) {
                deltaX = textObjDeltaX.toString();
            }
            if (StringUtil.isNotEmpty(newText = oneTextObjText.toString()) && !StringUtil.isContainValidChar(newText)) {
                newText = this.parser.parseFontInfo(filesMap, fontID, glyphs);
            }
            for (int j = 0; j < newText.length(); ++j) {
                chunkPositions.put(totalChars, i);
                ++totalChars;
            }
            onePageText.append(newText);
            this.locationalResult.add(new TextLocation(pageNo, boundary, ctm, newText, textObjX, textObjY, deltaX, Float.valueOf(fontSize).floatValue(), fontID, null, glyphs, filePath));
        }
        long parseEnd = System.currentTimeMillis();
        businessLog.info("filePath=" + filePath + ",TextLocation number is:" + this.locationalResult.size() + " cost=" + (parseEnd - parseStart) + " ms");
    }

    private void parseOnePage(Map<String, byte[]> filesMap, int pageNo, String filePath, Element content, List<Rectangle> retval) throws IOException, FontFormatException {
        Element layer = content.element("Layer");
        if (layer != null) {
            List list = layer.selectNodes("//ofd:TextObject");
            StringBuilder onePageText = new StringBuilder();
            HashMap<Integer, Integer> chunkPositions = new HashMap<Integer, Integer>();
            int totalChars = 0;
            this.parseTextObject(list, filesMap, onePageText, totalChars, pageNo, filePath, chunkPositions);
            String pageWords = onePageText.toString();
            retval.addAll(this.getKeywordList(filesMap, pageWords, chunkPositions, this.keyword, this.kmpnext));
            this.locationalResult.clear();
        }
    }

    private void parseCompositeObject(Map<String, byte[]> filesMap, Node body, Element docRes, int pageNo, String filePath, Element content, List<Rectangle> retval) throws IOException, FontFormatException {
        List composite = body.selectNodes("//ofd:CompositeObject");
        if (null != docRes && composite != null && composite.size() > 0) {
            for (int m = 0; m < composite.size(); ++m) {
                List compositeObjectList;
                Element oneComposite = (Element)composite.get(m);
                String resourceID = oneComposite.attributeValue("ResourceID");
                String boundary = oneComposite.attributeValue("Boundary");
                Rectangle outerBoundary = new Rectangle(boundary);
                Element compositeGraphicUnits = docRes.element("CompositeGraphicUnits");
                StringBuilder onePageText = new StringBuilder();
                int totalChars = 0;
                HashMap<Integer, Integer> chunkPositions = new HashMap<Integer, Integer>();
                if (compositeGraphicUnits == null || (compositeObjectList = compositeGraphicUnits.elements("CompositeGraphicUnit")) == null) continue;
                for (int i = 0; i < compositeObjectList.size(); ++i) {
                    Element compositeObject = (Element)compositeObjectList.get(i);
                    String id = compositeObject.attributeValue("ID");
                    if (!resourceID.equals(id)) continue;
                    List textObjects = compositeObject.selectNodes("//ofd:TextObject");
                    this.parseTextObject(textObjects, filesMap, onePageText, totalChars, pageNo, filePath, chunkPositions);
                    String pageWords = onePageText.toString();
                    List<Rectangle> keywordRect = this.getKeywordList(filesMap, pageWords, chunkPositions, this.keyword, this.kmpnext);
                    for (int j = 0; j < keywordRect.size(); ++j) {
                        Rectangle onePosition = keywordRect.get(j);
                        onePosition.setX(outerBoundary.getX());
                        onePosition.setY(outerBoundary.getY());
                    }
                    retval.addAll(keywordRect);
                    this.locationalResult.clear();
                }
            }
        }
    }

    public void destroy() {
        if (this.locationalResult != null) {
            this.locationalResult.clear();
        }
        this.parser.destroy();
    }
}

