/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.maker.bean;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.maker.util.WebSealUtil;

public class UsbKeySeal {
    private String signerName;
    private String unitName;
    private String sealName;
    private String subjectName;
    private long startValidTime = 0L;
    private long endValidTime = 0L;
    private byte[] pfxData;
    private byte[] pngData;
    private X509Cert x509Cert;

    public UsbKeySeal(X509Cert x509Cert, byte[] pngData, String signerName, String unitName, String sealName) throws PKIException {
        try {
            this.x509Cert = x509Cert;
            this.pngData = pngData;
            this.signerName = signerName;
            this.unitName = unitName;
            this.sealName = sealName;
            this.startValidTime = x509Cert.getNotBefore().getTime() / 1000L;
            this.endValidTime = x509Cert.getNotAfter().getTime() / 1000L;
            this.subjectName = x509Cert.getSubject();
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public X509Cert getX509Cert() {
        return this.x509Cert;
    }

    public void setX509Cert(X509Cert x509Cert) {
        this.x509Cert = x509Cert;
    }

    public UsbKeySeal() {
    }

    public UsbKeySeal(byte[] signPfxData, String pfxPWD, byte[] pngData, String signerName, String unitName, String sealName) throws PKIException {
        try {
            this.pfxData = signPfxData[0] != 48 ? Base64.decode((byte[])signPfxData) : signPfxData;
            int keyType = WebSealUtil.getKeyStoreType(this.pfxData);
            X509Cert cert = null;
            if (keyType == 1) {
                cert = CertUtil.getCertFromPFX((byte[])this.pfxData, (String)pfxPWD);
            } else if (keyType == 2) {
                cert = CertUtil.getCertFromSM2((byte[])this.pfxData);
            } else {
                throw new PKIException("unknow key type,rsa or sm2?");
            }
            this.pngData = pngData;
            this.signerName = signerName;
            this.unitName = unitName;
            this.sealName = sealName;
            this.startValidTime = cert.getNotBefore().getTime() / 1000L;
            this.endValidTime = cert.getNotAfter().getTime() / 1000L;
            this.subjectName = cert.getSubject();
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getSealName() {
        return this.sealName;
    }

    public void setSealName(String sealName) {
        this.sealName = sealName;
    }

    public long getStartValidTime() {
        return this.startValidTime;
    }

    public void setStartValidTime(long startValidTime) {
        this.startValidTime = startValidTime;
    }

    public long getEndValidTime() {
        return this.endValidTime;
    }

    public void setEndValidTime(long endValidTime) {
        this.endValidTime = endValidTime;
    }

    public byte[] getPfxData() {
        return this.pfxData;
    }

    public byte[] getPngData() {
        return this.pngData;
    }

    public void setPfxData(byte[] pfxData) {
        this.pfxData = pfxData;
    }

    public void setPngData(byte[] pngData) {
        this.pngData = pngData;
    }
}

