/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.common;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.signature.PKCS7PackageFacade;
import cfca.sadk.signature.decoder.PKCS7DecodeFacade;
import cfca.sadk.x509.certificate.X509Cert;

public class PKCS7SignedFile {
    private final Session session;
    private PKCS7DecodeFacade p7Decoder;

    public PKCS7SignedFile(Session session) {
        this.session = session == null ? BCSoftLib.INSTANCE() : session;
    }

    public String getDigestAlgorithm() throws PKIException {
        return this.p7Decoder == null ? null : this.p7Decoder.getDigestAlgorithm();
    }

    public byte[] getSignature() throws PKIException {
        return this.p7Decoder == null ? null : this.p7Decoder.getSignature();
    }

    public byte[] getSourceData() throws PKIException {
        return this.p7Decoder == null ? null : this.p7Decoder.getSourceData();
    }

    public X509Cert getSignerX509Cert() throws PKIException {
        return this.p7Decoder == null ? null : this.p7Decoder.getSignerX509Cert();
    }

    public boolean verifyP7SignedFile(String signFile, String saveSrcFilePath) throws Exception {
        this.p7Decoder = new PKCS7DecodeFacade(this.session, signFile);
        return this.p7Decoder.verifyP7SignedFileAttach(saveSrcFilePath);
    }

    public void packageSignedFile(String sourceFilePath, String signFile, byte[] signture, Mechanism mechanism, X509Cert[] receiverCerts) throws PKIException {
        PKCS7PackageFacade.packageSignedFile(sourceFilePath, signFile, signture, mechanism, receiverCerts);
    }
}

