/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.decoder;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.asn1.parser.ASN1Node;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.jni.JNIDigest;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.system.CompatibleAlgorithm;
import cfca.sadk.system.logging.LoggerManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class SM3DualHash {
    static final int fileBufferSize = 65536;

    private SM3DualHash() {
    }

    public static byte[] sm2HashFile(InputStream stream, Session session) throws PKIException {
        return SM3DualHash.sm2HashFile(null, (InputStream)stream, (Session)session, (boolean)false).hashValue;
    }

    public static SM3DualHashResult sm2HashFile(SM2PublicKey sm2PubKey, InputStream stream, Session session) throws PKIException {
        return SM3DualHash.sm2HashFile(sm2PubKey, stream, session, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SM3DualHashResult sm2HashFile(SM2PublicKey sm2PubKey, InputStream stream, Session session, boolean enableWithoutZ) throws PKIException {
        SM3DualHashResult sM3DualHashResult;
        boolean supportedWithoutZ = enableWithoutZ && CompatibleAlgorithm.isCompatibleSM2WithoutZ();
        boolean jniFlag = session != null && session.useJniNativeOperation();
        Digest hashWithZ = null;
        Digest hashNoneZ = null;
        try {
            byte[] buffer = new byte[65536];
            Digest digest = hashWithZ = jniFlag ? new JNIDigest(922) : new SM3Digest();
            if (sm2PubKey != null) {
                hashWithZ.update(sm2PubKey.getDefaultZ(), 0, 32);
            }
            if (supportedWithoutZ) {
                hashNoneZ = jniFlag ? new JNIDigest(922) : new SM3Digest();
            }
            int readLength = 0;
            while ((readLength = stream.read(buffer, 0, buffer.length)) != -1) {
                hashWithZ.update(buffer, 0, readLength);
                if (!supportedWithoutZ) continue;
                hashNoneZ.update(buffer, 0, readLength);
            }
            byte[] hashValueWithZ = new byte[32];
            byte[] hashValueNoneZ = null;
            hashWithZ.doFinal(hashValueWithZ, 0);
            if (supportedWithoutZ) {
                hashValueNoneZ = new byte[32];
                hashNoneZ.doFinal(hashValueNoneZ, 0);
                hashNoneZ = null;
            }
            sM3DualHashResult = new SM3DualHashResult(hashValueWithZ, hashValueNoneZ, supportedWithoutZ);
        }
        catch (Exception e) {
            try {
                throw new PKIException("sm2HashFile failure with exception: " + e.getMessage(), e);
                catch (Throwable e2) {
                    throw new PKIException("sm2HashFile failure with throwable: " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                JNIDigest.destroy(hashWithZ);
                JNIDigest.destroy(hashNoneZ);
                throw throwable;
            }
        }
        JNIDigest.destroy(hashWithZ);
        JNIDigest.destroy(hashNoneZ);
        return sM3DualHashResult;
    }

    public static byte[] sm2HashFile(ASN1Node sourceNode, String sourceFileOutputPath, Session session) throws PKIException {
        return SM3DualHash.sm2HashFile(null, (ASN1Node)sourceNode, (String)sourceFileOutputPath, (Session)session, (boolean)false).hashValue;
    }

    public static SM3DualHashResult sm2HashFile(SM2PublicKey sm2PubKey, ASN1Node sourceNode, String sourceFileOutputPath, Session session) throws PKIException {
        if (sm2PubKey == null) {
            throw new PKIException("sm2HashFile failed: sm2PubKey==null");
        }
        return SM3DualHash.sm2HashFile(sm2PubKey, sourceNode, sourceFileOutputPath, session, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SM3DualHashResult sm2HashFile(SM2PublicKey sm2PubKey, ASN1Node sourceNode, String sourceFileOutputPath, Session session, boolean enableWithoutZ) throws PKIException {
        SM3DualHashResult sM3DualHashResult;
        if (sourceNode == null) {
            throw new PKIException("sm2HashFile failed: sourceNode==null");
        }
        if (sourceFileOutputPath == null) {
            throw new PKIException("sm2HashFile failed: sourceFileOutputPath==null");
        }
        long startPos = sourceNode.valueStartPos;
        long dataLength = sourceNode.valueLength;
        RandomAccessFile fileReader = null;
        FileOutputStream fileWriter = null;
        boolean supportedWithoutZ = enableWithoutZ && CompatibleAlgorithm.isCompatibleSM2WithoutZ();
        boolean jniFlag = session != null && session.useJniNativeOperation();
        Digest hashWithZ = null;
        Digest hashNoneZ = null;
        try {
            long readTotalLength;
            int readLength;
            byte[] buffer;
            File sourceFile = new File(sourceNode.f.getAbsolutePath());
            if (!sourceFile.exists()) {
                throw new PKIException("sm2HashFile failed: sourceFilePath not exists-->" + sourceFile.getAbsolutePath());
            }
            if (!sourceFile.isFile()) {
                throw new PKIException("sm2HashFile failed: sourceFilePath not file-->" + sourceFile.getAbsolutePath());
            }
            try {
                fileReader = new RandomAccessFile(sourceFile, "r");
            }
            catch (FileNotFoundException e) {
                throw new PKIException("sm2HashFile fileReader failed: " + sourceFile.getAbsolutePath(), e);
            }
            if (sourceFileOutputPath != null && !sourceFileOutputPath.trim().equals("")) {
                try {
                    fileWriter = new FileOutputStream(new File(sourceFileOutputPath));
                }
                catch (FileNotFoundException e) {
                    throw new PKIException("sm2HashFile fileWriter failed: " + sourceFileOutputPath, e);
                }
            }
            try {
                fileReader.seek(startPos);
            }
            catch (IOException e) {
                throw new PKIException("sm2HashFile fileReader seek failed: " + sourceFile.getAbsolutePath(), e);
            }
            Digest digest = hashWithZ = jniFlag ? new JNIDigest(922) : new SM3Digest();
            if (sm2PubKey != null) {
                hashWithZ.update(sm2PubKey.getDefaultZ(), 0, 32);
            }
            if (supportedWithoutZ) {
                hashNoneZ = jniFlag ? new JNIDigest(922) : new SM3Digest();
            }
            if (dataLength > 65536L) {
                buffer = new byte[65536];
                for (readTotalLength = 0L; (readLength = fileReader.read(buffer)) > 0 && readTotalLength < dataLength; readTotalLength += (long)readLength) {
                    if (readTotalLength + (long)readLength <= dataLength) {
                        hashWithZ.update(buffer, 0, readLength);
                        if (supportedWithoutZ) {
                            hashNoneZ.update(buffer, 0, readLength);
                        }
                        if (fileWriter == null) continue;
                        fileWriter.write(buffer, 0, readLength);
                        continue;
                    }
                    int leftLength = (int)(dataLength - readTotalLength);
                    hashWithZ.update(buffer, 0, leftLength);
                    if (supportedWithoutZ) {
                        hashNoneZ.update(buffer, 0, leftLength);
                    }
                    if (fileWriter != null) {
                        fileWriter.write(buffer, 0, leftLength);
                    }
                    readTotalLength += (long)leftLength;
                    break;
                }
            } else {
                buffer = new byte[(int)dataLength];
                readLength = fileReader.read(buffer);
                hashWithZ.update(buffer, 0, readLength);
                if (supportedWithoutZ) {
                    hashNoneZ.update(buffer, 0, readLength);
                }
                if (fileWriter != null) {
                    fileWriter.write(buffer, 0, readLength);
                }
                readTotalLength += (long)readLength;
            }
            if (readTotalLength != dataLength) {
                throw new PKIException(String.format("sm2HashFile failed: readTotalLength(%s)!=dataLength(%s)", readTotalLength, dataLength));
            }
            byte[] hashValueWithZ = new byte[32];
            byte[] hashValueNoneZ = null;
            hashWithZ.doFinal(hashValueWithZ, 0);
            if (supportedWithoutZ) {
                hashValueNoneZ = new byte[32];
                hashNoneZ.doFinal(hashValueNoneZ, 0);
                hashNoneZ = null;
            }
            sM3DualHashResult = new SM3DualHashResult(hashValueWithZ, hashValueNoneZ, supportedWithoutZ);
        }
        catch (IOException e) {
            try {
                throw new PKIException("sm2HashFile fileReader/fileWriter failed", e);
                catch (Exception e2) {
                    throw new PKIException("sm2HashFile fileReader/fileWriter failed", e2);
                }
            }
            catch (Throwable throwable) {
                JNIDigest.destroy(hashWithZ);
                JNIDigest.destroy(hashNoneZ);
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (Exception e3) {
                        LoggerManager.exceptionLogger.error("sm2HashFile failed when closed fileReader", (Throwable)e3);
                    }
                }
                if (fileWriter == null) throw throwable;
                try {
                    fileWriter.close();
                    throw throwable;
                }
                catch (Exception e4) {
                    LoggerManager.exceptionLogger.error("sm2HashFile failed when closed fileWriter", (Throwable)e4);
                }
                throw throwable;
            }
        }
        JNIDigest.destroy(hashWithZ);
        JNIDigest.destroy(hashNoneZ);
        if (fileReader != null) {
            try {
                fileReader.close();
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("sm2HashFile failed when closed fileReader", (Throwable)e);
            }
        }
        if (fileWriter == null) return sM3DualHashResult;
        try {
            fileWriter.close();
            return sM3DualHashResult;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("sm2HashFile failed when closed fileWriter", (Throwable)e);
        }
        return sM3DualHashResult;
    }

    public static final class SM3DualHashResult {
        final boolean supportedWithoutZ;
        final byte[] hashValue;
        final byte[] hashWithoutZ;

        protected SM3DualHashResult(byte[] hashValue, byte[] hashWithoutZ, boolean supportedWithoutZ) {
            this.hashValue = hashValue;
            this.hashWithoutZ = hashWithoutZ;
            this.supportedWithoutZ = supportedWithoutZ;
        }

        public byte[] getHashWithZ() {
            return this.hashValue;
        }

        public byte[] getHashValue() {
            return this.hashValue;
        }

        public byte[] getHashWithoutZ() {
            return this.hashWithoutZ;
        }
    }
}

