/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2HashZValue;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.com.itextpdf.io.source.IRandomAccessSource;
import cfca.sadk.com.itextpdf.io.source.RASInputStream;
import cfca.sadk.com.itextpdf.io.source.RandomAccessSourceFactory;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.signatures.PdfSignature;
import cfca.sadk.com.itextpdf.signatures.SignatureUtil;
import cfca.sadk.lib.crypto.jni.JNIDigest;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.system.Mechanisms;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;

public class PdfHashUtil {
    private static Logger businessLog = LoggerFactory.getLogger(PdfHashUtil.class);

    public static byte[] calculatePdfHash(InputStream inputStream, Mechanism mechanism, SM2PublicKey publicKey) throws SealException {
        PdfDocument document = null;
        if (null == inputStream) {
            throw new SealException("getHashedInfo inputStream is null");
        }
        try {
            byte[] hashData;
            PdfReader reader = new PdfReader(inputStream);
            document = new PdfDocument(reader);
            RASInputStream pdfStream = PdfHashUtil.getHashedInfo(document);
            byte[] byArray = hashData = PdfHashUtil.calculateHashOfSourceData(pdfStream, mechanism, publicKey);
            return byArray;
        }
        catch (SealException e) {
            businessLog.error("calculatePdfHash failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("calculatePdfHash failed", (Throwable)e);
            throw new SealException("calculatePdfHash failed", e);
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    public static byte[] calculatePdfHash(byte[] pdfData, Mechanism mechanism, SM2PublicKey publicKey) throws SealException {
        PdfDocument document = null;
        if (null == pdfData) {
            throw new SealException("getHashedInfo pdfData is null");
        }
        try {
            byte[] hashData;
            PdfReader reader = new PdfReader(pdfData);
            document = new PdfDocument(reader);
            RASInputStream pdfStream = PdfHashUtil.getHashedInfo(document);
            byte[] byArray = hashData = PdfHashUtil.calculateHashOfSourceData(pdfStream, mechanism, publicKey);
            return byArray;
        }
        catch (SealException e) {
            businessLog.error("calculatePdfHash failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("calculatePdfHash failed", (Throwable)e);
            throw new SealException("calculatePdfHash failed", e);
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    public static byte[] calculateHashOfSourceData(RASInputStream rg, Mechanism mechanism, SM2PublicKey publicKey) throws Exception {
        if (null == mechanism) {
            throw new SealException("calculateHashOfSourceData mechanism is null");
        }
        String mechodid = MethodCostTimeUtil.recordStartTime("calculateHashOfSourceData()");
        byte[] buffer = new byte[8192];
        Object digest = null;
        if (Mechanisms.isSM2WithSM3((Mechanism)mechanism)) {
            digest = new SM3Digest();
            if (null != publicKey) {
                byte[] z = SM2HashZValue.getZa((BigInteger)publicKey.getPubX_Int(), (BigInteger)publicKey.getPubY_Int(), (byte[])SM2Params.getDefaultuserid());
                digest.update(z, 0, z.length);
            }
        } else {
            boolean useJNI = SysEnv.isUseJNIForHash();
            try {
                digest = useJNI ? new JNIDigest(Mechanisms.getHashID((Mechanism)mechanism)) : Mechanisms.getDigest((Mechanism)mechanism);
            }
            catch (Exception e) {
                if (useJNI) {
                    businessLog.warn("JNI is not initialized,use softlib ", (Object)e.getMessage());
                    digest = Mechanisms.getDigest((Mechanism)mechanism);
                }
                businessLog.error("get Digest failed", (Throwable)e);
            }
        }
        byte[] hashValue = new byte[digest.getDigestSize()];
        int rLength = rg.read(buffer);
        PDFUtil.checkLength(rg.available());
        do {
            if (rLength < 8192) {
                digest.update(buffer, 0, rLength);
                break;
            }
            digest.update(buffer, 0, buffer.length);
        } while ((rLength = rg.read(buffer)) != -1);
        digest.doFinal(hashValue, 0);
        MethodCostTimeUtil.recordEndTime(mechodid);
        return hashValue;
    }

    private static RASInputStream getHashedInfo(PdfDocument document) throws Exception {
        try {
            SignatureUtil signatureUtil = new SignatureUtil(document);
            List<String> sigNames = signatureUtil.getSignatureNames();
            String lastSigName = sigNames.get(sigNames.size() - 1);
            PdfSignature signature = signatureUtil.getSignature(lastSigName);
            PdfArray b = signature.getByteRange();
            long[] gaps = SignatureUtil.asLongArray(b);
            if (b.size() != 4 || gaps[0] != 0L) {
                throw new IllegalArgumentException("Single exclusion space supported");
            }
            IRandomAccessSource readerSource = document.getReader().getSafeFile().createSourceView();
            RASInputStream rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(readerSource, gaps));
            return rg;
        }
        catch (Exception e) {
            businessLog.error("getHashedInfo failed", (Throwable)e);
            throw e;
        }
    }
}

