/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.ofd.base.common.CrlManager;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertVerifier;
import java.io.File;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.ArrayList;

public class SysEnv {
    private static final Logger sysLog = LoggerFactory.getLogger(SysEnv.class);
    private static boolean trustCertLoaded = false;
    private static boolean crlLoaded = false;
    private static int maxCRLRecode = 100000;
    private static int maxFont = 10;
    private static PrivateKey sealMakerPrivKey;
    private static X509Cert sealMakerSignCert;
    private static boolean isCertListForSeal;
    private static boolean isGBType;
    private static boolean isGM0031;
    private static boolean isAnKeType;
    private static boolean verifyFailedThrowException;
    private static boolean parseFontInfo;
    private static int maxFontFileLength;
    private static boolean isForTax;
    private static int signDateFormat;
    private static boolean isContainTSAStatus;
    private static boolean isCertOctet;
    private static int signTimeOffset;
    private static boolean signTimeUseTST;

    public static void loadCRL(String crlFilePath) throws PKIException, SealException, IOException {
        CrlManager.init(crlFilePath);
        crlLoaded = true;
        sysLog.info("CRL File is loaded,filePath is " + crlFilePath);
    }

    public static void loadTrustCerts(String trustCertPath) throws PKIException {
        if (null == trustCertPath || trustCertPath.isEmpty()) {
            throw new IllegalArgumentException("trustCertPath is null!");
        }
        File trustCertDir = new File(trustCertPath);
        ArrayList<X509Cert> trustCertList = new ArrayList<X509Cert>();
        if (trustCertDir.isDirectory()) {
            File[] files = trustCertDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String singleName = files[i].getName().toLowerCase();
                if (!singleName.endsWith(".cer") && !singleName.endsWith(".pem")) continue;
                sysLog.info("singleName=" + singleName);
                String filePath = files[i].getAbsolutePath();
                try {
                    trustCertList.add(new X509Cert(filePath));
                    continue;
                }
                catch (Exception e) {
                    sysLog.info("singleName=" + singleName, (Throwable)e);
                }
            }
        }
        for (int j = 0; j < trustCertList.size(); ++j) {
            X509CertVerifier.updateTrustCertsMap((X509Cert)((X509Cert)trustCertList.get(j)));
            trustCertLoaded = true;
        }
        sysLog.info("trustCert File is loaded,filePath is " + trustCertPath);
    }

    public static boolean isTrustCertLoaded() {
        return trustCertLoaded;
    }

    public static boolean isCrlLoaded() {
        return crlLoaded;
    }

    public static void setMaxCRLRecode(int maxCRLRecode) {
        SysEnv.maxCRLRecode = maxCRLRecode;
    }

    public static int getMaxCRLRecode() {
        return maxCRLRecode;
    }

    public static int getMaxFont() {
        return maxFont;
    }

    public static void setMaxFont(int maxFont) {
        SysEnv.maxFont = maxFont;
    }

    public static PrivateKey getSealMakerPrivKey() {
        return sealMakerPrivKey;
    }

    public static void setSealMakerPrivKey(PrivateKey sealMakerPrivKey) {
        SysEnv.sealMakerPrivKey = sealMakerPrivKey;
    }

    public static X509Cert getSealMakerSignCert() {
        return sealMakerSignCert;
    }

    public static void setSealMakerSignCert(X509Cert sealMakerSignCert) {
        SysEnv.sealMakerSignCert = sealMakerSignCert;
    }

    public static boolean isCertListForSeal() {
        return isCertListForSeal;
    }

    public static void setCertListForSeal(boolean isCertListForSeal) {
        SysEnv.isCertListForSeal = isCertListForSeal;
    }

    public static boolean isVerifyFailedThrowException() {
        return verifyFailedThrowException;
    }

    public static void setVerifyFailedThrowException(boolean verifyFailedThrowException) {
        SysEnv.verifyFailedThrowException = verifyFailedThrowException;
    }

    public static boolean isParseFontInfo() {
        return parseFontInfo;
    }

    public static void setParseFontInfo(boolean parseFontInfo) {
        SysEnv.parseFontInfo = parseFontInfo;
    }

    public static int getMaxFontFileLength() {
        return maxFontFileLength;
    }

    public static void setMaxFontFileLength(int maxFontFileLength) {
        SysEnv.maxFontFileLength = maxFontFileLength;
    }

    public static boolean isGBType() {
        return isGBType;
    }

    public static void setGBType(boolean isGBType) {
        SysEnv.isGBType = isGBType;
        if (isGBType) {
            isGM0031 = false;
            isAnKeType = false;
            isCertListForSeal = false;
        } else {
            isCertListForSeal = true;
        }
    }

    public static boolean isForTax() {
        return isForTax;
    }

    public static void setForTax(boolean isForTax) {
        SysEnv.isForTax = isForTax;
        if (isForTax) {
            isGBType = true;
            isGM0031 = false;
            isAnKeType = false;
        }
    }

    public static int getSignDateFormat() {
        return signDateFormat;
    }

    public static void setSignDateFormat(int signDateFormat) {
        SysEnv.signDateFormat = signDateFormat;
    }

    public static boolean isAnKeType() {
        return isAnKeType;
    }

    public static void setAnKeType(boolean isAnKeType) {
        SysEnv.isAnKeType = isAnKeType;
        if (isAnKeType) {
            isForTax = false;
            isGBType = false;
            isGM0031 = false;
        }
    }

    public static boolean isContainTSAStatus() {
        return isContainTSAStatus;
    }

    public static void setContainTSAStatus(boolean isContainTSAStatus) {
        SysEnv.isContainTSAStatus = isContainTSAStatus;
    }

    public static boolean isGM0031() {
        return isGM0031;
    }

    public static void setGM0031(boolean isGM0031) {
        SysEnv.isGM0031 = isGM0031;
        if (isGM0031) {
            isForTax = false;
            isGBType = false;
            isAnKeType = false;
            isCertListForSeal = true;
        }
    }

    public static boolean isCertOctet() {
        return isCertOctet;
    }

    public static void setCertOctet(boolean isCertOctet) {
        SysEnv.isCertOctet = isCertOctet;
    }

    public static int getSignTimeOffset() {
        return signTimeOffset;
    }

    public static void setSignTimeOffset(int signTimeOffset) {
        SysEnv.signTimeOffset = signTimeOffset;
    }

    public static boolean isSignTimeUseTST() {
        return signTimeUseTST;
    }

    public static void setSignTimeUseTST(boolean signTimeUseTST) {
        SysEnv.signTimeUseTST = signTimeUseTST;
    }

    static {
        isCertListForSeal = true;
        isGBType = true;
        isGM0031 = false;
        isAnKeType = false;
        verifyFailedThrowException = true;
        parseFontInfo = true;
        maxFontFileLength = 0x1400000;
        isForTax = true;
        signDateFormat = 0;
        isContainTSAStatus = false;
        isCertOctet = true;
        signTimeOffset = -1;
        signTimeUseTST = true;
    }

    public static class SignTimeFormatOption {
        public static final int ASN1GeneralizedTime = 0;
        public static final int SignTimeDateFormat = 1;
    }
}

