/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.org.slf4j.MDC;
import cfca.paperless.client.connector.HttpConnector;
import cfca.paperless.client.tx.transaction.Tx10Transaction;
import cfca.paperless.client.tx.transaction.Tx20Transaction;
import cfca.paperless.client.tx.transaction.Tx30Transaction;
import cfca.paperless.client.tx.transaction.Tx40Transaction;
import cfca.paperless.client.tx.transaction.Tx50Transaction;
import cfca.paperless.client.tx.transaction.Tx60Transaction;
import cfca.paperless.client.tx.transaction.Tx80Transaction;
import cfca.paperless.client.util.CommonUtil;
import cfca.paperless.client.util.JsonUtil;
import cfca.paperless.client.util.ValidateUtil;
import cfca.paperless.dto.RequestDto;
import cfca.paperless.dto.RequestHead;
import cfca.paperless.dto.ResponseDto;
import cfca.paperless.dto.TransType;

public class PaperlessClient {
    public static final Logger logger = LoggerFactory.getLogger(PaperlessClient.class);
    private static final String PROTOCOL_HTTP = "http://";
    private static final String PROTOCOL_HTTPS = "https://";
    private static final String CONTEXT_PATH = "/PaperlessServer";
    private String host = "localhost";
    private String port = "8183";
    private int connectTimeout = 3000;
    private int readTimeout = 10000;
    private boolean isSSL = false;
    private String sslProtocol = "TLSv1.2";
    private String keyStorePath = "";
    private String keyStorePassword = "";
    private String trustStorePath = "";
    private String trustStorePassword = "";

    public PaperlessClient() {
    }

    public PaperlessClient(String host, String port, int connectTimeout, int readTimeout) {
        this.host = host;
        this.port = port;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public ResponseDto execute(RequestDto requestDto) throws Exception {
        long start = System.currentTimeMillis();
        logger.info("PaperlessClient.execute start.");
        String txCode = requestDto.getTxCode();
        if (CommonUtil.isEmpty(txCode)) {
            logger.error("invalid txCode [" + txCode + "]");
            throw new Exception("invalid txCode [" + txCode + "]");
        }
        TransType transType = TransType.getTransType((String)txCode);
        if (transType == null) {
            logger.error("invalid txCode [" + txCode + "]");
            throw new Exception("invalid txCode [" + txCode + "]");
        }
        logger.info("txCode={} description={}", (Object)txCode, (Object)transType.getDescription());
        RequestHead requestHead = requestDto.getHead();
        if (requestHead == null) {
            logger.error("invalid RequestDto.RequestHead ");
            throw new Exception("invalid RequestDto.RequestHead ");
        }
        ValidateUtil.checkRequestHead(requestHead);
        String transactionNo = requestHead.getTransactionNo();
        logger.info("transactionNo={}", (Object)transactionNo);
        ResponseDto responseDto = this.dispatch(transType, requestDto);
        long end = System.currentTimeMillis();
        logger.info("PaperlessClient.execute end. time-taken={}ms", (Object)(end - start));
        return responseDto;
    }

    private String generateUrlString(String appendUrl) {
        StringBuilder url = new StringBuilder();
        if (this.isSSL) {
            url.append(PROTOCOL_HTTPS);
        } else {
            url.append(PROTOCOL_HTTP);
        }
        url.append(this.host).append(":").append(this.port).append(CONTEXT_PATH).append(appendUrl);
        String uri = url.toString();
        return uri;
    }

    private ResponseDto dispatch(TransType transType, RequestDto requestDto) throws Exception {
        long start = System.currentTimeMillis();
        String txCode = transType.getTxCode();
        String httpMethod = transType.getHttpMethod();
        String appendUrl = transType.getAppendUrl();
        String description = transType.getDescription();
        try {
            String transactionNo = requestDto.getHead().getTransactionNo();
            MDC.put((String)"ClientTraceId", (String)transactionNo);
            logger.info("PaperlessClient.dispatch start. txCode={} description={} transactionNo={}", new Object[]{txCode, description, transactionNo});
            String uri = this.generateUrlString(appendUrl);
            logger.info("uri={} httpMethod={} connectTimeout={} readTimeout={}", new Object[]{uri, httpMethod, this.connectTimeout, this.readTimeout});
            if (this.isSSL) {
                logger.info("sslProtocol={} keyStorePath={} trustStorePath={}", new Object[]{this.sslProtocol, this.keyStorePath, this.trustStorePath});
            }
            HttpConnector httpConnector = new HttpConnector(uri, httpMethod, this.connectTimeout, this.readTimeout);
            httpConnector.setSSLConfig(this.isSSL, this.sslProtocol, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword);
            httpConnector.init();
            ResponseDto responseDto = null;
            switch (transType) {
                case Tx1001: {
                    responseDto = new Tx10Transaction().doTx1001(httpConnector, requestDto);
                    break;
                }
                case Tx1002: {
                    responseDto = new Tx10Transaction().doTx1002(httpConnector, requestDto);
                    break;
                }
                case Tx1003: {
                    responseDto = new Tx10Transaction().doTx1003(httpConnector, requestDto);
                    break;
                }
                case Tx1004: {
                    responseDto = new Tx10Transaction().doTx1004(httpConnector, requestDto);
                    break;
                }
                case Tx1005: {
                    responseDto = new Tx10Transaction().doTx1005(httpConnector, requestDto);
                    break;
                }
                case Tx1006: {
                    responseDto = new Tx10Transaction().doTx1006(httpConnector, requestDto);
                    break;
                }
                case Tx1007: {
                    responseDto = new Tx10Transaction().doTx1007(httpConnector, requestDto);
                    break;
                }
                case Tx1008: {
                    responseDto = new Tx10Transaction().doTx1008(httpConnector, requestDto);
                    break;
                }
                case Tx1009: {
                    responseDto = new Tx10Transaction().doTx1009(httpConnector, requestDto);
                    break;
                }
                case Tx1010: {
                    responseDto = new Tx10Transaction().doTx1010(httpConnector, requestDto);
                    break;
                }
                case Tx2001: {
                    responseDto = new Tx20Transaction().doTx2001(httpConnector, requestDto);
                    break;
                }
                case Tx2002: {
                    responseDto = new Tx20Transaction().doTx2002(httpConnector, requestDto);
                    break;
                }
                case Tx2003: {
                    responseDto = new Tx20Transaction().doTx2003(httpConnector, requestDto);
                    break;
                }
                case Tx2004: {
                    responseDto = new Tx20Transaction().doTx2004(httpConnector, requestDto);
                    break;
                }
                case Tx2005: {
                    responseDto = new Tx20Transaction().doTx2005(httpConnector, requestDto);
                    break;
                }
                case Tx2006: {
                    responseDto = new Tx20Transaction().doTx2006(httpConnector, requestDto);
                    break;
                }
                case Tx3001: {
                    responseDto = new Tx30Transaction().doTx3001(httpConnector, requestDto);
                    break;
                }
                case Tx3002: {
                    responseDto = new Tx30Transaction().doTx3002(httpConnector, requestDto);
                    break;
                }
                case Tx3003: {
                    responseDto = new Tx30Transaction().doTx3003(httpConnector, requestDto);
                    break;
                }
                case Tx3004: {
                    responseDto = new Tx30Transaction().doTx3004(httpConnector, requestDto);
                    break;
                }
                case Tx4001: {
                    responseDto = new Tx40Transaction().doTx4001(httpConnector, requestDto);
                    break;
                }
                case Tx4002: {
                    responseDto = new Tx40Transaction().doTx4002(httpConnector, requestDto);
                    break;
                }
                case Tx4003: {
                    responseDto = new Tx40Transaction().doTx4003(httpConnector, requestDto);
                    break;
                }
                case Tx4004: {
                    responseDto = new Tx40Transaction().doTx4004(httpConnector, requestDto);
                    break;
                }
                case Tx4005: {
                    responseDto = new Tx40Transaction().doTx4005(httpConnector, requestDto);
                    break;
                }
                case Tx4006: {
                    responseDto = new Tx40Transaction().doTx4006(httpConnector, requestDto);
                    break;
                }
                case Tx4007: {
                    responseDto = new Tx40Transaction().doTx4007(httpConnector, requestDto);
                    break;
                }
                case Tx4008: {
                    responseDto = new Tx40Transaction().doTx4008(httpConnector, requestDto);
                    break;
                }
                case Tx4009: {
                    responseDto = new Tx40Transaction().doTx4009(httpConnector, requestDto);
                    break;
                }
                case Tx4011: {
                    responseDto = new Tx40Transaction().doTx4011(httpConnector, requestDto);
                    break;
                }
                case Tx4012: {
                    responseDto = new Tx40Transaction().doTx4012(httpConnector, requestDto);
                    break;
                }
                case Tx4013: {
                    responseDto = new Tx40Transaction().doTx4013(httpConnector, requestDto);
                    break;
                }
                case Tx4014: {
                    responseDto = new Tx40Transaction().doTx4014(httpConnector, requestDto);
                    break;
                }
                case Tx4015: {
                    responseDto = new Tx40Transaction().doTx4015(httpConnector, requestDto);
                    break;
                }
                case Tx4016: {
                    responseDto = new Tx40Transaction().doTx4016(httpConnector, requestDto);
                    break;
                }
                case Tx4017: {
                    responseDto = new Tx40Transaction().doTx4017(httpConnector, requestDto);
                    break;
                }
                case Tx4018: {
                    responseDto = new Tx40Transaction().doTx4018(httpConnector, requestDto);
                    break;
                }
                case Tx4019: {
                    responseDto = new Tx40Transaction().doTx4019(httpConnector, requestDto);
                    break;
                }
                case Tx4101: {
                    responseDto = new Tx40Transaction().doTx4101(httpConnector, requestDto);
                    break;
                }
                case Tx4105: {
                    responseDto = new Tx40Transaction().doTx4105(httpConnector, requestDto);
                    break;
                }
                case Tx5001: {
                    responseDto = new Tx50Transaction().doTx5001(httpConnector, requestDto);
                    break;
                }
                case Tx5002: {
                    responseDto = new Tx50Transaction().doTx5002(httpConnector, requestDto);
                    break;
                }
                case Tx5003: {
                    responseDto = new Tx50Transaction().doTx5003(httpConnector, requestDto);
                    break;
                }
                case Tx5004: {
                    responseDto = new Tx50Transaction().doTx5004(httpConnector, requestDto);
                    break;
                }
                case Tx5005: {
                    responseDto = new Tx50Transaction().doTx5005(httpConnector, requestDto);
                    break;
                }
                case Tx6001: {
                    responseDto = new Tx60Transaction().doTx6001(httpConnector, requestDto);
                    break;
                }
                case Tx6002: {
                    responseDto = new Tx60Transaction().doTx6002(httpConnector, requestDto);
                    break;
                }
                case Tx6003: {
                    responseDto = new Tx60Transaction().doTx6003(httpConnector, requestDto);
                    break;
                }
                case Tx8001: {
                    responseDto = new Tx80Transaction().doTx8001(httpConnector, requestDto);
                    break;
                }
                default: {
                    throw new Exception("undefined txcode");
                }
            }
            ResponseDto responseDto2 = responseDto;
            return responseDto2;
        }
        catch (Exception e) {
            logger.error("PaperlessClient.dispatch Exception.", (Throwable)e);
            logger.error("RequestDto=[{}]", (Object)JsonUtil.obj2Json(requestDto));
            String errorInfo = e.getMessage();
            throw new Exception(errorInfo);
        }
        catch (Error e) {
            logger.error("PaperlessClient.dispatch Error.", (Throwable)e);
            logger.error("RequestDto=[{}]", (Object)JsonUtil.obj2Json(requestDto));
            String errorInfo = e.getMessage();
            throw new Exception("PaperlessClient.dispatch Error.[" + errorInfo + "]");
        }
        finally {
            long end = System.currentTimeMillis();
            logger.info("PaperlessClient.dispatch end. txCode={} time-taken={}ms", (Object)txCode, (Object)(end - start));
            MDC.remove((String)"ClientTraceId");
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public void setSSL(boolean isSSL) {
        this.isSSL = isSSL;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }
}

