/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.external;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.signatures.IExternalSignatureContainer;
import cfca.sadk.com.itextpdf.signatures.ITSAClient;
import cfca.sadk.com.itextpdf.signatures.PdfSigner;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.DERUTCTime;
import cfca.sadk.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.pkcs7.PKCS7PackageFacade;
import cfca.sadk.seal.org.bouncycastle.asn1.pkcs.PKCS7SignedData;
import cfca.sadk.seal.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;

public abstract class AbstractExternalP7Signer
implements IExternalSignatureContainer {
    private static Logger businessLog = LoggerFactory.getLogger(AbstractExternalP7Signer.class);
    protected Calendar signingTime = null;
    protected SignInfoConfig signInfoConfig = null;
    private byte[] openPassword = null;

    public Calendar getSigningTime() {
        return this.signingTime;
    }

    public void setSigningTime(Calendar signingTime) {
        this.signingTime = signingTime;
    }

    public void setSignInfoConfig(SignInfoConfig signInfoConfig) {
        this.signInfoConfig = signInfoConfig;
    }

    public SignInfoConfig getSignInfoConfig() {
        return this.signInfoConfig;
    }

    public abstract int getEstimatedSize();

    public Session getSession(Session session) {
        if (session == null) {
            try {
                String deviceName = "JSOFT_LIB";
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (PKIException e) {
                businessLog.error("getSession failed", (Throwable)e);
            }
        }
        return session;
    }

    public byte[] getTimeStamp(ITSAClient tsaClient, byte[] binarySignValue) throws GeneralSecurityException {
        byte[] timeStampPKCS7 = null;
        if (tsaClient != null && binarySignValue != null) {
            String tsaMethod = MethodCostTimeUtil.recordStartTime("getTimeStampToken");
            try {
                timeStampPKCS7 = tsaClient.getTimeStampToken(binarySignValue);
            }
            catch (Exception e1) {
                businessLog.error("request timestamp service failed", (Throwable)e1);
                throw new GeneralSecurityException("request timestamp service failed", e1);
            }
            finally {
                MethodCostTimeUtil.recordEndTime(tsaMethod);
            }
        }
        return timeStampPKCS7;
    }

    protected DERSet getAuthenticatedAttributeSet(byte[] secondDigest, byte[] ocsp, Collection<byte[]> crlBytes, PdfSigner.CryptoStandard sigtype) {
        try {
            ASN1EncodableVector attribute = new ASN1EncodableVector();
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.3"));
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
            attribute.add((ASN1Encodable)new DERSequence(v));
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.4"));
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)new DEROctetString(secondDigest)));
            attribute.add((ASN1Encodable)new DERSequence(v));
            boolean haveCrl = false;
            if (crlBytes != null) {
                for (byte[] bCrl : crlBytes) {
                    if (bCrl == null) continue;
                    haveCrl = true;
                    break;
                }
            }
            return new DERSet(attribute);
        }
        catch (Exception e) {
            throw new PdfException(e);
        }
    }

    protected DERSet getAuthenticatedAttributeSet(byte[] secondDigest, Calendar signingTime, byte[] ocsp, Collection<byte[]> crlBytes, PdfSigner.CryptoStandard sigtype) {
        try {
            ASN1EncodableVector attribute = new ASN1EncodableVector();
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.3"));
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
            attribute.add((ASN1Encodable)new DERSequence(v));
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.5"));
            if (signingTime != null) {
                v.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERUTCTime(signingTime.getTime())));
            }
            attribute.add((ASN1Encodable)new DERSequence(v));
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.4"));
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)new DEROctetString(secondDigest)));
            attribute.add((ASN1Encodable)new DERSequence(v));
            boolean haveCrl = false;
            if (crlBytes != null) {
                for (byte[] bCrl : crlBytes) {
                    if (bCrl == null) continue;
                    haveCrl = true;
                    break;
                }
            }
            return new DERSet(attribute);
        }
        catch (Exception e) {
            throw new PdfException(e);
        }
    }

    protected byte[] p7SignByHash(Mechanism signAlg, byte[] hashValue, PrivateKey privateKey, X509Cert[] certs, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        byte[] binarySignValue = session.signByHash(signAlg, privateKey, hashValue);
        byte[] binaryP7SignedBytes = p7.packageSignedData(false, null, null, binarySignValue, signAlg, certs);
        return binaryP7SignedBytes;
    }

    protected byte[] p7SignByHash(Mechanism signAlg, byte[] p1SignValue, X509Cert[] certs, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        byte[] binaryP7SignedBytes = p7.packageSignedData(false, null, null, p1SignValue, signAlg, certs);
        return binaryP7SignedBytes;
    }

    protected byte[] p7SignByHash(Mechanism signAlg, X509Cert[] certs, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        byte[] signBytes = new byte[]{};
        if (Mechanisms.isSM2WithSM3((Mechanism)signAlg)) {
            signBytes = new byte[64];
        }
        byte[] binaryP7SignedBytes = p7.packageSignedData(false, null, null, signBytes, signAlg, certs);
        return binaryP7SignedBytes;
    }

    protected byte[] rebuildPKCS7(Session session, byte[] pkcs7SignedData, byte[] p1Sig, Mechanism mechanism, byte[] timeStampPKCS7, DERSet derSet, X509Cert[] signerCerts) throws PKIException {
        DERSet unauthenticatedAttributes = null;
        if (timeStampPKCS7 != null) {
            ASN1InputStream tempstream = new ASN1InputStream((InputStream)new ByteArrayInputStream(timeStampPKCS7));
            ASN1EncodableVector unauthAttributes = new ASN1EncodableVector();
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            ASN1Sequence seq = null;
            try {
                seq = (ASN1Sequence)tempstream.readObject();
            }
            catch (IOException e) {
                businessLog.error("parsePKCS7 failed", (Throwable)e);
            }
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)seq));
            unauthAttributes.add((ASN1Encodable)new DERSequence(v));
            unauthenticatedAttributes = new DERSet(unauthAttributes);
        }
        PKCS7SignedData p7Data = new PKCS7SignedData(session);
        if (pkcs7SignedData == null) {
            pkcs7SignedData = p7Data.packageSignedData(false, null, null, p1Sig, mechanism, signerCerts);
        }
        p7Data.loadDERData(pkcs7SignedData);
        ASN1Set signerInfos = p7Data.getSignedData().getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        ASN1EncodableVector signinfoDerV = new ASN1EncodableVector();
        while (signerEnumer.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            if (derSet != null) {
                signerInfo.setAuthenticatedAttributes((ASN1Set)derSet);
            }
            if (unauthenticatedAttributes != null) {
                signerInfo.setUnauthenticatedAttributes((ASN1Set)unauthenticatedAttributes);
            }
            signinfoDerV.add((ASN1Encodable)signerInfo);
        }
        DERSet newSignerInfos = new DERSet(signinfoDerV);
        p7Data.getSignedData().setSignerInfos((ASN1Set)newSignerInfos);
        ASN1ObjectIdentifier signDataOID = PKCSObjectIdentifiers.signedData;
        signDataOID = Mechanisms.isSM2WithSM3((Mechanism)mechanism) ? PKCSObjectIdentifiers.sm2SignedData : PKCSObjectIdentifiers.signedData;
        ContentInfo contentInfoTemp = new ContentInfo(signDataOID, (ASN1Encodable)p7Data.getSignedData());
        return ASN1Parser.parseDERObj2Bytes((ASN1Encodable)contentInfoTemp);
    }

    protected byte[] packagePKCS7(Session session, byte[] pkcs7SignedData, byte[] p1Sig, Mechanism mechanism, byte[] timeStampPKCS7, DERSet derSet, X509Cert[] signerCerts, byte[] sourceData) throws PKIException {
        DERSet unauthenticatedAttributes = null;
        if (timeStampPKCS7 != null) {
            ASN1InputStream tempstream = new ASN1InputStream((InputStream)new ByteArrayInputStream(timeStampPKCS7));
            ASN1EncodableVector unauthAttributes = new ASN1EncodableVector();
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            ASN1Sequence seq = null;
            try {
                seq = (ASN1Sequence)tempstream.readObject();
            }
            catch (IOException e) {
                businessLog.error("parsePKCS7 failed", (Throwable)e);
            }
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)seq));
            unauthAttributes.add((ASN1Encodable)new DERSequence(v));
            unauthenticatedAttributes = new DERSet(unauthAttributes);
        }
        boolean ifAttach = sourceData != null;
        return PKCS7PackageFacade.packageSignedData(ifAttach, null, sourceData, p1Sig, mechanism, signerCerts, (ASN1Set)derSet, unauthenticatedAttributes);
    }

    protected byte[] packagePKCS7(Session session, byte[] pkcs7SignedData, byte[] p1Sig, Mechanism mechanism, byte[] timeStampPKCS7, DERSet derSet, X509Cert[] signerCerts) throws PKIException {
        return this.packagePKCS7(session, pkcs7SignedData, p1Sig, mechanism, timeStampPKCS7, derSet, signerCerts, null);
    }

    public void setTsaClient(ITSAClient tsaClient) {
    }

    public void setOriginHash(byte[] originHash) {
    }

    public byte[] getOpenPassword() {
        return this.openPassword;
    }

    public void setOpenPassword(byte[] openPassword) {
        this.openPassword = openPassword;
    }

    public byte[] getHashValue() {
        return null;
    }

    protected final byte[] SM2RStoASN1(byte[] signData) throws PKIException {
        byte[] outBytes = null;
        if (signData != null && signData.length == 64) {
            try {
                byte[] R32Bytes = new byte[32];
                byte[] S32Bytes = new byte[32];
                System.arraycopy(signData, 0, R32Bytes, 0, 32);
                System.arraycopy(signData, 32, S32Bytes, 0, 32);
                ASN1EncodableVector rsV = new ASN1EncodableVector();
                rsV.add((ASN1Encodable)BigIntegers.fromByteArray((byte[])R32Bytes, (int)32));
                rsV.add((ASN1Encodable)BigIntegers.fromByteArray((byte[])S32Bytes, (int)32));
                DERSequence rsSequence = new DERSequence(rsV);
                outBytes = rsSequence.getEncoded();
            }
            catch (Exception e) {
                throw new PKIException("SM2Signature Encoded Failure", (Throwable)e);
            }
        } else {
            outBytes = signData;
        }
        return outBytes;
    }

    protected byte[] GetP1SignatureValue(byte[] signedData) {
        byte[] outSignatureBytes = null;
        try {
            if (signedData.length == 64) {
                outSignatureBytes = signedData;
            } else if (signedData.length <= 72 && ASN1Parser.isDERSequence((byte[])signedData)) {
                outSignatureBytes = this.SM2ASN1toRS(signedData);
            } else {
                byte[] encoding = Base64.decode((byte[])signedData);
                if (encoding.length == 64) {
                    outSignatureBytes = encoding;
                } else if (ASN1Parser.isDERSequence((byte[])encoding)) {
                    outSignatureBytes = this.SM2ASN1toRS(encoding);
                } else {
                    throw new PKIException("Invalid signatureValue: required binary or base64, signedData=" + SADKDebugger.dump((byte[])signedData));
                }
            }
            return outSignatureBytes;
        }
        catch (Exception e) {
            businessLog.error("SM2ASN1toRS failed", (Throwable)e);
            return signedData;
        }
    }

    private final byte[] SM2ASN1toRS(byte[] asn1SM2RSValue) throws PKIException {
        try {
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)asn1SM2RSValue);
            ASN1Integer R = (ASN1Integer)sequence.getObjectAt(0);
            ASN1Integer S = (ASN1Integer)sequence.getObjectAt(1);
            byte[] R32Bytes = BigIntegerUtil.asUnsigned32ByteArray((BigInteger)R.getPositiveValue());
            byte[] S32Bytes = BigIntegerUtil.asUnsigned32ByteArray((BigInteger)S.getPositiveValue());
            byte[] SM2RS64Bytes = new byte[64];
            System.arraycopy(R32Bytes, 0, SM2RS64Bytes, 0, 32);
            System.arraycopy(S32Bytes, 0, SM2RS64Bytes, 32, 32);
            return SM2RS64Bytes;
        }
        catch (Exception e) {
            businessLog.error("SM2ASN1toRS::<<<<<<Failure(SM2Signature Decoded Failure): asn1SM2RSValue=" + SADKDebugger.dump((byte[])asn1SM2RSValue), (Throwable)e);
            throw new PKIException("SM2Signature Decoded Failure", (Throwable)e);
        }
    }
}

