/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.org.slf4j.MDC;
import cfca.paperless.client.sdk.AddWaterMarkToPdfProcess;
import cfca.paperless.client.sdk.ConcatPdfListProcess;
import cfca.paperless.client.sdk.MakeSealImageProcess;
import cfca.paperless.client.sdk.SynthesizeBusinessDataProcess;
import cfca.paperless.client.sdk.SynthesizeMultiDataProcess;
import cfca.paperless.client.sdk.TransformImageToPdfProcess;
import cfca.paperless.client.sdk.TransformPdfToImageProcess;
import cfca.paperless.client.sdk.VerifyPdfSealProcess;
import cfca.paperless.client.util.CommonUtil;
import cfca.paperless.client.util.JsonUtil;
import cfca.paperless.client.util.ValidateUtil;
import cfca.paperless.dto.RequestDto;
import cfca.paperless.dto.RequestHead;
import cfca.paperless.dto.ResponseDto;
import cfca.paperless.dto.TransType;
import cfca.paperless.dto.request.tx10.AddWaterMarkToPdfRequest;
import cfca.paperless.dto.request.tx10.ConcatPdfListRequest;
import cfca.paperless.dto.request.tx10.SynthesizeBusinessDataRequest;
import cfca.paperless.dto.request.tx10.SynthesizeMultiDataRequest;
import cfca.paperless.dto.request.tx20.MakeCircleSealImageRequest;
import cfca.paperless.dto.request.tx20.MakeRectangleSealImageRequest;
import cfca.paperless.dto.request.tx20.MakeSquareSealImageRequest;
import cfca.paperless.dto.request.tx30.TransformImageToPdfRequest;
import cfca.paperless.dto.request.tx30.TransformPdfToImageRequest;
import cfca.paperless.dto.request.tx40.VerifyPdfSealRequest;
import cfca.paperless.dto.response.tx10.SynthesizeBusinessDataResponse;
import java.util.Map;

public class PaperlessClientProcessor {
    public static final Logger logger = LoggerFactory.getLogger(PaperlessClientProcessor.class);

    public ResponseDto execute(RequestDto requestDto) throws Exception {
        return this.execute(requestDto, null);
    }

    public ResponseDto execute(RequestDto requestDto, Map<String, String> parameterMap) throws Exception {
        long start = System.currentTimeMillis();
        logger.info("PaperlessClientProcessor.execute start.");
        String txCode = requestDto.getTxCode();
        if (CommonUtil.isEmpty(txCode)) {
            logger.error("invalid txCode [" + txCode + "]");
            throw new Exception("invalid txCode [" + txCode + "]");
        }
        TransType transType = TransType.getTransType((String)txCode);
        if (transType == null) {
            logger.error("invalid txCode [" + txCode + "]");
            throw new Exception("invalid txCode [" + txCode + "]");
        }
        logger.info("txCode={} description={}", (Object)txCode, (Object)transType.getDescription());
        RequestHead requestHead = requestDto.getHead();
        if (requestHead == null) {
            logger.error("invalid RequestDto.RequestHead ");
            throw new Exception("invalid RequestDto.RequestHead ");
        }
        ValidateUtil.checkRequestHead(requestHead);
        String transactionNo = requestHead.getTransactionNo();
        logger.info("transactionNo={}", (Object)transactionNo);
        ResponseDto responseDto = this.dispatch(transType, requestDto, parameterMap);
        long end = System.currentTimeMillis();
        logger.info("PaperlessClientProcessor.execute end. time-taken={}ms", (Object)(end - start));
        return responseDto;
    }

    private ResponseDto dispatch(TransType transType, RequestDto requestDto, Map<String, String> parameterMap) throws Exception {
        long start = System.currentTimeMillis();
        String txCode = transType.getTxCode();
        String description = transType.getDescription();
        try {
            String transactionNo = requestDto.getHead().getTransactionNo();
            MDC.put((String)"ClientTraceId", (String)transactionNo);
            logger.info("PaperlessClientProcessor.dispatch start. txCode={} description={} transactionNo={}", new Object[]{txCode, description, transactionNo});
            SynthesizeBusinessDataResponse responseDto = null;
            switch (transType) {
                case Tx1003: {
                    responseDto = new SynthesizeBusinessDataProcess().process((SynthesizeBusinessDataRequest)requestDto);
                    break;
                }
                case Tx1004: {
                    responseDto = new SynthesizeMultiDataProcess().process((SynthesizeMultiDataRequest)requestDto);
                    break;
                }
                case Tx1005: {
                    responseDto = new ConcatPdfListProcess().process((ConcatPdfListRequest)requestDto);
                    break;
                }
                case Tx1006: {
                    responseDto = new AddWaterMarkToPdfProcess().process((AddWaterMarkToPdfRequest)requestDto);
                    break;
                }
                case Tx2001: {
                    responseDto = new MakeSealImageProcess().process((MakeSquareSealImageRequest)requestDto);
                    break;
                }
                case Tx2002: {
                    responseDto = new MakeSealImageProcess().process((MakeRectangleSealImageRequest)requestDto);
                    break;
                }
                case Tx2003: {
                    responseDto = new MakeSealImageProcess().process((MakeCircleSealImageRequest)requestDto, parameterMap);
                    break;
                }
                case Tx3003: {
                    responseDto = new TransformImageToPdfProcess().process((TransformImageToPdfRequest)requestDto);
                    break;
                }
                case Tx3004: {
                    responseDto = new TransformPdfToImageProcess().process((TransformPdfToImageRequest)requestDto);
                    break;
                }
                case Tx4005: {
                    responseDto = new VerifyPdfSealProcess().process((VerifyPdfSealRequest)requestDto);
                    break;
                }
                default: {
                    throw new Exception("undefined txcode");
                }
            }
            SynthesizeBusinessDataResponse synthesizeBusinessDataResponse = responseDto;
            return synthesizeBusinessDataResponse;
        }
        catch (Exception e) {
            logger.error("PaperlessClientProcessor.dispatch Exception.", (Throwable)e);
            logger.error("RequestDto=[{}]", (Object)JsonUtil.obj2Json(requestDto));
            throw new Exception("PaperlessClientProcessor.dispatch Exception.", e);
        }
        catch (Error e) {
            logger.error("PaperlessClientProcessor.dispatch Error.", (Throwable)e);
            logger.error("RequestDto=[{}]", (Object)JsonUtil.obj2Json(requestDto));
            throw new Exception("PaperlessClientProcessor.dispatch Error.", e);
        }
        finally {
            long end = System.currentTimeMillis();
            logger.info("PaperlessClientProcessor.dispatch end. txCode={} time-taken={}ms", (Object)txCode, (Object)(end - start));
            MDC.remove((String)"ClientTraceId");
        }
    }
}

