/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.log;

import cfca.com.itextpdf.text.log.Appender;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileAppender
implements Appender {
    private String logFolderPath;
    private FileWriter writer;

    public FileAppender(String logFolderPath) {
        this.logFolderPath = logFolderPath;
    }

    public void appendStart() {
        File file = new File(this.logFolderPath);
        boolean isExisted = file.exists();
        if (!isExisted) {
            file.mkdirs();
            String absolutePath = file.getAbsolutePath();
            String logFilePath = absolutePath + "/log.log";
            try {
                this.writer = new FileWriter(logFilePath, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            String absolutePath = file.getAbsolutePath();
            String logFilePath = absolutePath + "/log.log";
            File logFile = new File(logFilePath);
            boolean isLogFileExisted = logFile.exists();
            if (isLogFileExisted) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                Date date = new Date();
                String dateFormatString = sdf.format(date);
                String backLogFilePath = "log-" + dateFormatString + "-.log";
            } else {
                try {
                    this.writer = new FileWriter(logFilePath, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void appendStop() {
        try {
            this.writer.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        File file = new File(this.logFolderPath);
        String absolutePath = file.getAbsolutePath();
        String logFilePath = absolutePath + "/log.log";
        File logFile = new File(logFilePath);
        long lastModified = logFile.lastModified();
        long nowMillis = System.currentTimeMillis();
        if (nowMillis - lastModified <= 86400000L) {
            return;
        }
        int fileLength = (int)logFile.length();
        if (fileLength <= 0x40000000) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date = new Date();
        String dateFormatString = sdf.format(date);
        String backLogFilePath = "log-" + dateFormatString + "-.log";
        try {
            FileOutputStream fos = new FileOutputStream(backLogFilePath);
            FileInputStream fis = new FileInputStream(logFile);
            byte[] data = new byte[fileLength];
            fis.read(data);
            fos.write(data, 0, fileLength);
            fis.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logFile.delete();
    }

    public void appendString(String logString) {
    }

    public static void main(String[] args) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date1 = new Date();
        String xx = sdf.format(date1);
        try {
            Date date2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(xx);
            String yy = sdf.format(date2);
            System.out.println(xx);
            System.out.println(yy);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

