/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.security;

import cfca.com.itextpdf.text.log.Logger;
import cfca.com.itextpdf.text.log.LoggerFactory;
import cfca.com.itextpdf.text.pdf.AcroFields;
import cfca.com.itextpdf.text.pdf.PRStream;
import cfca.com.itextpdf.text.pdf.PdfArray;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.security.CRLVerifier;
import cfca.com.itextpdf.text.pdf.security.CertificateVerifier;
import cfca.com.itextpdf.text.pdf.security.LtvVerification;
import cfca.com.itextpdf.text.pdf.security.OCSPVerifier;
import cfca.com.itextpdf.text.pdf.security.PdfPKCS7;
import cfca.com.itextpdf.text.pdf.security.RootStoreVerifier;
import cfca.com.itextpdf.text.pdf.security.VerificationException;
import cfca.com.itextpdf.text.pdf.security.VerificationOK;
import cfca.sadk.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import cfca.sadk.org.bouncycastle.cert.ocsp.OCSPException;
import cfca.sadk.org.bouncycastle.cert.ocsp.OCSPResp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LtvVerifier
extends RootStoreVerifier {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LtvVerifier.class);
    protected LtvVerification.CertificateOption option = LtvVerification.CertificateOption.SIGNING_CERTIFICATE;
    protected boolean verifyRootCertificate = true;
    protected PdfReader reader;
    protected AcroFields fields;
    protected Date signDate;
    protected String signatureName;
    protected PdfPKCS7 pkcs7;
    protected boolean latestRevision = true;
    protected PdfDictionary dss;

    public LtvVerifier(PdfReader reader) throws GeneralSecurityException {
        super(null);
        this.reader = reader;
        this.fields = reader.getAcroFields();
        ArrayList<String> names = this.fields.getSignatureNames();
        this.signatureName = (String)names.get(names.size() - 1);
        this.signDate = new Date();
        this.pkcs7 = this.coversWholeDocument();
        LOGGER.info(String.format("Checking %ssignature %s", this.pkcs7.isTsp() ? "document-level timestamp " : "", this.signatureName));
    }

    public void setVerifier(CertificateVerifier verifier) {
        this.verifier = verifier;
    }

    public void setCertificateOption(LtvVerification.CertificateOption option) {
        this.option = option;
    }

    public void setVerifyRootCertificate(boolean verifyRootCertificate) {
        this.verifyRootCertificate = verifyRootCertificate;
    }

    protected PdfPKCS7 coversWholeDocument() throws GeneralSecurityException {
        PdfPKCS7 pkcs7 = this.fields.verifySignature(this.signatureName);
        if (!this.fields.signatureCoversWholeDocument(this.signatureName)) {
            throw new VerificationException(null, "Signature doesn't cover whole document.");
        }
        LOGGER.info("The timestamp covers whole document.");
        if (pkcs7.verify()) {
            LOGGER.info("The signed document has not been modified.");
            return pkcs7;
        }
        throw new VerificationException(null, "The document was altered after the final signature was applied.");
    }

    public List<VerificationOK> verify(List<VerificationOK> result) throws IOException, GeneralSecurityException {
        if (result == null) {
            result = new ArrayList<VerificationOK>();
        }
        while (this.pkcs7 != null) {
            result.addAll(this.verifySignature());
        }
        return result;
    }

    public List<VerificationOK> verifySignature() throws GeneralSecurityException, IOException {
        LOGGER.info("Verifying signature.");
        ArrayList<VerificationOK> result = new ArrayList<VerificationOK>();
        Certificate[] chain = this.pkcs7.getSignCertificateChain();
        this.verifyChain(chain);
        int total = 1;
        if (LtvVerification.CertificateOption.WHOLE_CHAIN.equals((Object)this.option)) {
            total = chain.length;
        }
        int i = 0;
        while (i < total) {
            X509Certificate signCert = (X509Certificate)chain[i++];
            X509Certificate issuerCert = null;
            if (i < chain.length) {
                issuerCert = (X509Certificate)chain[i];
            }
            LOGGER.info(signCert.getSubjectDN().getName());
            List<VerificationOK> list = this.verify(signCert, issuerCert, this.signDate);
            if (list.size() == 0) {
                try {
                    signCert.verify(signCert.getPublicKey());
                    if (this.latestRevision && chain.length > 1) {
                        list.add(new VerificationOK(signCert, this.getClass(), "Root certificate in final revision"));
                    }
                    if (list.size() == 0 && this.verifyRootCertificate) {
                        throw new GeneralSecurityException();
                    }
                    if (chain.length > 1) {
                        list.add(new VerificationOK(signCert, this.getClass(), "Root certificate passed without checking"));
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new VerificationException(signCert, "Couldn't verify with CRL or OCSP or trusted anchor");
                }
            }
            result.addAll(list);
        }
        this.switchToPreviousRevision();
        return result;
    }

    public void verifyChain(Certificate[] chain) throws GeneralSecurityException {
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate cert = (X509Certificate)chain[i];
            cert.checkValidity(this.signDate);
            if (i <= 0) continue;
            chain[i - 1].verify(chain[i].getPublicKey());
        }
        LOGGER.info("All certificates are valid on " + this.signDate.toString());
    }

    @Override
    public List<VerificationOK> verify(X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException, IOException {
        RootStoreVerifier rootStoreVerifier = new RootStoreVerifier(this.verifier);
        rootStoreVerifier.setRootStore(this.rootStore);
        CRLVerifier crlVerifier = new CRLVerifier(rootStoreVerifier, this.getCRLsFromDSS());
        crlVerifier.setRootStore(this.rootStore);
        crlVerifier.setOnlineCheckingAllowed(this.latestRevision || this.onlineCheckingAllowed);
        OCSPVerifier ocspVerifier = new OCSPVerifier(crlVerifier, this.getOCSPResponsesFromDSS());
        ocspVerifier.setRootStore(this.rootStore);
        ocspVerifier.setOnlineCheckingAllowed(this.latestRevision || this.onlineCheckingAllowed);
        return ocspVerifier.verify(signCert, issuerCert, signDate);
    }

    public void switchToPreviousRevision() throws IOException, GeneralSecurityException {
        LOGGER.info("Switching to previous revision.");
        this.latestRevision = false;
        this.dss = this.reader.getCatalog().getAsDict(PdfName.DSS);
        Calendar cal = this.pkcs7.getTimeStampDate();
        if (cal == null) {
            cal = this.pkcs7.getSignDate();
        }
        this.signDate = cal.getTime();
        ArrayList<String> names = this.fields.getSignatureNames();
        if (names.size() > 1) {
            this.signatureName = (String)names.get(names.size() - 2);
            this.reader = new PdfReader(this.fields.extractRevision(this.signatureName));
            this.fields = this.reader.getAcroFields();
            names = this.fields.getSignatureNames();
            this.signatureName = (String)names.get(names.size() - 1);
            this.pkcs7 = this.coversWholeDocument();
            LOGGER.info(String.format("Checking %ssignature %s", this.pkcs7.isTsp() ? "document-level timestamp " : "", this.signatureName));
        } else {
            LOGGER.info("No signatures in revision");
            this.pkcs7 = null;
        }
    }

    public List<X509CRL> getCRLsFromDSS() throws GeneralSecurityException, IOException {
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        if (this.dss == null) {
            return crls;
        }
        PdfArray crlarray = this.dss.getAsArray(PdfName.CRLS);
        if (crlarray == null) {
            return crls;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < crlarray.size(); ++i) {
            PRStream stream = (PRStream)crlarray.getAsStream(i);
            X509CRL crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(PdfReader.getStreamBytes(stream)));
            crls.add(crl);
        }
        return crls;
    }

    public List<BasicOCSPResp> getOCSPResponsesFromDSS() throws IOException, GeneralSecurityException {
        ArrayList<BasicOCSPResp> ocsps = new ArrayList<BasicOCSPResp>();
        if (this.dss == null) {
            return ocsps;
        }
        PdfArray ocsparray = this.dss.getAsArray(PdfName.OCSPS);
        if (ocsparray == null) {
            return ocsps;
        }
        for (int i = 0; i < ocsparray.size(); ++i) {
            PRStream stream = (PRStream)ocsparray.getAsStream(i);
            OCSPResp ocspResponse = new OCSPResp(PdfReader.getStreamBytes(stream));
            if (ocspResponse.getStatus() != 0) continue;
            try {
                ocsps.add((BasicOCSPResp)ocspResponse.getResponseObject());
                continue;
            }
            catch (OCSPException e) {
                throw new GeneralSecurityException(e);
            }
        }
        return ocsps;
    }
}

