/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.html.table;

import cfca.com.itextpdf.text.Chunk;
import cfca.com.itextpdf.text.Element;
import cfca.com.itextpdf.text.List;
import cfca.com.itextpdf.text.ListItem;
import cfca.com.itextpdf.text.Paragraph;
import cfca.com.itextpdf.text.pdf.draw.LineSeparator;
import cfca.com.itextpdf.tool.xml.NoCustomContextException;
import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.WorkerContext;
import cfca.com.itextpdf.tool.xml.exceptions.LocaleMessages;
import cfca.com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import cfca.com.itextpdf.tool.xml.html.AbstractTagProcessor;
import cfca.com.itextpdf.tool.xml.html.pdfelement.HtmlCell;
import cfca.com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import cfca.com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableData
extends AbstractTagProcessor {
    @Override
    public java.util.List<Element> content(WorkerContext ctx, Tag tag, String content) {
        return this.textContent(ctx, tag, content);
    }

    @Override
    public java.util.List<Element> end(WorkerContext ctx, Tag tag, java.util.List<Element> currentContent) {
        HtmlCell cell = new HtmlCell();
        int direction = this.getRunDirection(tag);
        if (direction != 0) {
            cell.setRunDirection(direction);
        }
        try {
            HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
            cell = (HtmlCell)this.getCssAppliers().apply(cell, tag, htmlPipelineContext);
        }
        catch (NoCustomContextException e1) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e1);
        }
        ArrayList<Element> l = new ArrayList<Element>(1);
        ArrayList<Element> chunks = new ArrayList<Element>();
        ArrayList<ListItem> listItems = new ArrayList<ListItem>();
        int index = -1;
        for (Element e : currentContent) {
            ++index;
            if (e instanceof Chunk || e instanceof NoNewLineParagraph || e instanceof LineSeparator) {
                if (!listItems.isEmpty()) {
                    this.processListItems(ctx, tag, listItems, cell);
                }
                if (e instanceof Chunk && Chunk.NEWLINE.getContent().equals(((Chunk)e).getContent())) {
                    if (index == currentContent.size() - 1) continue;
                    Element nextElement = currentContent.get(index + 1);
                    if (!(chunks.isEmpty() || nextElement instanceof Chunk || nextElement instanceof NoNewLineParagraph)) {
                        continue;
                    }
                } else if (e instanceof LineSeparator) {
                    try {
                        HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
                        Chunk newLine = (Chunk)this.getCssAppliers().apply(new Chunk(Chunk.NEWLINE), tag, htmlPipelineContext);
                        chunks.add(newLine);
                    }
                    catch (NoCustomContextException e1) {
                        throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e1);
                    }
                }
                chunks.add(e);
                continue;
            }
            if (e instanceof ListItem) {
                if (!chunks.isEmpty()) {
                    this.processChunkItems(chunks, cell);
                }
                listItems.add((ListItem)e);
                continue;
            }
            if (!chunks.isEmpty()) {
                this.processChunkItems(chunks, cell);
            }
            if (!listItems.isEmpty()) {
                this.processListItems(ctx, tag, listItems, cell);
            }
            if (e instanceof Paragraph && ((Paragraph)e).getAlignment() == -1) {
                ((Paragraph)e).setAlignment(cell.getHorizontalAlignment());
            }
            cell.addElement(e);
        }
        if (!chunks.isEmpty()) {
            this.processChunkItems(chunks, cell);
        }
        l.add(cell);
        return l;
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }

    private void processChunkItems(java.util.List<Element> chunks, HtmlCell cell) {
        Paragraph p = new Paragraph();
        p.setMultipliedLeading(1.2f);
        p.addAll((Collection<? extends Element>)chunks);
        p.setAlignment(cell.getHorizontalAlignment());
        if (p.trim()) {
            cell.addElement(p);
        }
        chunks.clear();
    }

    private void processListItems(WorkerContext ctx, Tag tag, java.util.List<ListItem> listItems, HtmlCell cell) {
        try {
            List list = new List();
            list.setAutoindent(false);
            list = (List)this.getCssAppliers().apply(list, tag, this.getHtmlPipelineContext(ctx));
            list.setIndentationLeft(0.0f);
            for (ListItem li : listItems) {
                li = (ListItem)this.getCssAppliers().apply(li, tag, this.getHtmlPipelineContext(ctx));
                li.setSpacingAfter(0.0f);
                li.setSpacingBefore(0.0f);
                li.setMultipliedLeading(1.2f);
                list.add(li);
            }
            cell.addElement(list);
            listItems.clear();
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }
}

