/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.opentype;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.ClassDefTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.CoverageTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.SubstSubtable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubClassSetArray;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubGenericRuleSet;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.chaincontextsubst.ChainSubRuleSetArray;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.chaincontextsubst.InnerArraysFmt3;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.NumRecordList;

public class ChainContextSubst
extends SubstSubtable {
    private final ChainSubRuleSetArray ruleSets;
    private final ChainSubClassSetArray classSets;
    public final InnerArraysFmt3 fmt3Array;

    ChainContextSubst(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data, base, dataIsCanonical);
        switch (this.format) {
            case 1: {
                this.ruleSets = new ChainSubRuleSetArray(data, this.headerSize(), dataIsCanonical);
                this.classSets = null;
                this.fmt3Array = null;
                break;
            }
            case 2: {
                this.ruleSets = null;
                this.classSets = new ChainSubClassSetArray(data, this.headerSize(), dataIsCanonical);
                this.fmt3Array = null;
                break;
            }
            case 3: {
                this.ruleSets = null;
                this.classSets = null;
                this.fmt3Array = new InnerArraysFmt3(data, this.headerSize(), dataIsCanonical);
                break;
            }
            default: {
                throw new IllegalStateException("Subt format value is " + this.format + " (should be 1 or 2).");
            }
        }
    }

    public ChainSubRuleSetArray fmt1Table() {
        switch (this.format) {
            case 1: {
                return this.ruleSets;
            }
        }
        throw new IllegalArgumentException("unexpected format table requested: " + this.format);
    }

    public ChainSubClassSetArray fmt2Table() {
        switch (this.format) {
            case 2: {
                return this.classSets;
            }
        }
        throw new IllegalArgumentException("unexpected format table requested: " + this.format);
    }

    public InnerArraysFmt3 fmt3Table() {
        switch (this.format) {
            case 3: {
                return this.fmt3Array;
            }
        }
        throw new IllegalArgumentException("unexpected format table requested: " + this.format);
    }

    public NumRecordList recordList() {
        switch (this.format) {
            case 1: {
                return this.ruleSets.recordList;
            }
            case 2: {
                return this.classSets.recordList;
            }
        }
        return null;
    }

    public ChainSubGenericRuleSet<?> subTableAt(int index) {
        switch (this.format) {
            case 1: {
                return (ChainSubGenericRuleSet)this.ruleSets.subTableAt(index);
            }
            case 2: {
                return (ChainSubGenericRuleSet)this.classSets.subTableAt(index);
            }
        }
        return null;
    }

    public CoverageTable coverage() {
        switch (this.format) {
            case 1: {
                return this.ruleSets.coverage;
            }
            case 2: {
                return this.classSets.coverage;
            }
        }
        return null;
    }

    public ClassDefTable backtrackClassDef() {
        return this.format == 2 ? this.classSets.backtrackClassDef : null;
    }

    public ClassDefTable inputClassDef() {
        return this.format == 2 ? this.classSets.inputClassDef : null;
    }

    public ClassDefTable lookAheadClassDef() {
        return this.format == 2 ? this.classSets.lookAheadClassDef : null;
    }

    protected static class Builder
    extends SubstSubtable.Builder<SubstSubtable> {
        private final ChainSubRuleSetArray.Builder arrayBuilder;

        protected Builder() {
            this.arrayBuilder = new ChainSubRuleSetArray.Builder();
        }

        protected Builder(ReadableFontData data, boolean dataIsCanonical) {
            super(data, dataIsCanonical);
            this.arrayBuilder = new ChainSubRuleSetArray.Builder(data, dataIsCanonical);
        }

        protected Builder(SubstSubtable subTable) {
            ChainContextSubst ligSubst = (ChainContextSubst)subTable;
            this.arrayBuilder = new ChainSubRuleSetArray.Builder(ligSubst.ruleSets);
        }

        @Override
        public int subDataSizeToSerialize() {
            return this.arrayBuilder.subDataSizeToSerialize();
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            return this.arrayBuilder.subSerialize(newData);
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        public void subDataSet() {
            this.arrayBuilder.subDataSet();
        }

        @Override
        public ChainContextSubst subBuildTable(ReadableFontData data) {
            return new ChainContextSubst(data, 0, true);
        }
    }
}

