/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.access.net;

import cfca.ch.qos.logback.access.net.HardenedAccessEventInputStream;
import cfca.ch.qos.logback.access.spi.AccessContext;
import cfca.ch.qos.logback.access.spi.IAccessEvent;
import cfca.ch.qos.logback.core.spi.FilterReply;
import cfca.logback.util.SystemUtil;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class SocketNode
implements Runnable {
    Socket socket;
    AccessContext context;
    HardenedAccessEventInputStream hardenedOIS;

    public SocketNode(Socket socket, AccessContext context) {
        this.socket = socket;
        this.context = context;
        try {
            this.hardenedOIS = new HardenedAccessEventInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (Exception e) {
            SystemUtil.OUT.println("Could not open HardenedObjectInputStream to " + socket + e);
        }
    }

    @Override
    public void run() {
        try {
            IAccessEvent event;
            while (this.context.getFilterChainDecision(event = (IAccessEvent)this.hardenedOIS.readObject()) != FilterReply.DENY) {
                this.context.callAppenders(event);
            }
        }
        catch (EOFException e) {
            SystemUtil.OUT.println("Caught java.io.EOFException closing connection.");
        }
        catch (SocketException e) {
            SystemUtil.OUT.println("Caught java.net.SocketException closing connection.");
        }
        catch (IOException e) {
            SystemUtil.OUT.println("Caught java.io.IOException: " + e);
            SystemUtil.OUT.println("Closing connection.");
        }
        catch (Exception e) {
            SystemUtil.OUT.println("Unexpected exception. Closing connection." + e);
        }
        try {
            this.hardenedOIS.close();
        }
        catch (Exception e) {
            SystemUtil.OUT.println("Could not close connection." + e);
        }
    }
}

