/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.opentype.component;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.FontDataTable;
import cfca.sadk.com.google.typography.font.sfntly.table.SubTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.HeaderTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.NumRecord;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.NumRecordList;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.VisibleSubTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class OffsetRecordTable<S extends SubTable>
extends HeaderTable
implements Iterable<S> {
    public final NumRecordList recordList;

    protected OffsetRecordTable(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data, base, dataIsCanonical);
        this.recordList = new NumRecordList(data.slice(base + this.headerSize()));
    }

    protected OffsetRecordTable(ReadableFontData data, boolean dataIsCanonical) {
        this(data, 0, dataIsCanonical);
    }

    protected OffsetRecordTable(NumRecordList records) {
        super(records.readData, records.base, false);
        this.recordList = records;
    }

    public int subTableCount() {
        return this.recordList.count();
    }

    public S subTableAt(int index) {
        NumRecord record = (NumRecord)this.recordList.get(index);
        return this.subTableForRecord(record);
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            Iterator<NumRecord> recordIterator;
            {
                this.recordIterator = OffsetRecordTable.this.recordList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.recordIterator.hasNext();
            }

            @Override
            public S next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                NumRecord record = this.recordIterator.next();
                return OffsetRecordTable.this.subTableForRecord(record);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected abstract S readSubTable(ReadableFontData var1, boolean var2);

    private S subTableForRecord(NumRecord record) {
        if (record.value == 0) {
            return null;
        }
        ReadableFontData newBase = this.data.slice(record.value);
        return this.readSubTable(newBase, this.dataIsCanonical);
    }

    public static abstract class Builder<T extends OffsetRecordTable<? extends SubTable>, S extends SubTable>
    extends HeaderTable.Builder<T> {
        private List<VisibleSubTable.Builder<S>> builders;
        private boolean dataIsCanonical;
        private int serializedLength;
        private int serializedCount;
        private final int base;
        private int serializedSubtablePartLength;
        private int serializedTablePartLength;

        protected Builder() {
            this.base = 0;
        }

        protected Builder(T table) {
            this(((FontDataTable)table).readFontData(), ((OffsetRecordTable)table).base, ((OffsetRecordTable)table).dataIsCanonical);
        }

        protected Builder(ReadableFontData data, boolean dataIsCanonical) {
            this(data, 0, dataIsCanonical);
        }

        protected Builder(ReadableFontData data, int base, boolean dataIsCanonical) {
            super(data);
            this.base = base;
            this.dataIsCanonical = dataIsCanonical;
            if (!dataIsCanonical) {
                this.prepareToEdit();
            }
        }

        protected Builder(NumRecordList records) {
            this.base = records.base;
            if (this.builders == null) {
                this.initFromData(records);
                this.setModelChanged();
            }
        }

        public int subTableCount() {
            if (this.builders == null) {
                return new NumRecordList(this.internalReadData().slice(this.base + this.headerSize())).count();
            }
            return this.builders.size();
        }

        public SubTable.Builder<? extends SubTable> builderForTag(int tag) {
            this.prepareToEdit();
            return this.builders.get(tag);
        }

        public VisibleSubTable.Builder<S> addBuilder() {
            this.prepareToEdit();
            VisibleSubTable.Builder<S> builder = this.createSubTableBuilder();
            this.builders.add(builder);
            return builder;
        }

        public VisibleSubTable.Builder<S> addBuilder(S subTable) {
            this.prepareToEdit();
            VisibleSubTable.Builder<S> builder = this.createSubTableBuilder(subTable);
            this.builders.add(builder);
            return builder;
        }

        public void removeBuilderForTag(int tag) {
            this.prepareToEdit();
            this.builders.remove(tag);
        }

        public int limit() {
            return this.base + this.serializedLength;
        }

        @Override
        public int subDataSizeToSerialize() {
            if (this.builders != null) {
                this.computeSizeFromBuilders();
            } else {
                this.computeSizeFromData(this.internalReadData().slice(this.base + this.headerSize()));
            }
            return this.serializedLength;
        }

        public int tableSizeToSerialize() {
            this.computeSizeFromBuilders();
            return this.serializedTablePartLength;
        }

        public int subTableSizeToSerialize() {
            this.computeSizeFromBuilders();
            return this.serializedSubtablePartLength;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        public int subSerialize(WritableFontData newData, int subTableWriteOffset) {
            if (this.serializedLength == 0) {
                return 0;
            }
            if (this.builders != null) {
                return this.serializeFromBuilders(newData, subTableWriteOffset);
            }
            return this.serializeFromData(newData);
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            return this.subSerialize(newData, 0);
        }

        @Override
        public void subDataSet() {
            this.builders = null;
        }

        @Override
        public T subBuildTable(ReadableFontData data) {
            return this.readTable(data, 0, true);
        }

        protected abstract T readTable(ReadableFontData var1, int var2, boolean var3);

        protected abstract VisibleSubTable.Builder<S> createSubTableBuilder();

        protected abstract VisibleSubTable.Builder<S> createSubTableBuilder(ReadableFontData var1, boolean var2);

        protected abstract VisibleSubTable.Builder<S> createSubTableBuilder(S var1);

        private void prepareToEdit() {
            if (this.builders == null) {
                this.initFromData(this.internalReadData(), this.base);
                this.setModelChanged();
            }
        }

        private void initFromData(ReadableFontData data, int base) {
            NumRecordList recordList = new NumRecordList(data, 0, base + this.headerSize());
            this.initFromData(recordList);
        }

        private void initFromData(NumRecordList recordList) {
            ReadableFontData data = recordList.readData;
            this.builders = new ArrayList<VisibleSubTable.Builder<S>>();
            if (data == null) {
                return;
            }
            if (recordList.count() == 0) {
                return;
            }
            int subTableLimit = recordList.limit();
            Iterator recordIterator = recordList.iterator();
            do {
                NumRecord record = (NumRecord)recordIterator.next();
                int offset = record.value;
                VisibleSubTable.Builder<S> builder = this.createSubTableBuilder(data, offset);
                this.builders.add(builder);
            } while (recordIterator.hasNext());
        }

        private void computeSizeFromBuilders() {
            int len = 0;
            int count = 0;
            for (VisibleSubTable.Builder<S> builder : this.builders) {
                int sublen = builder.subDataSizeToSerialize();
                if (sublen <= 0) continue;
                ++count;
                len += sublen;
            }
            this.serializedSubtablePartLength = len;
            if (len > 0) {
                this.serializedTablePartLength = NumRecordList.sizeOfListOfCount(count);
            }
            this.serializedLength = this.serializedTablePartLength + this.serializedSubtablePartLength;
            this.serializedCount = count;
        }

        private void computeSizeFromData(ReadableFontData data) {
            int len = 0;
            int count = 0;
            if (data != null) {
                len = data.length();
                count = new NumRecordList(data).count();
            }
            this.serializedLength = len;
            this.serializedCount = count;
        }

        private int serializeFromBuilders(WritableFontData newData, int subTableWriteOffset) {
            int tableSize;
            int subTableFillPos = tableSize = NumRecordList.sizeOfListOfCount(this.serializedCount);
            if (subTableWriteOffset > 0) {
                subTableFillPos = subTableWriteOffset;
            }
            NumRecordList recordList = new NumRecordList(newData);
            for (VisibleSubTable.Builder<S> builder : this.builders) {
                if (builder.serializedLength <= 0) continue;
                NumRecord record = new NumRecord(subTableFillPos);
                recordList.add(record);
                subTableFillPos += builder.subSerialize(newData.slice(subTableFillPos));
            }
            recordList.writeTo(newData);
            return subTableFillPos;
        }

        private int serializeFromData(WritableFontData newData) {
            ReadableFontData data = this.internalReadData().slice(this.base);
            data.copyTo(newData);
            return data.length();
        }

        private VisibleSubTable.Builder<S> createSubTableBuilder(ReadableFontData data, int offset) {
            ReadableFontData newData = data.slice(offset);
            return this.createSubTableBuilder(newData, this.dataIsCanonical);
        }
    }
}

