/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.security.pkcs7;

import cfca.com.itextpdf.text.pdf.security.pkcs7.AbstractPKCS7Package;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.system.Mechanisms;

final class PKCS7RSAPackageUtil
extends AbstractPKCS7Package {
    PKCS7RSAPackageUtil() {
    }

    public ASN1Object getSignerInfo(byte[] signature, IssuerAndSerialNumber issuerAndSn, Mechanism mechanism) throws PKIException {
        AlgorithmIdentifier digestAlgIdentifier = this.getDigestAlgIdentifier(mechanism);
        DEROctetString encryptedData = new DEROctetString(signature);
        AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
        SignerInfo signerInfo = new SignerInfo(SIGNINFO_VERSION, issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, (ASN1OctetString)encryptedData, null);
        return signerInfo;
    }

    public AlgorithmIdentifier getDigestAlgIdentifier(Mechanism mechanism) throws PKIException {
        AlgorithmIdentifier digestAlgIdentifier = Mechanisms.getDigestAlgIdentifier((Mechanism)mechanism);
        if (digestAlgIdentifier == null) {
            throw new PKIException("Invalid DigestAlgIdentifier: " + mechanism);
        }
        return digestAlgIdentifier;
    }

    public ASN1ObjectIdentifier getContentIdentifier() throws PKIException {
        return PKCSObjectIdentifiers.data;
    }

    public ASN1ObjectIdentifier getSignDataIdentifier() throws PKIException {
        return PKCSObjectIdentifiers.signedData;
    }

    protected ASN1Object getSignerInfo(byte[] signature, IssuerAndSerialNumber issuerAndSn, Mechanism mechanism, ASN1Set authenticatedAttributes, ASN1Set unauthenticatedAttributes) throws PKIException {
        AlgorithmIdentifier digestAlgIdentifier = this.getDigestAlgIdentifier(mechanism);
        DEROctetString encryptedData = new DEROctetString(signature);
        AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
        SignerInfo signerInfo = new SignerInfo(SIGNINFO_VERSION, issuerAndSn, digestAlgIdentifier, authenticatedAttributes, digestEncryptAlgIdentifier, (ASN1OctetString)encryptedData, unauthenticatedAttributes);
        return signerInfo;
    }
}

