/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.api;

import cfca.sadk.timestamp.client.conf.TscAuthInfoConf;
import cfca.sadk.timestamp.client.conf.TscCommonConf;
import cfca.sadk.timestamp.client.conf.TscLayeredConf;
import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public final class TimestampConfig {
    private final TscCommonConf commonConf;
    private final TscAuthInfoConf httpAuthInfoConf;
    private final TscLayeredConf sslLayeredConf;

    public static final TimestampConfig buildDefaultTimestampConfig() throws TSAException {
        TimestampConfig config;
        File file = new File("config/timestamp.properties");
        if (file.exists() && file.isFile()) {
            TscLogging.SYSTEM_LOGGER.info("config from file-properties, file path: {}", (Object)file.getAbsoluteFile());
            config = new TimestampConfig(file.getAbsolutePath());
        } else {
            TscLogging.SYSTEM_LOGGER.info("config from default-values, file not found: {}", (Object)file.getAbsoluteFile());
            config = new TimestampConfig();
        }
        return config;
    }

    public TimestampConfig() {
        this.commonConf = new TscCommonConf();
        this.httpAuthInfoConf = new TscAuthInfoConf();
        this.sslLayeredConf = new TscLayeredConf();
    }

    public TimestampConfig(String configFilePath) throws TSAException {
        TscLogging.SYSTEM_LOGGER.info("TimestampConfig File callLoadConfig running: {}", (Object)configFilePath);
        File configFile = new File(configFilePath);
        if (!configFile.isFile() || !configFile.exists()) {
            throw new TSAException(TSAErrorCode.timestampConfigLoadFailure, "TimestampConfig File not found: " + configFile.getAbsolutePath());
        }
        Properties properties = new Properties();
        FileInputStream configInputStream = null;
        try {
            TscLogging.SYSTEM_LOGGER.info("TimestampConfig File load running: {}", (Object)configFilePath);
            configInputStream = new FileInputStream(configFile);
            properties.load(configInputStream);
            TscLogging.SYSTEM_LOGGER.info("TimestampConfig File load finished: {}", (Object)configFilePath);
        }
        catch (FileNotFoundException e) {
            throw new TSAException(TSAErrorCode.timestampConfigLoadFailure, "TimestampConfig File load failure: " + configFile, (Throwable)e);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampConfigLoadFailure, "TimestampConfig File load failure: " + configFile, (Throwable)e);
        }
        finally {
            try {
                if (configInputStream != null) {
                    configInputStream.close();
                }
            }
            catch (IOException e) {
                TscLogging.ERROR_LOGGER.warn("TimestampConfig File load and closed failure: {}", (Object)configFile, (Object)e);
            }
        }
        this.commonConf = new TscCommonConf(properties);
        this.httpAuthInfoConf = new TscAuthInfoConf(properties);
        this.sslLayeredConf = new TscLayeredConf(properties);
        TscLogging.SYSTEM_LOGGER.info("TimestampConfig File callLoadConfig finished: {}", (Object)configFilePath);
    }

    public TscCommonConf getCommonConf() {
        return this.commonConf;
    }

    public TscAuthInfoConf getHttpAuthInfoConf() {
        return this.httpAuthInfoConf;
    }

    public TscLayeredConf getSslLayeredConf() {
        return this.sslLayeredConf;
    }

    public final String toString() {
        return this.toString(true);
    }

    public final String toString(boolean hidden) {
        StringBuilder builder = new StringBuilder(512);
        builder.append("TimestampConfig [");
        this.commonConf.append(builder, hidden);
        if (this.commonConf.isHttps()) {
            this.sslLayeredConf.append(builder, hidden);
        }
        this.httpAuthInfoConf.append(builder, hidden);
        return builder.toString();
    }

    public TimestampConfig setHttpURL(String httpURL) {
        this.commonConf.setHttpURL(httpURL);
        return this;
    }

    public TimestampConfig setHostnameChecker(boolean hostnameChecker) {
        this.sslLayeredConf.setHostnameChecker(hostnameChecker);
        return this;
    }

    public TimestampConfig setHttpAuthUsername(String httpAuthUsername) {
        this.httpAuthInfoConf.setHttpAuthUsername(httpAuthUsername);
        return this;
    }

    public TimestampConfig setHttpAuthPassword(String httpAuthPassword) {
        this.httpAuthInfoConf.setHttpAuthPassword(httpAuthPassword);
        return this;
    }

    public TimestampConfig setHttpTimeout(int timeout) {
        this.commonConf.setHttpConnectTimeout(timeout);
        this.commonConf.setHttpRequestTimeout(timeout);
        this.commonConf.setHttpSocketTimeout(timeout);
        return this;
    }

    public TimestampConfig setJksKeyStoreFilePassword(String jksKeyStoreFilePassword) {
        this.sslLayeredConf.setJksKeyStoreFilePassword(jksKeyStoreFilePassword);
        return this;
    }

    public TimestampConfig setJksKeyStoreFilePath(String jksKeyStoreFilePath) {
        this.sslLayeredConf.setJksKeyStoreFilePath(jksKeyStoreFilePath);
        return this;
    }

    public TimestampConfig setSslProtocol(String sslProtocol) {
        this.sslLayeredConf.setSslProtocol(sslProtocol);
        return this;
    }

    public TimestampConfig setJksTruestFilePassword(String jksTruestFilePassword) {
        this.sslLayeredConf.setJksTruestFilePassword(jksTruestFilePassword);
        return this;
    }

    public TimestampConfig setJksTrustFilePath(String jksTrustFilePath) {
        this.sslLayeredConf.setJksTrustFilePath(jksTrustFilePath);
        return this;
    }

    public int getHttpTimeout() {
        return this.commonConf.getHttpSocketTimeout();
    }

    public long getWarningThresholdTime() {
        return this.commonConf.getWarningThresholdTime();
    }
}

