/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.Authenticator;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.EngineArgs;
import cfca.sadk.tls.sun.security.ssl.EngineWriter;
import cfca.sadk.tls.sun.security.ssl.InputRecord;
import cfca.sadk.tls.sun.security.ssl.OutputRecord;
import cfca.sadk.tls.sun.security.ssl.SSLEngineImpl;
import cfca.sadk.tls.sun.security.ssl.sec.CipherBox;
import cfca.sadk.tls.sun.security.ssl.sec.MAC;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class EngineOutputRecord
extends OutputRecord {
    private SSLEngineImpl engine;
    private EngineWriter writer;
    private boolean finishedMsg = false;

    EngineOutputRecord(byte type, SSLEngineImpl engine) {
        super(type, EngineOutputRecord.recordSize(type));
        this.engine = engine;
        this.writer = engine.writer;
    }

    private static int recordSize(byte type) {
        int size = 0;
        switch (type) {
            case 20: 
            case 21: {
                size = 539;
                break;
            }
            case 22: {
                size = 16921;
                break;
            }
            case 23: {
                size = 0;
                break;
            }
            default: {
                throw new RuntimeException("Unknown record type: " + type);
            }
        }
        return size;
    }

    void setFinishedMsg() {
        this.finishedMsg = true;
    }

    @Override
    public void flush() throws IOException {
        this.finishedMsg = false;
    }

    boolean isFinishedMsg() {
        return this.finishedMsg;
    }

    @Override
    void writeBuffer(OutputStream out, byte[] buf, int off, int len, int debugOffset) throws IOException {
        ByteBuffer netBuffer = (ByteBuffer)ByteBuffer.allocate(len).put(buf, off, len).flip();
        this.writer.putOutboundData(netBuffer);
    }

    void write(Authenticator authenticator, CipherBox writeCipher) throws IOException {
        switch (this.contentType()) {
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            default: {
                throw new RuntimeException("unexpected byte buffers");
            }
        }
        if (!this.isEmpty()) {
            this.encrypt(authenticator, writeCipher);
            this.write((OutputStream)null, false, (ByteArrayOutputStream)null);
        }
    }

    void write(EngineArgs ea, Authenticator authenticator, CipherBox writeCipher) throws IOException {
        int length;
        assert (this.contentType() == 23);
        if (authenticator == MAC.NULL) {
            return;
        }
        if (ea.getAppRemaining() == 0) {
            return;
        }
        if (this.engine.needToSplitPayload(writeCipher, this.protocolVersion)) {
            this.write(ea, authenticator, writeCipher, 1);
            ea.resetLim();
            length = Math.min(ea.getAppRemaining(), 15846);
        } else {
            length = Math.min(ea.getAppRemaining(), 16384);
        }
        if (length > 0) {
            this.write(ea, authenticator, writeCipher, length);
        }
    }

    void write(EngineArgs ea, Authenticator authenticator, CipherBox writeCipher, int length) throws IOException {
        MAC signer;
        ByteBuffer dstBuffer = ea.netData;
        int dstPos = dstBuffer.position();
        int dstLim = dstBuffer.limit();
        int dstData = dstPos + 5 + writeCipher.getExplicitNonceSize();
        dstBuffer.position(dstData);
        ea.gather(length);
        dstBuffer.limit(dstBuffer.position());
        dstBuffer.position(dstData);
        if (authenticator instanceof MAC && (signer = (MAC)authenticator).MAClen() != 0) {
            byte[] hash = signer.compute(this.contentType(), dstBuffer, false);
            dstBuffer.limit(dstBuffer.limit() + hash.length);
            dstBuffer.put(hash);
            dstBuffer.limit(dstBuffer.position());
            dstBuffer.position(dstData);
        }
        if (!writeCipher.isNullCipher()) {
            if (this.protocolVersion.isTLS11() && writeCipher.isCBCMode()) {
                byte[] nonce = writeCipher.createExplicitNonce(authenticator, this.contentType(), dstBuffer.remaining());
                dstBuffer.position(dstPos + 5);
                dstBuffer.put(nonce);
                dstBuffer.position(dstPos + 5);
            }
            writeCipher.encrypt(dstBuffer, dstLim);
            if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("WRITE: {} {} , length = {}", new Object[]{this.protocolVersion, InputRecord.contentName(this.contentType()), length});
            }
        } else {
            dstBuffer.position(dstBuffer.limit());
        }
        int packetLength = dstBuffer.limit() - dstPos - 5;
        dstBuffer.put(dstPos, this.contentType());
        dstBuffer.put(dstPos + 1, this.protocolVersion.major);
        dstBuffer.put(dstPos + 2, this.protocolVersion.minor);
        dstBuffer.put(dstPos + 3, (byte)(packetLength >> 8));
        dstBuffer.put(dstPos + 4, (byte)packetLength);
        dstBuffer.limit(dstLim);
    }
}

