/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.convert;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.io.image.ImageData;
import cfca.sadk.com.itextpdf.io.image.ImageDataFactory;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.color.DeviceRgb;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.font.PdfFontFactory;
import cfca.sadk.com.itextpdf.kernel.geom.PageSize;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfXObject;
import cfca.sadk.com.itextpdf.svg.utils.DrawUtils;
import cfca.sadk.ofd.base.common.ImageUtil;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.convert.ConvertInterface;
import cfca.sadk.ofd.base.ofd.Appearance;
import cfca.sadk.ofd.base.ofd.ImageLocation;
import cfca.sadk.ofd.base.ofd.PathLocation;
import cfca.sadk.ofd.base.ofd.SignLocation;
import cfca.sadk.ofd.base.ofd.TextLocation;
import cfca.sadk.ofd.base.util.PDFRatationUtil;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.FontUtil;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.Sanselan;

public class DefaultConverter
implements ConvertInterface {
    private static Logger businessLog = LoggerFactory.getLogger(DefaultConverter.class);
    private PdfDocument document = null;
    private HashMap<String, byte[]> oneFileFontCacheMap = null;
    private HashMap<String, String> systemFontMap = null;
    private ConcurrentHashMap<String, PdfFont> sysFontCacheMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, PdfFont> fileFontCacheMap = new ConcurrentHashMap();

    public DefaultConverter(OutputStream outputStream) {
        this.document = new PdfDocument(new PdfWriter(outputStream));
    }

    @Override
    public void processText(List<TextLocation> locationalResult, int pageNo, cfca.sadk.ofd.base.ofd.Rectangle pageSize) throws Exception {
        PdfPage pdfPage = null;
        PageSize newPageSize = new PageSize(this.mmConvertToPt(pageSize.getWidth()), this.mmConvertToPt(pageSize.getHeight()));
        pdfPage = this.document.getNumberOfPages() < pageNo ? this.document.addNewPage(newPageSize) : this.document.getPage(pageNo);
        PdfCanvas canvas = new PdfCanvas(pdfPage);
        canvas.saveState();
        PdfFont font = null;
        PdfFont defaultFont = null;
        try {
            defaultFont = FontUtil.getInstance().createPdfFont();
        }
        catch (SealException e1) {
            businessLog.warn("create default font failed," + e1.getMessage());
        }
        for (int i = 0; i < locationalResult.size(); ++i) {
            TextLocation oneTextLocation = locationalResult.get(i);
            String fontID = oneTextLocation.getFontId();
            float fontSize = this.mmConvertToPt(oneTextLocation.getFontSize());
            String text = oneTextLocation.getText();
            String fontName = this.systemFontMap.get(fontID);
            float codeOffsetX = oneTextLocation.getX();
            float codeOffsetY = oneTextLocation.getY();
            float coefficient = 1.0f;
            String ctm = oneTextLocation.getCtm();
            double rotation = 0.0;
            String[] ctmArray = null;
            if (null != ctm) {
                ctmArray = ctm.split(" ");
                float b = Float.valueOf(ctmArray[1]).floatValue();
                coefficient = Float.valueOf(ctmArray[0]).floatValue();
                if (b != 0.0f) {
                    rotation = 270.0 + Math.acos(coefficient) * 180.0 / Math.PI;
                } else {
                    fontSize = coefficient * fontSize;
                }
                codeOffsetY = coefficient * codeOffsetY;
                codeOffsetX = coefficient * codeOffsetX;
            }
            try {
                if (null == fontName) {
                    font = this.fileFontCacheMap.get(fontID);
                    if (null == font) {
                        byte[] fontData = this.oneFileFontCacheMap.get(fontID);
                        font = PdfFontFactory.createFont((byte[])fontData, (String)"Identity-H", (boolean)false, (boolean)false);
                        this.fileFontCacheMap.put(fontID, font);
                    }
                } else {
                    font = this.sysFontCacheMap.get(fontName);
                    if (null == font) {
                        long start = System.currentTimeMillis();
                        font = PdfFontFactory.createRegisteredFont((String)fontName, (String)"Identity-H", (boolean)false, (boolean)false);
                        long end = System.currentTimeMillis();
                        businessLog.info("load " + fontName + " font cost time =" + (end - start) + "ms");
                        this.sysFontCacheMap.put(fontName, font);
                    }
                }
            }
            catch (Exception e) {
                businessLog.warn("load font file failed", (Throwable)e);
            }
            if (null == font) {
                font = defaultFont;
            }
            cfca.sadk.ofd.base.ofd.Rectangle rect = oneTextLocation.getRect();
            boolean isMutiLine = false;
            String[] deltaXArray = oneTextLocation.getDeltaXArray();
            if (deltaXArray != null) {
                for (int j = 0; j < deltaXArray.length; ++j) {
                    String singleValue = deltaXArray[j];
                    if (singleValue.isEmpty() || singleValue.equals("g") || !(Float.valueOf(singleValue).floatValue() < 0.0f)) continue;
                    isMutiLine = true;
                    break;
                }
            }
            if (!isMutiLine) {
                int wordCount = oneTextLocation.getText().length();
                float realFontSize = this.mmConvertToPt(rect.getWidth()) / (float)wordCount;
                if (realFontSize < fontSize && realFontSize * 2.0f - fontSize < 2.0f) {
                    fontSize -= 1.5f;
                }
            }
            float py = this.mmConvertToPt(rect.getY() + codeOffsetY);
            float newY = newPageSize.getHeight() - py;
            float px = this.mmConvertToPt(rect.getX() + codeOffsetX);
            String fillrgb = oneTextLocation.getFillColor();
            String strokergb = oneTextLocation.getStrokeColor();
            canvas.setStrokeColor(Color.BLACK);
            if (fillrgb != null) {
                this.setColor(fillrgb, canvas, true, null);
            }
            if (strokergb != null) {
                this.setColor(strokergb, canvas, false, null);
            }
            canvas.stroke();
            String deltaY = oneTextLocation.getDeltaY();
            if (null != deltaY && !deltaY.equals("0") && !deltaY.contains("0 0")) {
                int beginIndex = 0;
                int endIndex = 0;
                String[] deltaYArray = deltaY.split(" ");
                double offsetY = 0.0;
                int step = 1;
                int realSize = text.length();
                if (deltaY != null && deltaY.contains("g")) {
                    step = 4;
                    realSize = deltaYArray.length;
                }
                for (int m = 0; m < realSize; m += step) {
                    String onLineText;
                    if (deltaYArray.length > m && deltaYArray[m].equals("g")) {
                        onLineText = text.substring(beginIndex, endIndex += Integer.parseInt(deltaYArray[m + 1]) + 1);
                        PDFRatationUtil.textArrayRotation(canvas, onLineText, font, fontSize, (float)rotation, px, (float)((double)newY - (double)coefficient * offsetY), 1.0f, 1.0f);
                        if (m + 3 <= deltaYArray.length - 1) {
                            offsetY += Double.parseDouble(deltaYArray[m + 3]) + (double)(fontSize / 2.0f);
                        }
                        beginIndex = endIndex;
                        continue;
                    }
                    onLineText = text.substring(m, m + 1);
                    if (m != 0) {
                        offsetY += Double.parseDouble(deltaYArray[m - 1]) + (double)fontSize;
                    }
                    PDFRatationUtil.textArrayRotation(canvas, onLineText, font, fontSize, (float)rotation, px, (float)((double)newY - (double)coefficient * offsetY), 1.0f, 1.0f);
                }
                continue;
            }
            PDFRatationUtil.textArrayRotation(canvas, text, font, fontSize, (float)rotation, px, newY, 1.0f, 1.0f);
        }
        canvas.restoreState().release();
    }

    @Override
    public void processImage(List<ImageLocation> locationalResult, int pageNo, cfca.sadk.ofd.base.ofd.Rectangle pageSize) throws Exception {
        PdfPage pdfPage = this.document.getPage(pageNo);
        PdfCanvas canvas = new PdfCanvas(pdfPage);
        float pageHeight = pdfPage.getPageSize().getHeight();
        PdfName pdfName = null;
        boolean isSameImage = false;
        byte[] lastImageData = null;
        PdfImageXObject imageXObject = null;
        ImageData image = null;
        for (int i = 0; i < locationalResult.size(); ++i) {
            byte[] imageData;
            canvas.saveState();
            ImageLocation pathLocation = locationalResult.get(i);
            String boundary = pathLocation.getBoundary();
            cfca.sadk.ofd.base.ofd.Rectangle rect = new cfca.sadk.ofd.base.ofd.Rectangle(boundary);
            float imageHeight = this.mmConvertToPt(rect.getHeight());
            float newY = pageHeight - this.mmConvertToPt(rect.getY()) - imageHeight;
            Rectangle pdfRect = new Rectangle(this.mmConvertToPt(rect.getX()), newY, this.mmConvertToPt(rect.getWidth()), imageHeight);
            String ctm = pathLocation.getCtm();
            String alpha = pathLocation.getAlpha();
            float opacity = 1.0f;
            if (!StringUtil.isEmpty(alpha)) {
                opacity = Float.valueOf(alpha).floatValue() / 255.0f;
            }
            if (null == (imageData = pathLocation.getImageData())) continue;
            if (!Arrays.equals(imageData, lastImageData)) {
                lastImageData = imageData;
                isSameImage = false;
            } else {
                isSameImage = true;
            }
            PdfExtGState gs1 = new PdfExtGState();
            gs1.put(PdfName.BM, (PdfObject)PdfName.Multiply);
            gs1.put(PdfName.Type, (PdfObject)PdfName.ExtGState);
            gs1.setFillOpacity(opacity);
            canvas.saveState();
            canvas.setExtGState(gs1);
            int dpi = 96;
            boolean isOffset = false;
            if (null != ctm) {
                double rotation;
                float boundaryWidth = rect.getWidth();
                String[] ctmArray = ctm.split(" ");
                double a = Float.parseFloat(ctmArray[0]) / boundaryWidth;
                double b = Float.parseFloat(ctmArray[1]) / boundaryWidth;
                if (b != 0.0) {
                    isOffset = true;
                }
                if ((rotation = Math.acos(a > 1.0 ? 1.0 : a) * 180.0 / Math.PI) != 0.0) {
                    imageData = ImageUtil.rotation(imageData, (float)rotation);
                }
            }
            if (null == imageXObject || !isSameImage) {
                image = ImageDataFactory.create((byte[])imageData);
                dpi = image.getDpiX();
                imageXObject = new PdfImageXObject(image);
            }
            pdfName = isOffset ? canvas.addImage(imageXObject, pdfRect.getWidth() * (float)dpi / 72.0f, 0.0f, 0.0f, pdfRect.getHeight() * 96.0f / 72.0f, pdfRect.getX() - pdfRect.getWidth() / 3.0f / 2.0f, pdfRect.getY() - pdfRect.getHeight() / 3.0f / 2.0f, pdfName) : canvas.addImage(imageXObject, pdfRect.getWidth(), 0.0f, 0.0f, pdfRect.getHeight(), pdfRect.getX(), pdfRect.getY(), pdfName);
            canvas.restoreState();
        }
        canvas.release();
    }

    @Override
    public void processPath(List<PathLocation> locationalResult, int pageNo, cfca.sadk.ofd.base.ofd.Rectangle pageSize) throws Exception {
        PdfPage pdfPage = this.document.getPage(pageNo);
        PdfCanvas canvas = new PdfCanvas(pdfPage);
        float pageHeight = pdfPage.getPageSize().getHeight();
        for (int i = 0; i < locationalResult.size(); ++i) {
            canvas.saveState();
            PathLocation pathLocation = locationalResult.get(i);
            String fillrgb = pathLocation.getFillrgb();
            String fillAlpha = pathLocation.getFillAlpha();
            String strokergb = pathLocation.getStrokergb();
            boolean isStroke = false;
            boolean isFill = false;
            if (fillrgb != null) {
                this.setColor(fillrgb, canvas, true, fillAlpha);
                isFill = true;
            }
            if (strokergb != null) {
                this.setColor(strokergb, canvas, false, fillAlpha);
                isStroke = true;
            }
            String boundary = pathLocation.getBoundary();
            String lineWidth = pathLocation.getLineWidth();
            String abbreviatedValue = pathLocation.getAbbreviatedValue();
            String ctm = pathLocation.getCtm();
            float coefficient = 1.0f;
            if (null != ctm) {
                coefficient = Float.valueOf(ctm.split(" ")[0]).floatValue();
            }
            cfca.sadk.ofd.base.ofd.Rectangle rect = new cfca.sadk.ofd.base.ofd.Rectangle(boundary);
            float px = this.mmConvertToPt(rect.getX());
            float py = this.mmConvertToPt(rect.getY());
            float rectHeight = this.mmConvertToPt(rect.getHeight());
            float newY = pageHeight - py;
            String miterLimit = pathLocation.getMiterLimit();
            float miterLimitf = 0.0f;
            if (miterLimit != null) {
                miterLimitf = Float.valueOf(miterLimit).floatValue();
                canvas.setMiterLimit(this.mmConvertToPt(miterLimitf));
            }
            canvas.setLineWidth(lineWidth == null ? 1.0f : this.mmConvertToPt(Float.parseFloat(lineWidth)));
            businessLog.info("abbreviatedValue=" + abbreviatedValue);
            abbreviatedValue = abbreviatedValue.replace("C ", "").replace("C", "");
            String[] abbreviatedArray = abbreviatedValue.split(" ");
            try {
                int totalSize = abbreviatedArray.length;
                canvas.setLineJoinStyle(0);
                for (int j = 0; j < totalSize; j += 3) {
                    String y2;
                    String x2;
                    String operator = abbreviatedArray[j];
                    if (j + 1 >= totalSize) continue;
                    String x = abbreviatedArray[j + 1];
                    String y = abbreviatedArray[j + 2];
                    float x1 = this.mmConvertToPt(x, coefficient);
                    float y1 = this.mmConvertToPt(y, coefficient);
                    float dx1 = x1 + px;
                    float dy1 = newY - y1;
                    if (operator.equals("M")) {
                        businessLog.debug("moveTo(" + dx1 + "," + dy1 + ");");
                        canvas.moveTo((double)dx1, (double)dy1);
                        continue;
                    }
                    if (operator.equals("L")) {
                        canvas.lineTo((double)dx1, (double)dy1);
                        businessLog.debug("lineTo(" + dx1 + "," + dy1 + ");");
                        continue;
                    }
                    if (operator.equals("B")) {
                        x2 = abbreviatedArray[j + 3];
                        y2 = abbreviatedArray[j + 4];
                        String x3 = abbreviatedArray[j + 5];
                        String y3 = abbreviatedArray[j + 6];
                        float dx2 = this.mmConvertToPt(x2, coefficient) + px;
                        float dy2 = newY - this.mmConvertToPt(y2, coefficient);
                        float dx3 = this.mmConvertToPt(x3, coefficient) + px;
                        float dy3 = newY - this.mmConvertToPt(y3, coefficient);
                        businessLog.debug("curveTo(" + dx1 + "," + dy1 + "," + dx2 + "," + dy2 + "," + dx3 + "," + dy3 + ");");
                        canvas.curveTo((double)dx1, (double)dy1, (double)dx2, (double)dy2, (double)dx3, (double)dy3);
                        j += 4;
                        continue;
                    }
                    if (operator.equals("A")) {
                        String startAng = abbreviatedArray[j + 3];
                        String large = abbreviatedArray[j + 4];
                        String sweep = abbreviatedArray[j + 5];
                        String scx = abbreviatedArray[j + 6];
                        String scy = abbreviatedArray[j + 7];
                        float rx = x1;
                        float ry = y1;
                        float cx = px + this.mmConvertToPt(scx, coefficient) / 2.0f;
                        float cy = this.mmConvertToPt(scy, coefficient) + newY - rectHeight;
                        float angle = Float.parseFloat(startAng);
                        canvas.moveTo((double)(cx + rx), (double)cy);
                        DrawUtils.arc((float)(cx - rx), (float)(cy - ry), (float)(cx + rx), (float)(cy + ry), (float)angle, (float)360.0f, (PdfCanvas)canvas);
                        j += 5;
                        continue;
                    }
                    if (!operator.equals("Q")) continue;
                    x2 = abbreviatedArray[j + 3];
                    y2 = abbreviatedArray[j + 4];
                    float dx2 = this.mmConvertToPt(x2, coefficient) + px;
                    float dy2 = newY - this.mmConvertToPt(y2, coefficient);
                    businessLog.info("curveTo(" + dx1 + "," + dy1 + "," + dx2 + "," + dy2 + ");");
                    canvas.curveTo((double)dx1, (double)dy1, (double)dx2, (double)dy2);
                    j += 2;
                }
            }
            catch (NumberFormatException e) {
                businessLog.warn(abbreviatedValue, (Throwable)e);
                throw e;
            }
            if (isFill || isStroke) {
                if (isFill) {
                    canvas.fill();
                }
                if (isStroke) {
                    canvas.stroke().closePathStroke();
                }
            } else {
                canvas.stroke().closePathStroke();
            }
            canvas.restoreState();
        }
        canvas.release();
        locationalResult.clear();
    }

    @Override
    public void processSignLocation(List<SignLocation> locationalResult) throws Exception {
        for (int i = 0; i < locationalResult.size(); ++i) {
            SignLocation signLocation = locationalResult.get(i);
            byte[] imageBytes = signLocation.getImageData();
            ImageInfo imageInfo = Sanselan.getImageInfo((byte[])imageBytes);
            double dpi = imageInfo.getPhysicalWidthDpi();
            if (dpi <= 0.0) {
                dpi = 96.0;
            }
            if (null == imageBytes) continue;
            List<Appearance> appearanceList = signLocation.getAppearanceList();
            PdfName pdfName = null;
            boolean isSameImage = false;
            byte[] lastImageData = null;
            PdfImageXObject imageXObject = null;
            float offsetX = 0.0f;
            ImageData imageData = ImageDataFactory.create((byte[])imageBytes);
            for (int j = 0; j < appearanceList.size(); ++j) {
                Appearance appearance = appearanceList.get(j);
                int pageNo = Integer.parseInt(appearance.getPageRef());
                String boundary = appearance.getBoundary();
                String clip = appearance.getClip();
                cfca.sadk.ofd.base.ofd.Rectangle clipRect = new cfca.sadk.ofd.base.ofd.Rectangle(clip);
                cfca.sadk.ofd.base.ofd.Rectangle rect = new cfca.sadk.ofd.base.ofd.Rectangle(boundary);
                PdfPage pdfPage = this.document.getPage(pageNo);
                PdfCanvas canvas = new PdfCanvas(pdfPage);
                float pageHeight = pdfPage.getPageSize().getHeight();
                float pageWidth = pdfPage.getPageSize().getWidth();
                byte[] stripeImageBytes = imageBytes;
                float clipWidth = this.mmConvertToPt(rect.getWidth());
                float clipHeight = this.mmConvertToPt(rect.getHeight());
                float rectX = this.mmConvertToPt(rect.getX());
                if (!Arrays.equals(stripeImageBytes, lastImageData)) {
                    lastImageData = stripeImageBytes;
                    isSameImage = false;
                } else {
                    isSameImage = true;
                }
                if (null == imageXObject || !isSameImage) {
                    imageXObject = new PdfImageXObject(imageData);
                }
                if (clipRect.getWidth() != rect.getWidth()) {
                    Rectangle newPdfRect = this.ofdRectangleToPdf(rect);
                    clipWidth = this.mmConvertToPt(clipRect.getWidth());
                    rectX = pageWidth - clipWidth;
                    newPdfRect.setX(rectX);
                    newPdfRect.setY(pageHeight - newPdfRect.getY());
                    newPdfRect.setWidth(clipWidth);
                    PdfFormXObject form = new PdfFormXObject(new Rectangle(Math.abs(offsetX), 0.0f, clipWidth, clipHeight));
                    PdfCanvas bboxCanvas = new PdfCanvas(form, this.document);
                    pdfName = bboxCanvas.addImage(imageXObject, clipHeight, 0.0f, 0.0f, clipHeight, 0.0f, 0.0f, pdfName);
                    canvas.addXObject((PdfXObject)form, 1.0f, 0.0f, 0.0f, 1.0f, newPdfRect.getX() + offsetX, newPdfRect.getY());
                    canvas.release();
                    offsetX -= clipWidth;
                    continue;
                }
                float newY = pageHeight - this.mmConvertToPt(rect.getY()) - clipHeight;
                Rectangle pdfRect = new Rectangle(rectX, newY, clipWidth, clipHeight);
                pdfName = this.addImage(canvas, imageXObject, pdfRect.getWidth(), 0.0f, 0.0f, pdfRect.getHeight(), pdfRect.getX(), pdfRect.getY(), pdfName);
            }
        }
    }

    @Override
    public void convert() throws Exception {
        try {
            this.document.close();
        }
        catch (Exception e) {
            businessLog.error("convert ofd to pdf failed:", (Throwable)e);
            throw e;
        }
        finally {
            if (null != this.fileFontCacheMap) {
                this.fileFontCacheMap.clear();
                this.fileFontCacheMap = null;
            }
            if (null != this.oneFileFontCacheMap) {
                this.oneFileFontCacheMap.clear();
                this.oneFileFontCacheMap = null;
            }
            if (null != this.systemFontMap) {
                this.systemFontMap.clear();
                this.systemFontMap = null;
            }
            if (null != this.sysFontCacheMap) {
                this.sysFontCacheMap.clear();
                this.sysFontCacheMap = null;
            }
        }
    }

    @Override
    public void setResFont(HashMap<String, byte[]> oneFileFontCacheMap) {
        this.oneFileFontCacheMap = oneFileFontCacheMap;
    }

    @Override
    public void setSystemFont(HashMap<String, String> systemFontMap) {
        this.systemFontMap = systemFontMap;
    }

    private float mmConvertToPt(double mm) {
        return Math.round(mm * 72.0 / 25.4);
    }

    private float mmConvertToPt(String mm, float coefficient) {
        return (float)Math.round((double)(Float.parseFloat(mm) * 72.0f) / 25.4) * coefficient;
    }

    private Rectangle ofdRectangleToPdf(cfca.sadk.ofd.base.ofd.Rectangle ofdRect) {
        Rectangle pdfRect = new Rectangle(this.mmConvertToPt(ofdRect.getX()), this.mmConvertToPt(ofdRect.getY()), this.mmConvertToPt(ofdRect.getWidth()), this.mmConvertToPt(ofdRect.getHeight()));
        return pdfRect;
    }

    private void setColor(String rgb, PdfCanvas canvas, boolean isFill, String fillAlpha) {
        String[] rgbArray = rgb.split(" ");
        float fillOpacity = 1.0f;
        int r = Integer.parseInt(rgbArray[0]);
        int g = Integer.parseInt(rgbArray[1]);
        int b = Integer.parseInt(rgbArray[2]);
        DeviceRgb rgbColor = new DeviceRgb(r, g, b);
        if (isFill) {
            if (!"0".equals(fillAlpha)) {
                canvas.setFillColor((Color)rgbColor);
                PdfExtGState gs = new PdfExtGState();
                gs.put(PdfName.BM, (PdfObject)PdfName.Multiply);
                gs.put(PdfName.Type, (PdfObject)PdfName.ExtGState);
                gs.setFillOpacity(fillOpacity);
                canvas.setExtGState(gs);
            }
        } else {
            canvas.setStrokeColor((Color)rgbColor);
        }
    }

    private PdfName addImage(PdfCanvas pdfCanvas, PdfImageXObject imageXObject, float a, float b, float c, float d, float e, float f, PdfName pdfName) {
        PdfExtGState gs1 = new PdfExtGState();
        gs1.setFillOpacity(0.85f);
        pdfCanvas.saveState();
        pdfCanvas.setExtGState(gs1);
        pdfName = pdfCanvas.addImage(imageXObject, a, b, c, d, e, f, pdfName);
        pdfCanvas.restoreState();
        return pdfName;
    }
}

