/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.tools.conversion.eot;

import java.io.ByteArrayOutputStream;

public class BitIOWriter {
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private byte byteBuf = 0;
    private int bitCount = 0;

    public void writeBit(int bit) {
        this.byteBuf = (byte)(this.byteBuf | bit << 7 - this.bitCount);
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.buf.write(this.byteBuf);
            this.byteBuf = 0;
            this.bitCount = 0;
        }
    }

    public void writeBit(boolean bit) {
        this.writeBit(bit ? 1 : 0);
    }

    public void writeValue(int value, int numBits) {
        for (int i = numBits - 1; i >= 0; --i) {
            this.writeBit(value >> i & 1);
        }
    }

    public void flush() {
        if (this.bitCount > 0) {
            this.buf.write(this.byteBuf);
            this.byteBuf = 0;
            this.bitCount = 0;
        }
    }

    public byte[] toByteArray() {
        return this.buf.toByteArray();
    }
}

