/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.tx.transaction;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.paperless.base.util.ProofHashUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.base.util.validity.ValidityUtil;
import cfca.paperless.client.connector.HttpConnector;
import cfca.paperless.client.tx.transaction.AbstractTransaction;
import cfca.paperless.client.util.JsonUtil;
import cfca.paperless.client.util.ValidateUtil;
import cfca.paperless.dto.RequestDto;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.request.requestbody.tx30.TransformHtmlToPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx30.TransformImageToPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx30.TransformPdfToImageRequestBody;
import cfca.paperless.dto.request.requestbody.tx30.TransformWordToPdfRequestBody;
import cfca.paperless.dto.request.tx30.TransformHtmlToPdfRequest;
import cfca.paperless.dto.request.tx30.TransformImageToPdfRequest;
import cfca.paperless.dto.request.tx30.TransformPdfToImageRequest;
import cfca.paperless.dto.request.tx30.TransformWordToPdfRequest;
import cfca.paperless.dto.response.responsebody.tx30.TransformHtmlToPdfResponseBody;
import cfca.paperless.dto.response.responsebody.tx30.TransformImageToPdfResponseBody;
import cfca.paperless.dto.response.responsebody.tx30.TransformPdfToImageResponseBody;
import cfca.paperless.dto.response.responsebody.tx30.TransformWordToPdfResponseBody;
import cfca.paperless.dto.response.tx30.TransformHtmlToPdfResponse;
import cfca.paperless.dto.response.tx30.TransformImageToPdfResponse;
import cfca.paperless.dto.response.tx30.TransformPdfToImageResponse;
import cfca.paperless.dto.response.tx30.TransformWordToPdfResponse;
import java.util.ArrayList;
import java.util.List;

public class Tx30Transaction
extends AbstractTransaction {
    public static final Logger logger = LoggerFactory.getLogger(Tx30Transaction.class);

    public TransformHtmlToPdfResponse doTx3001(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx3001 start.");
        TransformHtmlToPdfRequest requestBean = (TransformHtmlToPdfRequest)requestDto;
        TransformHtmlToPdfRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx3001(requestBody, inputFileDataList);
        logger.info("Tx10Transaction.doTx3001 doCheckTx3001 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx3001 handleRequest finish.");
        TransformHtmlToPdfResponse responseBean = this.parseTx3001Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx3001 parseTx3001Result finish.");
        logger.info("Tx10Transaction.doTx3001 end.");
        return responseBean;
    }

    public TransformWordToPdfResponse doTx3002(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx3002 start.");
        TransformWordToPdfRequest requestBean = (TransformWordToPdfRequest)requestDto;
        TransformWordToPdfRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx3002(requestBody, inputFileDataList);
        logger.info("Tx10Transaction.doTx3002 doCheckTx3002 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx3002 handleRequest finish.");
        TransformWordToPdfResponse responseBean = this.parseTx3002Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx3002 parseTx3002Result finish.");
        logger.info("Tx10Transaction.doTx3002 end.");
        return responseBean;
    }

    public TransformImageToPdfResponse doTx3003(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx3003 start.");
        TransformImageToPdfRequest requestBean = (TransformImageToPdfRequest)requestDto;
        TransformImageToPdfRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx3003(requestBody, inputFileDataList);
        logger.info("Tx10Transaction.doTx3003 doCheckTx3003 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx3003 handleRequest finish.");
        TransformImageToPdfResponse responseBean = this.parseTx3003Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx3003 parseTx3003Result finish.");
        logger.info("Tx10Transaction.doTx3003 end.");
        return responseBean;
    }

    public TransformPdfToImageResponse doTx3004(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx3004 start.");
        TransformPdfToImageRequest requestBean = (TransformPdfToImageRequest)requestDto;
        TransformPdfToImageRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx3004(requestBody, inputFileDataList);
        logger.info("Tx10Transaction.doTx3004 doCheckTx3004 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx3004 handleRequest finish.");
        TransformPdfToImageResponse responseBean = this.parseTx3004Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx3004 parseTx3004Result finish.");
        logger.info("Tx10Transaction.doTx3004 end.");
        return responseBean;
    }

    private TransformHtmlToPdfResponse parseTx3001Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        TransformHtmlToPdfResponse responseBean = JsonUtil.json2Obj(responseJSONString, TransformHtmlToPdfResponse.class);
        ResponseHead head = responseBean.getHead();
        TransformHtmlToPdfResponseBody body = responseBean.getBody();
        if ("000000".equals(head.getCode()) && StringUtil.isEmpty((String)body.getOutputFilepath())) {
            byte[] pdf = outputFileDataList.get(0);
            String pdfFileDataHash = body.getPdfFileDataHash();
            this.checkAndComparePdf(pdf, pdfFileDataHash);
            body.setPdf(pdf);
        }
        return responseBean;
    }

    private TransformWordToPdfResponse parseTx3002Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        TransformWordToPdfResponse responseBean = JsonUtil.json2Obj(responseJSONString, TransformWordToPdfResponse.class);
        ResponseHead head = responseBean.getHead();
        TransformWordToPdfResponseBody body = responseBean.getBody();
        if ("000000".equals(head.getCode()) && StringUtil.isEmpty((String)body.getOutputFilepath())) {
            byte[] pdf = outputFileDataList.get(0);
            String pdfFileDataHash = body.getPdfFileDataHash();
            this.checkAndComparePdf(pdf, pdfFileDataHash);
            body.setPdf(pdf);
        }
        return responseBean;
    }

    private TransformImageToPdfResponse parseTx3003Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        TransformImageToPdfResponse responseBean = JsonUtil.json2Obj(responseJSONString, TransformImageToPdfResponse.class);
        ResponseHead head = responseBean.getHead();
        TransformImageToPdfResponseBody body = responseBean.getBody();
        if ("000000".equals(head.getCode()) && StringUtil.isEmpty((String)body.getOutputFilepath())) {
            byte[] pdf = outputFileDataList.get(0);
            String pdfFileDataHash = body.getPdfFileDataHash();
            this.checkAndComparePdf(pdf, pdfFileDataHash);
            body.setPdf(pdf);
        }
        return responseBean;
    }

    private TransformPdfToImageResponse parseTx3004Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        TransformPdfToImageResponse responseBean = JsonUtil.json2Obj(responseJSONString, TransformPdfToImageResponse.class);
        ResponseHead head = responseBean.getHead();
        TransformPdfToImageResponseBody body = responseBean.getBody();
        return responseBean;
    }

    private void checkAndComparePdf(byte[] pdf, String resultPdfFileDataHash) throws Exception {
        boolean checkResult;
        ValidityUtil.checkIsPdfFile((byte[])pdf);
        if (StringUtil.isNotEmpty((String)resultPdfFileDataHash) && !(checkResult = ProofHashUtil.compareHashHex((byte[])pdf, (String)resultPdfFileDataHash))) {
            System.err.println("pdf hash compare resultPdfFileDataHash is error.");
            throw new Exception("pdf hash compare resultPdfFileDataHash is error.");
        }
    }
}

