/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.bitmap;

import java.util.Comparator;

public final class BitmapGlyphInfo {
    private final int glyphId;
    private final boolean relative;
    private final int blockOffset;
    private final int startOffset;
    private final int length;
    private final int format;
    public static final Comparator<BitmapGlyphInfo> StartOffsetComparator = new StartOffsetComparatorClass();

    public BitmapGlyphInfo(int glyphId, int blockOffset, int startOffset, int length, int format) {
        this.glyphId = glyphId;
        this.relative = true;
        this.blockOffset = blockOffset;
        this.startOffset = startOffset;
        this.length = length;
        this.format = format;
    }

    public BitmapGlyphInfo(int glyphId, int startOffset, int length, int format) {
        this.glyphId = glyphId;
        this.relative = false;
        this.blockOffset = 0;
        this.startOffset = startOffset;
        this.length = length;
        this.format = format;
    }

    public int glyphId() {
        return this.glyphId;
    }

    public boolean relative() {
        return this.relative;
    }

    public int blockOffset() {
        return this.blockOffset;
    }

    public int offset() {
        return this.blockOffset() + this.startOffset();
    }

    public int startOffset() {
        return this.startOffset;
    }

    public int length() {
        return this.length;
    }

    public int format() {
        return this.format;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blockOffset;
        result = 31 * result + this.format;
        result = 31 * result + this.glyphId;
        result = 31 * result + this.length;
        result = 31 * result + this.startOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BitmapGlyphInfo)) {
            return false;
        }
        BitmapGlyphInfo other = (BitmapGlyphInfo)obj;
        if (this.format != other.format) {
            return false;
        }
        if (this.glyphId != other.glyphId) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return this.offset() == other.offset();
    }

    private static final class StartOffsetComparatorClass
    implements Comparator<BitmapGlyphInfo> {
        private StartOffsetComparatorClass() {
        }

        @Override
        public int compare(BitmapGlyphInfo o1, BitmapGlyphInfo o2) {
            return o1.startOffset - o2.startOffset;
        }
    }
}

