/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JaxbUtil {
    private static Logger businessLog = LoggerFactory.getLogger(JaxbUtil.class);
    public static final String prefix = "ofd";

    public static void toXML(Object object, OutputStream paramOutputStream) throws Exception {
        businessLog.info("toXML begin...");
        long begin = System.currentTimeMillis();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapper(){

                public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
                    return JaxbUtil.prefix;
                }
            });
            marshaller.marshal(object, paramOutputStream);
        }
        catch (Exception e) {
            businessLog.error("toXML failed:", (Throwable)e);
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("toXML end...cost=" + (end - begin) + " ms");
        }
    }

    public static Object toJavaBean(Class<?> clazz, InputStream inputStream) throws Exception {
        businessLog.info("toJavaBean begin...");
        long begin = System.currentTimeMillis();
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        try {
            Object object;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object object2 = object = unmarshaller.unmarshal(inputStream);
            return object2;
        }
        catch (Exception e) {
            businessLog.error("toJavaBean failed:", (Throwable)e);
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("toJavaBean end...cost=" + (end - begin) + " ms");
        }
    }
}

