/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.common.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlUtil {
    private static Logger businessLog = LoggerFactory.getLogger(XmlUtil.class);
    private static SAXReader saxReader = new SAXReader();

    public static Object convertXmlToBean(File file, Class<?> beanClass) {
        if (file == null || beanClass == null) {
            return null;
        }
        try {
            Document doc = saxReader.read(file);
            if (!doc.hasContent()) {
                businessLog.debug("\u8bfb\u53d6\u7684xml\u5185\u5bb9\u4e3a\u7a7a\uff0cfileName:" + file.getName());
                return null;
            }
            Element rootElement = doc.getRootElement();
            String rootName = rootElement.getName().toLowerCase() + "bean";
            String beanName = beanClass.getSimpleName().toLowerCase();
            if (!beanName.equals(rootName)) {
                businessLog.warn("\u8bfb\u53d6\u7684\u914d\u7f6e\u6587\u4ef6\u4e0ebean\u4e0d\u5339\u914d\uff0crootName:" + rootName + ",beanName:" + beanName);
                return false;
            }
            Object bean = XmlUtil.setBean(beanClass, rootElement);
            return bean;
        }
        catch (DocumentException e) {
            businessLog.error("xmlIOUtil\u8bfb\u53d6xml\u5230bean\u51fa\u9519", (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            businessLog.error("xmlIOUtil\u8bfb\u53d6xml\u5230bean\u51fa\u9519", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            businessLog.error("xmlIOUtil\u8bfb\u53d6xml\u5230bean\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    private static Object setBean(Class<?> beanClass, Element rootElement) throws IllegalAccessException, InstantiationException {
        Object newInstance = beanClass.newInstance();
        Iterator iterator = rootElement.elementIterator();
        block0: while (iterator.hasNext()) {
            Field[] declaredFields;
            Element next = (Element)iterator.next();
            String name = next.getName();
            String text = next.getText();
            for (Field field : declaredFields = beanClass.getDeclaredFields()) {
                if (!field.getName().toLowerCase().equals(name.toLowerCase())) continue;
                XmlUtil.setField(newInstance, text, field);
                continue block0;
            }
        }
        return newInstance;
    }

    private static void setField(Object newInstance, String text, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        Class<?> type = field.getType();
        if (type == Integer.TYPE || type == Integer.class) {
            field.setInt(newInstance, Integer.parseInt(text));
        } else if (type == Float.TYPE || type == Float.class) {
            field.setFloat(newInstance, Float.parseFloat(text));
        } else if (type == Long.TYPE || type == Long.class) {
            field.setLong(newInstance, Long.parseLong(text));
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            if ("true".equals(text)) {
                field.setBoolean(newInstance, true);
            } else {
                field.setBoolean(newInstance, false);
            }
        } else {
            field.set(newInstance, text);
        }
    }

    public static boolean bean2xml(String fileName, Object bean) {
        if (bean == null || fileName == null) {
            return false;
        }
        try {
            Class<?> clazz = bean.getClass();
            String beanName = clazz.getSimpleName();
            beanName = beanName.substring(0, beanName.length() - 4);
            Document doc = DocumentHelper.createDocument();
            Element rootElement = doc.addElement(beanName);
            XmlUtil.readBean(bean, clazz, rootElement);
            XmlUtil.writeXml(fileName, doc);
            return true;
        }
        catch (IllegalArgumentException e) {
            businessLog.error("bean2xml\u65b9\u6cd5", (Throwable)e);
            return false;
        }
        catch (IllegalAccessException e) {
            businessLog.error("bean2xml\u65b9\u6cd5", (Throwable)e);
            return false;
        }
    }

    private static void readBean(Object bean, Class<?> clazz, Element rootElement) throws IllegalAccessException {
        for (Field field : clazz.getDeclaredFields()) {
            XmlUtil.readField(bean, rootElement, field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXml(String fileName, Document doc) {
        FileOutputStream fos = null;
        XMLWriter writer = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            fos = new FileOutputStream(fileName);
            writer = new XMLWriter((OutputStream)fos, format);
            writer.write(doc);
        }
        catch (IOException e) {
            businessLog.error("writeXml\u65b9\u6cd5", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                    writer = null;
                }
            }
            catch (IOException e) {
                writer = null;
            }
            try {
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
            }
            catch (IOException e) {
                fos = null;
            }
        }
    }

    private static Element readField(Object bean, Element rootElement, Field field) throws IllegalAccessException {
        Object obj;
        field.setAccessible(true);
        String name = field.getName();
        String text = "";
        Class<?> type = field.getType();
        text = type == Integer.TYPE || type == Integer.class ? field.getInt(bean) + "" : (type == Float.TYPE || type == Float.class ? field.getFloat(bean) + "" : (type == Long.TYPE || type == Long.class ? field.getLong(bean) + "" : (type == Boolean.TYPE || type == Boolean.class ? (field.getBoolean(bean) ? "true" : "false") : ((obj = field.get(bean)) == null ? "" : obj.toString()))));
        Element element = rootElement.addElement(name);
        element.setText(text);
        return element;
    }

    public static Map<String, ?> xml2map(File file, Class<?> beanClass) {
        if (file == null || beanClass == null) {
            return null;
        }
        try {
            Document doc = saxReader.read(file);
            if (!doc.hasContent()) {
                businessLog.debug("\u8bfb\u53d6\u7684xml\u5185\u5bb9\u4e3a\u7a7a,fileName:" + file.getName());
                return null;
            }
            Element rootElement = doc.getRootElement();
            String rootName = rootElement.getName().toLowerCase();
            String beanName = (beanClass.getSimpleName().substring(0, beanClass.getSimpleName().length() - 4) + "s").toLowerCase();
            if (!beanName.equals(rootName)) {
                businessLog.warn("xml\u914d\u7f6e\u540d\u79f0\u4e0ebean\u4e0d\u5339\u914d,rootName:" + rootName + ",beanName:" + beanName);
                return null;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator iterator = rootElement.elementIterator();
            while (iterator.hasNext()) {
                Element next = (Element)iterator.next();
                String key = null;
                Element keyNode = next.element("Key");
                if (keyNode == null) {
                    businessLog.debug("xml\u51fa\u73b0\u7a7a\u7684key\u503c\uff0crootName:" + rootName);
                    continue;
                }
                key = keyNode.getText();
                if (key == null || key.length() == 0) {
                    businessLog.debug("xml\u51fa\u73b0\u7a7a\u7684key\u503c\uff0crootName:" + rootName);
                    continue;
                }
                Element valueElement = next.element("Value");
                if (valueElement == null) {
                    businessLog.debug("xml\u51fa\u73b0\u7a7a\u7684value\u503c\uff0crootName:" + rootName);
                    continue;
                }
                Object bean = XmlUtil.setBean(beanClass, valueElement);
                map.put(key, bean);
            }
            return map;
        }
        catch (DocumentException e) {
            businessLog.error("xml2map\u65b9\u6cd5", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            businessLog.error("xml2map\u65b9\u6cd5", (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            businessLog.error("xml2map\u65b9\u6cd5", (Throwable)e);
            return null;
        }
    }

    public static List<?> xml2list(File file, Class<?> beanClass) {
        if (file == null || beanClass == null) {
            return null;
        }
        try {
            Document doc = saxReader.read(file);
            if (!doc.hasContent()) {
                businessLog.debug("\u8bfb\u53d6\u7684xml\u5185\u5bb9\u4e3a\u7a7a,fileName:" + file.getName());
                return null;
            }
            Element rootElement = doc.getRootElement();
            String rootName = rootElement.getName().toLowerCase();
            String beanName = (beanClass.getSimpleName().substring(0, beanClass.getSimpleName().length() - 4) + "s").toLowerCase();
            if (!beanName.equals(rootName)) {
                businessLog.warn("xml\u914d\u7f6e\u540d\u79f0\u4e0ebean\u4e0d\u5339\u914d,rootName:" + rootName + ",beanName:" + beanName);
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator iterator = rootElement.elementIterator();
            while (iterator.hasNext()) {
                Element next = (Element)iterator.next();
                Element valueElement = next.element("Value");
                if (valueElement == null) {
                    businessLog.debug("xml\u51fa\u73b0\u7a7a\u7684value\u503c\uff0crootName:" + rootName);
                    continue;
                }
                Object bean = XmlUtil.setBean(beanClass, valueElement);
                list.add(bean);
            }
            return list;
        }
        catch (DocumentException e) {
            businessLog.error("xml2list\u65b9\u6cd5", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            businessLog.error("xml2list\u65b9\u6cd5", (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            businessLog.error("xml2list\u65b9\u6cd5", (Throwable)e);
            return null;
        }
    }

    public static boolean map2xml(String fileName, Map<String, Object> map, Class<?> beanClass) {
        return false;
    }

    public static boolean updateXml(String fileName, Class<?> beanClass, Map<String, Object> map, String updateKey) {
        if (StringUtil.isEmpty(fileName) || map == null || map.isEmpty()) {
            return false;
        }
        try {
            Document doc = saxReader.read(fileName);
            if (!doc.hasContent()) {
                businessLog.debug("\u8bfb\u53d6\u7684xml\u5185\u5bb9\u4e3a\u7a7a,fileName:{}", (Object)fileName);
                return false;
            }
            Element rootElement = doc.getRootElement();
            String rootName = rootElement.getName().toLowerCase();
            String beanName = (beanClass.getSimpleName().substring(0, beanClass.getSimpleName().length() - 4) + "s").toLowerCase();
            if (!beanName.equals(rootName)) {
                businessLog.warn("xml\u914d\u7f6e\u540d\u79f0\u4e0ebean\u4e0d\u5339\u914d,rootName:" + rootName + ",beanName:" + beanName);
                return false;
            }
            Iterator iterator = rootElement.elementIterator();
            while (iterator.hasNext()) {
                Element next = (Element)iterator.next();
                Element keyNode = next.element("Key");
                if (keyNode == null) {
                    businessLog.debug("xml\u51fa\u73b0\u7a7a\u7684key\u503c\uff0crootName:" + rootName);
                    return false;
                }
                String key = keyNode.getText();
                if (StringUtil.isEmpty(key)) {
                    businessLog.debug("xml\u51fa\u73b0\u7a7a\u7684key\u503c\uff0crootName:" + rootName);
                    return false;
                }
                Element valueElement = next.element("Value");
                if (valueElement == null) {
                    businessLog.debug("xml\u51fa\u73b0\u7a7a\u7684value\u503c\uff0crootName:" + rootName);
                    return false;
                }
                boolean flag = false;
                block5: for (String changeKey : map.keySet()) {
                    Iterator iter = valueElement.elementIterator();
                    while (iter.hasNext()) {
                        Element next1 = (Element)iter.next();
                        if (!updateKey.equals(key) || !changeKey.equals(next1.getName())) continue;
                        next1.setText(map.get(changeKey).toString());
                        flag = true;
                        continue block5;
                    }
                }
                if (!flag) continue;
                try {
                    XmlUtil.writeXml(fileName, doc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    businessLog.error(e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            return true;
        }
        catch (DocumentException e) {
            businessLog.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static void writeXml(Document document, ByteArrayOutputStream outputStream) throws IOException {
        if (null == document) {
            throw new IllegalArgumentException("document is null!");
        }
        if (null == outputStream) {
            throw new IllegalArgumentException("outputStream is null!");
        }
        XMLWriter writer = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            writer = new XMLWriter((OutputStream)outputStream, format);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            businessLog.error("writeXml failed", (Throwable)e);
            throw e;
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }
}

