/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.ofd.base.asn1.CertDigestList;
import cfca.sadk.ofd.base.asn1.CertDigestObj;
import cfca.sadk.ofd.base.asn1.CertInfoList;
import cfca.sadk.ofd.base.asn1.ExtensionDatas;
import cfca.sadk.ofd.base.asn1.GM0031SourceData;
import cfca.sadk.ofd.base.asn1.SES_CertList;
import cfca.sadk.ofd.base.asn1.SES_ESPictureInfo;
import cfca.sadk.ofd.base.asn1.SES_ESPropertyInfo;
import cfca.sadk.ofd.base.asn1.SES_Header;
import cfca.sadk.ofd.base.asn1.SES_SealInfo;
import cfca.sadk.ofd.base.asn1.SES_SignInfo;
import cfca.sadk.ofd.base.asn1.SESeal;
import cfca.sadk.ofd.base.common.CertVerifyUtil;
import cfca.sadk.ofd.base.common.FileHashUtil;
import cfca.sadk.ofd.base.common.ImageUtil;
import cfca.sadk.ofd.base.common.ParamCheckUtil;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.config.VersionInfo;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.ofd.OFDConstants;
import cfca.sadk.ofd.base.seal.SealInfo;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERIA5String;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERPrintableString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERUTF8String;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Date;

public class MakeSealUtil {
    private static Logger businessLog = LoggerFactory.getLogger(MakeSealUtil.class);

    public static byte[] makeSeal(SealInfo sealInfo, Session session) throws SealException {
        long start = System.currentTimeMillis();
        businessLog.info("makeSeal start...");
        try {
            if (null == sealInfo) {
                throw new IllegalArgumentException("sealInfo is null!");
            }
            X509Cert signCert = sealInfo.getSealSignerCert();
            if (null == signCert) {
                signCert = SysEnv.getSealMakerSignCert();
            }
            ParamCheckUtil.checkCertValidity(signCert, -1);
            String esID = sealInfo.getEsID();
            if (StringUtil.isEmpty(esID)) {
                throw new IllegalArgumentException("esID is null!");
            }
            int sealType = sealInfo.getSealType();
            if (sealType <= 0) {
                throw new IllegalArgumentException("sealType = " + sealType + " is wrong!");
            }
            String sealName = sealInfo.getSealName();
            if (StringUtil.isEmpty(sealName)) {
                throw new IllegalArgumentException("sealName is null!");
            }
            Date validStart = sealInfo.getValidStart();
            if (null == validStart) {
                throw new IllegalArgumentException("validStart is null!");
            }
            Date validEnd = sealInfo.getValidEnd();
            if (null == validEnd) {
                throw new IllegalArgumentException("validEnd is null!");
            }
            if (validEnd.before(validStart)) {
                throw new IllegalArgumentException("validEnd is before validStart!");
            }
            X509Cert[] certList = sealInfo.getCertList();
            if (null == certList || certList.length == 0) {
                throw new IllegalArgumentException("certList is null!");
            }
            for (int i = 0; i < certList.length; ++i) {
                X509Cert sealCert = certList[i];
                if (sealCert == null) continue;
                if (sealCert.getSubject().endsWith(signCert.getSubject())) {
                    throw new IllegalArgumentException("SignCert can not be equals to SealSignerCert!");
                }
                boolean[] keyUsage = CertVerifyUtil.getCertKeyUsage(sealCert);
                if (null == keyUsage || !keyUsage[0]) {
                    throw new IllegalArgumentException("signCert's keyUsage not contain digitalSignature! " + Arrays.toString(keyUsage));
                }
                ParamCheckUtil.checkCertValidity(sealCert, -1);
                if (!sealCert.getNotAfter().before(validEnd)) continue;
                validEnd = sealCert.getNotAfter();
            }
            Mechanism signAlg = sealInfo.getSignAlg();
            if (null == signAlg) {
                throw new IllegalArgumentException("signAlg is null!");
            }
            String pictureType = sealInfo.getPictureType();
            if (StringUtil.isEmpty(pictureType)) {
                throw new IllegalArgumentException("pictureType is null!");
            }
            byte[] pictureData = sealInfo.getPictureData();
            if (null == pictureData) {
                throw new IllegalArgumentException("pictureData is null!");
            }
            int[] pictureInfo = ImageUtil.getImageSize(pictureData, 0);
            int pictureWidth = pictureInfo[0];
            if (pictureWidth <= 0) {
                throw new IllegalArgumentException("pictureWidth = " + pictureWidth + " is wrong!");
            }
            int pictureHeight = pictureInfo[1];
            if (pictureHeight <= 0) {
                throw new IllegalArgumentException("pictureHeight = " + pictureHeight + " is wrong!");
            }
            SES_Header header = new SES_Header();
            DERIA5String derEsID = new DERIA5String(esID);
            ASN1Integer type = new ASN1Integer((long)sealType);
            DERUTF8String name = new DERUTF8String(sealName);
            ASN1Integer asn1CertListType = new ASN1Integer(1L);
            DEROctetString cert = new DEROctetString(signCert.getEncoded());
            ASN1ObjectIdentifier signatureAlgorithm = Mechanism.getObjectIdentifier((String)signAlg.getMechanismType());
            ASN1EncodableVector digestList = new ASN1EncodableVector();
            SES_CertList asn1CertList = null;
            int spec = sealInfo.getSpecification();
            if (sealInfo.isCertList() || SysEnv.isCertListForSeal()) {
                if (spec == 3 || spec == 2 || spec == -1 && SysEnv.isForTax() || spec == -1 && SysEnv.isAnKeType()) {
                    ASN1EncodableVector v = new ASN1EncodableVector();
                    v.add((ASN1Encodable)new DEROctetString(certList[0].getEncoded()));
                    asn1CertList = new SES_CertList(CertInfoList.getInstance(new DERSequence(v)));
                    if (spec == 2 || spec == -1 && SysEnv.isAnKeType()) {
                        asn1CertListType = null;
                        header.setVersion(new ASN1Integer(OFDConstants.ANKEVersion));
                    } else if (spec == 1 || spec == -1 && SysEnv.isGM0031()) {
                        asn1CertListType = null;
                        header.setVersion(new ASN1Integer(OFDConstants.GMVersion));
                    }
                } else {
                    for (int i = 0; i < certList.length; ++i) {
                        if (SysEnv.isCertOctet()) {
                            digestList.add((ASN1Encodable)new DEROctetString(certList[i].getEncoded()));
                            continue;
                        }
                        digestList.add((ASN1Encodable)ASN1Sequence.getInstance((Object)certList[i].getEncoded()));
                    }
                    asn1CertList = new SES_CertList(CertInfoList.getInstance(new DERSequence(digestList)));
                    if (spec == 4 || spec == -1 && SysEnv.isGBType()) {
                        header.setVersion(new ASN1Integer(OFDConstants.GBVersion));
                    } else {
                        asn1CertListType = null;
                        header.setVersion(new ASN1Integer(OFDConstants.GMVersion));
                    }
                }
            } else {
                asn1CertListType = new ASN1Integer(2L);
                for (int i = 0; i < certList.length; ++i) {
                    if (certList[i] == null) continue;
                    byte[] certBytes = certList[i].getEncoded();
                    DERPrintableString objType = null;
                    objType = signAlg.equals((Object)Mechanisms.M_SM3_SM2) ? new DERPrintableString(new AlgorithmIdentifier(PKCSObjectIdentifiers.sm3, (ASN1Encodable)DERNull.INSTANCE).getAlgorithm().getId()) : new DERPrintableString(Mechanisms.getDigestAlgIdentifier((Mechanism)signAlg).getAlgorithm().getId());
                    byte[] certHash = FileHashUtil.calculateHash(certBytes, signAlg, null);
                    DEROctetString certDigestValue = new DEROctetString(certHash);
                    CertDigestObj digestObj = new CertDigestObj(objType, (ASN1OctetString)certDigestValue);
                    digestList.add((ASN1Encodable)digestObj.toASN1Primitive());
                }
                asn1CertList = new SES_CertList(CertDigestList.getInstance(new DERSequence(digestList)));
            }
            Date createDate = new Date();
            SES_ESPropertyInfo property = new SES_ESPropertyInfo(type, name, asn1CertListType, asn1CertList, createDate, validStart, validEnd);
            DERIA5String picType = new DERIA5String(pictureType);
            DEROctetString picData = new DEROctetString(pictureData);
            ASN1Integer picWidth = new ASN1Integer((long)pictureWidth);
            ASN1Integer picHeight = new ASN1Integer((long)pictureHeight);
            SES_ESPictureInfo picture = new SES_ESPictureInfo(picType, (ASN1OctetString)picData, picWidth, picHeight);
            ExtensionDatas extDatas = new ExtensionDatas((ASN1Sequence)new DERSequence());
            SES_SealInfo esealInfo = null;
            PrivateKey sealSignerPrivateKey = sealInfo.getSealSignerPrivateKey();
            if (null == sealSignerPrivateKey) {
                sealSignerPrivateKey = SysEnv.getSealMakerPrivKey();
            }
            if (null == sealSignerPrivateKey) {
                throw new IllegalArgumentException("sealSignerPrivateKey is null!");
            }
            Signature sigUtil = new Signature(false);
            String signAlgName = signAlg.getMechanismType();
            byte[] sourceData = null;
            esealInfo = new SES_SealInfo(header, derEsID, property, picture, extDatas, null, null);
            sourceData = esealInfo.getEncoded();
            if (spec != -1 && spec != 4 || !SysEnv.isGBType()) {
                GM0031SourceData gmSourceData = new GM0031SourceData(esealInfo, signatureAlgorithm, (ASN1OctetString)cert);
                sourceData = gmSourceData.getEncoded();
            }
            byte[] signedData = sigUtil.p1SignMessage(signAlgName, sourceData, sealSignerPrivateKey, session);
            DERBitString signData = new DERBitString(signedData);
            boolean isValid = sigUtil.p1VerifyMessage(signAlgName, sourceData, signedData, signCert.getPublicKey(), session);
            if (!isValid) {
                throw new Exception("publicKey and privateKey is Unmatched!");
            }
            SES_SignInfo signInfo = new SES_SignInfo((ASN1OctetString)cert, signatureAlgorithm, signData);
            SESeal seal = new SESeal(esealInfo, signInfo);
            if (sealInfo.getSpecification() == 4 || sealInfo.getSpecification() == -1 && SysEnv.isGBType()) {
                seal.setSignInfo(null);
                seal.setCert((ASN1OctetString)cert);
                seal.setSignature(signData);
                seal.setSignatureAlgorithm(signatureAlgorithm);
            }
            byte[] byArray = seal.getEncoded();
            return byArray;
        }
        catch (SealException e) {
            businessLog.error("makeSeal failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("makeSeal failed", (Throwable)e);
            throw new SealException("makeSeal failed", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("makeSeal end...cost=" + (end - start) + " ms");
        }
    }

    static {
        VersionInfo.environments();
    }
}

