/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class TimeUtil {
    public static final String DATE_FORMAT_WEB = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_CUR = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT_DAY = "yyyyMMdd";
    public static final String DATE_FORMAT_MONTH = "yyyyMM";
    public static final String DATE_FORMAT_YEAR = "yyyy";
    public static final String DATE_FORMAT_DFBANK = "yyyy/MM/dd HH:mm:ss";
    public static final String DATE_FORMAT_DFSIGN = "yyyy\u5e74MM\u6708dd\u65e5";

    public static String getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        return TimeUtil.getTimeInFormat(calendar, DATE_FORMAT_CUR);
    }

    public static String getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return TimeUtil.getTimeInFormat(calendar, DATE_FORMAT_DAY);
    }

    public static String getCurrentTime(String format) {
        Calendar calendar = Calendar.getInstance();
        return TimeUtil.getTimeInFormat(calendar, format);
    }

    public static String getFormatDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return TimeUtil.getTimeInFormat(calendar, DATE_FORMAT_DAY);
    }

    public static String getFormatDate(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("The time must be more than 0");
        }
        Date date = TimeUtil.getDateFromTime(time);
        return TimeUtil.getFormatDate(date);
    }

    public static String getFormatDate(Date date, String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return TimeUtil.getTimeInFormat(calendar, format);
    }

    public static String getFormatDate(Date date, Locale locale, String format) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        return TimeUtil.getTimeInFormat(calendar, format);
    }

    private static String getTimeInFormat(Calendar calendar, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(calendar.getTime());
    }

    public static Date getDateInFormat(String time, String format) {
        if (time == null || time.equals("")) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            return df.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDateFromTime(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return calendar.getTime();
    }

    public static String formatDate(String sDate, String sFmtFrom, String sFmtTo) {
        SimpleDateFormat sdfFrom = null;
        SimpleDateFormat sdfTo = null;
        Date dt = null;
        if (sDate == null) {
            return sDate;
        }
        try {
            sdfFrom = new SimpleDateFormat(sFmtFrom);
            dt = sdfFrom.parse(sDate);
            sdfTo = new SimpleDateFormat(sFmtTo);
            return sdfTo.format(dt);
        }
        catch (Exception e) {
            return sDate;
        }
    }

    public static int getMonthInterval(Date notAfterDate) throws Exception {
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(notAfterDate);
        if (endDate.before(startDate)) {
            return -1;
        }
        int monthInterval = (endDate.get(1) - startDate.get(1)) * 12 + (endDate.get(2) - startDate.get(2));
        if (startDate.get(5) < endDate.get(5)) {
            ++monthInterval;
        }
        return monthInterval;
    }

    public static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static String getOffSetTime(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, n);
        return TimeUtil.getTimeInFormat(calendar, DATE_FORMAT_CUR);
    }

    public static String getOffSetTime(int n, String fromat) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, n);
        return TimeUtil.getTimeInFormat(calendar, fromat);
    }
}

