/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.connector;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.paperless.client.connector.HttpClient;
import cfca.paperless.client.util.CommonUtil;
import java.util.Map;

public class HttpConnector {
    public static final Logger logger = LoggerFactory.getLogger(HttpConnector.class);
    public String JKS_PATH = "";
    public String JKS_PWD = "";
    public String url = "http://localhost:8183/PaperlessServer";
    public String requestMethod = "POST";
    public int connectTimeout = 3000;
    public int readTimeout = 10000;
    public boolean isSSL = false;
    public String sslProtocol = "TLSv1.2";
    public String keyStorePath = this.JKS_PATH;
    public String keyStorePassword = this.JKS_PWD;
    public String trustStorePath = this.JKS_PATH;
    public String trustStorePassword = this.JKS_PWD;
    private HttpClient httpClient;

    public HttpConnector(String uri, String httpMethod, int connectTimeout, int readTimeout) {
        this.url = uri;
        this.requestMethod = httpMethod;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public void setSSLConfig(boolean isSSL, String sslProtocol, String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword) {
        this.isSSL = isSSL;
        this.sslProtocol = sslProtocol;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStorePassword = trustStorePassword;
        this.trustStorePath = trustStorePath;
    }

    public void init() throws Exception {
        this.httpClient = new HttpClient();
        this.httpClient.config.connectTimeout = this.connectTimeout;
        this.httpClient.config.readTimeout = this.readTimeout;
        this.httpClient.httpConfig.userAgent = "Paperless Client";
        this.httpClient.httpConfig.contentType = "application/json";
        this.httpClient.httpConfig.accept = "application/json";
        this.httpClient.sslConfig.sslProtocol = this.sslProtocol;
        try {
            if (this.isSSL) {
                if (CommonUtil.isEmpty(this.trustStorePath)) {
                    throw new Exception("trustStorePath is empty");
                }
                if (CommonUtil.isEmpty(this.trustStorePassword)) {
                    throw new Exception("trustStorePassword is empty");
                }
                if (CommonUtil.isNotEmpty(this.keyStorePath) && CommonUtil.isEmpty(this.keyStorePassword)) {
                    throw new Exception("keyStorePath is not empty, but keyStorePassword is empty");
                }
                if (CommonUtil.isEmpty(this.keyStorePath)) {
                    this.httpClient.initSSL(null, null, this.trustStorePath, this.trustStorePassword);
                } else {
                    this.httpClient.initSSL(this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("HttpClient init error", e);
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] process(Map<String, String> requestHttpHeadersMap, byte[] requestHttpBodyData, Map<String, String> responseHttpHeadersMap) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

