/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.httpframework.utils;

import cfca.paperless.httpframework.http.HttpHeaders;
import cfca.paperless.httpframework.http.HttpRequest;
import cfca.paperless.httpframework.utils.HttpParamUtils;
import cfca.paperless.httpframework.utils.StringUtils;
import cfca.sadk.x509.certificate.X509Cert;
import java.net.Socket;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestUtils.class);

    public static Map<String, Object> parseUrlInfo(HttpRequest httpRequest) throws Exception {
        HashMap<String, Object> urlInfoMap = new HashMap<String, Object>();
        String url = httpRequest.getUrl();
        String urlParamString = null;
        if (StringUtils.isNotEmpty(url)) {
            int lastSlashCharIndex = url.lastIndexOf(47);
            if (httpRequest.getUrlParamFlag()) {
                int questionMarkIndex = url.indexOf(63);
                urlParamString = url.substring(questionMarkIndex + 1);
                urlInfoMap.put("paramInUrl", HttpParamUtils.parseHttpRequestParams(urlParamString.getBytes("UTF-8")));
                urlInfoMap.put("servletName", url.substring(lastSlashCharIndex + 1, questionMarkIndex));
            } else {
                urlInfoMap.put("servletName", url.substring(lastSlashCharIndex + 1));
            }
        }
        return urlInfoMap;
    }

    public static String getClientIP(HttpRequest httpRequest, Socket socket) throws Exception {
        String ip;
        block8: {
            block7: {
                HttpHeaders headers = httpRequest.headers();
                ip = headers.getFirst("X-Forwarded-For");
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block7;
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = headers.getFirst("Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = headers.getFirst("WL-Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = headers.getFirst("HTTP_CLIENT_IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = headers.getFirst("HTTP_X_FORWARDED_FOR");
                }
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block8;
                ip = socket.getRemoteSocketAddress().toString();
                break block8;
            }
            if (ip.length() > 15) {
                String[] ips = ip.split(",");
                for (int index = 0; index < ips.length; ++index) {
                    String strIp = ips[index];
                    if ("unknown".equalsIgnoreCase(strIp)) continue;
                    ip = strIp;
                    break;
                }
            }
        }
        if (StringUtils.isNotEmpty(ip) && ip.startsWith("/")) {
            ip = ip.substring(1);
        }
        return ip;
    }

    public static X509Cert getClientCert(HttpRequest httpRequest, Socket socket) throws Exception {
        Certificate[] certs;
        SSLSocket sslSocket;
        SSLSession sslSession;
        X509Cert cert = null;
        if (socket instanceof SSLSocket && (sslSession = (sslSocket = (SSLSocket)socket).getSession()) != null && (certs = sslSession.getPeerCertificates()) != null && certs.length > 0) {
            cert = new X509Cert(certs[0].getEncoded());
        }
        if (cert == null) {
            HttpHeaders headers = httpRequest.headers();
            String pemCert = headers.getFirst("SSL_CLIENT_CERT");
            if (StringUtils.isNotEmpty(pemCert)) {
                cert = HttpRequestUtils.pem2x509Cert(pemCert);
            }
            logger.debug("ssl client cert info in http request headers: {}", (Object)pemCert);
        }
        return cert;
    }

    public static X509Cert pem2x509Cert(String pem) {
        X509Cert x509 = null;
        try {
            x509 = new X509Cert(pem.getBytes("UTF-8"));
        }
        catch (Exception e) {
            logger.error("convert certificate format failed: PEM to X509Cert. PEM:" + pem, (Throwable)e);
        }
        return x509;
    }
}

