/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.httpframework.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class StringUtils {
    public static boolean isEmpty(String str) {
        return null == str || "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static boolean isNotEmptyAndNull(String str) {
        return str != null && !"".equals(str.trim()) && !"null".equals(str.trim().toLowerCase(Locale.getDefault()));
    }

    public static String getNodeText(String xmlString, String nodeName) {
        String beginName = "<" + nodeName + ">";
        String endName = "</" + nodeName + ">";
        int beginIndex = xmlString.indexOf(beginName);
        if (beginIndex == -1) {
            return "";
        }
        int endIndex = xmlString.indexOf(endName);
        if (endIndex == -1) {
            return "";
        }
        String nodeValue = xmlString.substring(beginIndex + beginName.length(), endIndex);
        return nodeValue;
    }

    public static String removeNode(String xmlString, String nodeName) {
        if ("".equals(nodeName)) {
            return xmlString;
        }
        String xmlBeginName = "<" + nodeName + "/>";
        if (xmlString.indexOf(xmlBeginName) > -1) {
            return xmlString.replace(xmlBeginName, "");
        }
        String beginName = "<" + nodeName + ">";
        String endName = "</" + nodeName + ">";
        int beginIndex = xmlString.indexOf(beginName);
        if (beginIndex == -1) {
            return xmlString;
        }
        int endIndex = xmlString.indexOf(endName);
        if (endIndex == -1) {
            return xmlString;
        }
        StringBuilder str = new StringBuilder(xmlString.length());
        str.append(xmlString.substring(0, beginIndex));
        str.append(xmlString.substring(endIndex + endName.length()));
        return str.toString();
    }

    public static List<String> getNodeTextList(String xmlString, String nodeName) {
        ArrayList<String> itemList = new ArrayList<String>();
        String beginName = "<" + nodeName + ">";
        String endName = "</" + nodeName + ">";
        int fromStart = 0;
        int beginIndex = xmlString.indexOf(beginName, fromStart);
        int endIndex = xmlString.indexOf(endName, beginIndex);
        while (beginIndex != -1 && endIndex != -1) {
            String nodeValue = xmlString.substring(beginIndex + beginName.length(), endIndex);
            itemList.add(nodeValue);
            fromStart = endIndex;
            beginIndex = xmlString.indexOf(beginName, fromStart);
            endIndex = xmlString.indexOf(endName, beginIndex);
        }
        return itemList;
    }
}

