/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.pipeline.html;

import cfca.com.itextpdf.text.Element;
import cfca.com.itextpdf.tool.xml.Pipeline;
import cfca.com.itextpdf.tool.xml.PipelineException;
import cfca.com.itextpdf.tool.xml.ProcessObject;
import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.WorkerContext;
import cfca.com.itextpdf.tool.xml.exceptions.LocaleMessages;
import cfca.com.itextpdf.tool.xml.exceptions.NoTagProcessorException;
import cfca.com.itextpdf.tool.xml.html.TagProcessor;
import cfca.com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import cfca.com.itextpdf.tool.xml.pipeline.WritableElement;
import cfca.com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import cfca.com.itextpdf.tool.xml.pipeline.html.NoStackException;
import cfca.com.itextpdf.tool.xml.pipeline.html.StackKeeper;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlPipeline
extends AbstractPipeline<HtmlPipelineContext> {
    private final HtmlPipelineContext hpc;

    public HtmlPipeline(HtmlPipelineContext hpc, Pipeline<?> next) {
        super(next);
        this.hpc = hpc;
    }

    @Override
    public Pipeline<?> init(WorkerContext context) throws PipelineException {
        try {
            HtmlPipelineContext clone = this.hpc.clone();
            context.put(this.getContextKey(), clone);
        }
        catch (CloneNotSupportedException e) {
            String message = String.format(LocaleMessages.getInstance().getMessage("unsupported.clone"), this.hpc.getClass().toString());
            throw new PipelineException(message, e);
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        block8: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext(context);
            try {
                List<Element> content;
                t.setLastMarginBottom(hcc.getMemory().get("lastMarginBottom"));
                hcc.getMemory().remove("lastMarginBottom");
                TagProcessor tp = hcc.resolveProcessor(t.getName(), t.getNameSpace());
                if (tp.isStackOwner()) {
                    hcc.addFirst(new StackKeeper(t));
                }
                if ((content = tp.startElement(context, t)).size() <= 0) break block8;
                if (tp.isStackOwner()) {
                    try {
                        StackKeeper peek = hcc.peek();
                        for (Element elem : content) {
                            peek.add(elem);
                        }
                        break block8;
                    }
                    catch (NoStackException e) {
                        throw new PipelineException(String.format("pipeline.html.missingstack:%1$s", t.toString()), e);
                    }
                }
                for (Element elem : content) {
                    hcc.currentContent().add(elem);
                }
            }
            catch (NoTagProcessorException e) {
                if (hcc.acceptUnknown()) break block8;
                throw e;
            }
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> content(WorkerContext context, Tag t, String text, ProcessObject po) throws PipelineException {
        block6: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext(context);
            try {
                TagProcessor tp = hcc.resolveProcessor(t.getName(), t.getNameSpace());
                List<Element> elems = tp.content(context, t, text);
                if (elems.size() <= 0) break block6;
                try {
                    StackKeeper peek = hcc.peek();
                    for (Element e : elems) {
                        peek.add(e);
                    }
                }
                catch (NoStackException e) {
                    WritableElement writableElement = new WritableElement();
                    for (Element elem : elems) {
                        writableElement.add(elem);
                    }
                    po.add(writableElement);
                }
            }
            catch (NoTagProcessorException e) {
                if (hcc.acceptUnknown()) break block6;
                throw e;
            }
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        block11: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext(context);
            try {
                if (t.getLastMarginBottom() != null) {
                    hcc.getMemory().put("lastMarginBottom", t.getLastMarginBottom());
                } else {
                    hcc.getMemory().remove("lastMarginBottom");
                }
                TagProcessor tp = hcc.resolveProcessor(t.getName(), t.getNameSpace());
                List<Element> elems = null;
                if (tp.isStackOwner()) {
                    StackKeeper tagStack;
                    try {
                        tagStack = hcc.poll();
                    }
                    catch (NoStackException e) {
                        throw new PipelineException(String.format(LocaleMessages.getInstance().getMessage("pipeline.html.missingstack"), t.toString()), e);
                    }
                    elems = tp.endElement(context, t, tagStack.getElements());
                } else {
                    elems = tp.endElement(context, t, hcc.currentContent());
                    hcc.currentContent().clear();
                }
                if (elems.size() <= 0) break block11;
                try {
                    StackKeeper stack = hcc.peek();
                    for (Element elem : elems) {
                        stack.add(elem);
                    }
                }
                catch (NoStackException e) {
                    WritableElement writableElement = new WritableElement();
                    po.add(writableElement);
                    writableElement.addAll(elems);
                }
            }
            catch (NoTagProcessorException e) {
                if (hcc.acceptUnknown()) break block11;
                throw e;
            }
        }
        return this.getNext();
    }
}

