/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.timestamp.client.BusinessTrustCerts;
import cfca.sadk.timestamp.client.StandardTimestampClient;
import cfca.sadk.timestamp.client.StandardTimestampHelper;
import cfca.sadk.timestamp.client.api.SSLProtocolEnum;
import cfca.sadk.timestamp.client.api.TSClient;
import cfca.sadk.timestamp.client.api.Timestamp;
import cfca.sadk.timestamp.client.api.TimestampConfig;
import cfca.sadk.timestamp.client.bean.MessageImprint;
import cfca.sadk.timestamp.client.env.Environments;
import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;

public class TSClientFactory
implements TSClient {
    private StandardTimestampClient standardTimestampClient;
    private StandardTimestampHelper standardTimestampHelper;

    private TSClientFactory(TimestampConfig timestampConfig) throws TSAException {
        this.standardTimestampClient = new StandardTimestampClient(timestampConfig, false);
        this.standardTimestampHelper = new StandardTimestampHelper(timestampConfig);
    }

    public static TSClient buildWithConfigFile(String configFilePath) throws TSAException {
        TSClientFactory tsClient = new TSClientFactory(new TimestampConfig(configFilePath));
        return tsClient;
    }

    @Override
    public BusinessTrustCerts currentTimestampTrustCerts() throws TSAException {
        return this.standardTimestampClient.currentBusinessTrustCerts();
    }

    @Override
    public Timestamp requestTimestamp(MessageImprint messageImprint) throws TSAException {
        return this.standardTimestampClient.requestTimestamp(messageImprint);
    }

    @Override
    public byte[] ping(byte[] pingData) throws TSAException {
        return this.standardTimestampClient.ping(pingData);
    }

    @Override
    public boolean verifyTimestamp(byte[] responseData) throws TSAException {
        return this.standardTimestampHelper.verifyTimestamp(responseData);
    }

    @Override
    public Timestamp getTimestamp(byte[] responseData) throws TSAException {
        return this.standardTimestampHelper.getTimestamp(responseData);
    }

    protected static final boolean startWithHTTPs(String timestampUrl) {
        return timestampUrl != null && timestampUrl.trim().toLowerCase().startsWith("https://");
    }

    protected static final boolean startWithHTTP(String timestampUrl) {
        return timestampUrl != null && timestampUrl.trim().toLowerCase().startsWith("http://");
    }

    static {
        Environments.getInstance();
    }

    public static class BuilderWithHttps
    extends BuilderWithHttp {
        public BuilderWithHttps(String httpsUrl) throws TSAException {
            if (!TSClientFactory.startWithHTTPs(httpsUrl)) {
                throw new TSAException(TSAErrorCode.serverUrlInvalidMalformedURL, "the http url must start with https://");
            }
            this.timestampConfig.getCommonConf().setHttpURL(httpsUrl);
        }

        @Override
        public TSClient build() throws TSAException {
            if (this.timestampConfig.getSslLayeredConf().getJksTrustFilePath() == null) {
                throw new TSAException(TSAErrorCode.httpsSSLTrustManagerFilePathMissing);
            }
            if (this.timestampConfig.getSslLayeredConf().getJksTrustFilePassword() == null) {
                throw new TSAException(TSAErrorCode.httpsSSLTrustManagerFilePasswordMissing);
            }
            if (this.timestampConfig.getSslLayeredConf().getSslProtocol() == null) {
                throw new TSAException(TSAErrorCode.sslProtocolInvalid, "missing protocol");
            }
            TSClientFactory tsClient = null;
            try {
                tsClient = new TSClientFactory(this.timestampConfig);
            }
            catch (TSAException e) {
                TscLogging.ERROR_LOGGER.error("TSClient build failed with config: {}", (Object)this.timestampConfig, (Object)e);
                throw e;
            }
            return tsClient;
        }

        public BuilderWithHttps sslProtocol(SSLProtocolEnum sslProtocol) {
            this.timestampConfig.getSslLayeredConf().setSslProtocol(sslProtocol.getProtocol());
            return this;
        }

        public BuilderWithHttps jksTrustStore(String jksTrustFilePath, String jksTruestFilePassword) {
            this.timestampConfig.getSslLayeredConf().setJksTrustFilePath(jksTrustFilePath);
            this.timestampConfig.getSslLayeredConf().setJksTruestFilePassword(jksTruestFilePassword);
            return this;
        }

        public BuilderWithHttps jksKeyStore(String jksKeyStoreFilePath, String jksKeyStoreFilePassword) {
            this.timestampConfig.getSslLayeredConf().setJksKeyStoreFilePath(jksKeyStoreFilePath);
            this.timestampConfig.getSslLayeredConf().setJksKeyStoreFilePassword(jksKeyStoreFilePassword);
            return this;
        }

        public BuilderWithHttps checkHostname(boolean hostnameChecker) {
            this.timestampConfig.getSslLayeredConf().setHostnameChecker(hostnameChecker);
            return this;
        }
    }

    public static class BuilderWithHttp {
        protected final TimestampConfig timestampConfig = new TimestampConfig();

        public BuilderWithHttp(String httpUrl) throws TSAException {
            if (!TSClientFactory.startWithHTTP(httpUrl)) {
                throw new TSAException(TSAErrorCode.serverUrlInvalidMalformedURL, "the http url must start with http://");
            }
            this.timestampConfig.getCommonConf().setHttpURL(httpUrl);
        }

        protected BuilderWithHttp() {
        }

        public BuilderWithHttp authUsername(String authUsername) {
            this.timestampConfig.getHttpAuthInfoConf().setHttpAuthUsername(authUsername);
            return this;
        }

        public BuilderWithHttp authPassword(String authPassword) {
            this.timestampConfig.getHttpAuthInfoConf().setHttpAuthPassword(authPassword);
            return this;
        }

        public BuilderWithHttp timeout(int timeout) {
            this.timestampConfig.getCommonConf().setHttpConnectTimeout(timeout);
            this.timestampConfig.getCommonConf().setHttpSocketTimeout(timeout);
            this.timestampConfig.getCommonConf().setHttpRequestTimeout(timeout);
            return this;
        }

        public BuilderWithHttp trustCertPath(String trustCertPath) {
            this.timestampConfig.getHttpAuthInfoConf().setBusinessTrustCertPath(trustCertPath);
            return this;
        }

        public BuilderWithHttp trustCRLPath(String trustCRLPath) {
            this.timestampConfig.getHttpAuthInfoConf().setBusinessTrustCRLPath(trustCRLPath);
            return this;
        }

        public BuilderWithHttp httpProxyUrl(String httpProxyUrl) {
            this.timestampConfig.getCommonConf().setHttpProxyURL(httpProxyUrl);
            return this;
        }

        public BuilderWithHttp httpProxyEnable(boolean enable) {
            this.timestampConfig.getCommonConf().setHttpProxyEnable(enable);
            return this;
        }

        public TSClient build() throws TSAException {
            TSClientFactory tsClient = null;
            try {
                tsClient = new TSClientFactory(this.timestampConfig);
            }
            catch (TSAException e) {
                TscLogging.ERROR_LOGGER.error("TSClient build failed with config: {}", (Object)this.timestampConfig, (Object)e);
                throw e;
            }
            return tsClient;
        }
    }
}

