/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.httpframework.utils;

import cfca.paperless.base.transaction.bean.ResponseHeadBean;
import cfca.paperless.base.util.JsonUtil;
import cfca.paperless.httpframework.bean.JSONRequest;
import cfca.paperless.httpframework.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseUtils.class);

    public static byte[] constructExceptionResponseJson(String errorCode, String errorMessage, String transactionNo) throws Exception {
        transactionNo = transactionNo != null ? transactionNo : "";
        ResponseHeadBean responseHeadBean = new ResponseHeadBean(transactionNo, errorCode, errorMessage);
        JSONRequest jsonRequest = new JSONRequest(responseHeadBean, null);
        String exceptionResponseJson = JsonUtil.obj2Json((Object)jsonRequest);
        return exceptionResponseJson.getBytes("UTF-8");
    }

    public static byte[] constructExceptionResponseXML(String errorCode, String errorMessage) throws Exception {
        String exceptionResponseXML = HttpResponseUtils.constructExceptionResponseXML(errorCode, errorMessage, null);
        return exceptionResponseXML.getBytes("UTF-8");
    }

    public static String constructExceptionResponseXML(String errorCode, String errorMessage, String rootElementName) {
        StringBuilder response = new StringBuilder(50);
        response.append("<Result><Code>");
        response.append(errorCode);
        response.append("</Code><Message>");
        response.append(errorMessage);
        response.append("</Message></Result>");
        return response.toString();
    }

    public static byte[] construct500InternalServerErrorResponse(byte[] responseBodyBytes, String contentType, String serverName) {
        return HttpResponseUtils.constructFakeResponse(500, "Internal Server Error", serverName, contentType, responseBodyBytes, false);
    }

    public static byte[] constructCORS500InternalServerErrorResponse(byte[] responseBodyBytes, String contentType, String serverName) {
        return HttpResponseUtils.constructFakeResponse(500, "Internal Server Error", serverName, contentType, responseBodyBytes, true);
    }

    public static byte[] constructFakeResponse(byte[] responseBodyBytes, String contentType, String serverName) {
        return HttpResponseUtils.constructFakeResponse(200, "OK", serverName, contentType, responseBodyBytes, false);
    }

    public static byte[] constructFakeResponse(byte[] responseBodyBytes, String contentType, String serverName, String jsonLength, String fileDataLength) {
        return HttpResponseUtils.constructFakeResponse(200, "OK", serverName, contentType, responseBodyBytes, jsonLength, fileDataLength, false);
    }

    public static byte[] constructCORSFakeResponse(byte[] responseBodyBytes, String contentType, String serverName) {
        return HttpResponseUtils.constructFakeResponse(200, "OK", serverName, contentType, responseBodyBytes, true);
    }

    private static byte[] constructFakeResponse(int statusCode, String resposneDescription, String serverName, String contentType, byte[] responseBodyBytes, boolean CORSFlag) {
        return HttpResponseUtils.constructFakeResponse(statusCode, resposneDescription, serverName, contentType, responseBodyBytes, "", "", CORSFlag);
    }

    private static byte[] constructFakeResponse(int statusCode, String resposneDescription, String serverName, String contentType, byte[] responseBodyBytes, String jsonLength, String fileDataLength, boolean CORSFlag) {
        byte[] ret = null;
        StringBuilder responseHeadStr = new StringBuilder(2048);
        responseHeadStr.append("HTTP/1.1 ").append(statusCode).append(" ").append(resposneDescription).append("\r\n");
        responseHeadStr.append("Date: ").append(DateFormatUtils.format((Date)new Date(), (String)"EEE, dd MMM yyyy HH:mm:ss zzz", (Locale)Locale.US)).append("\r\n");
        responseHeadStr.append("Server: ").append(serverName).append("\r\n");
        int contentLength = responseBodyBytes == null ? 0 : responseBodyBytes.length;
        responseHeadStr.append("Content-Length: " + contentLength + "\r\n");
        responseHeadStr.append("Connection: close\r\n");
        responseHeadStr.append("Content-Type: ").append(contentType).append("\r\n");
        if (CORSFlag) {
            responseHeadStr.append("Access-Control-Allow-Origin: *\r\n");
            responseHeadStr.append("Access-Control-Allow-Headers: x-requested-with\r\n");
            responseHeadStr.append("Access-Control-Allow-Methods: POST, GET, OPTIONS, DELETE\r\n");
            responseHeadStr.append("Access-Control-Max-Age: 3600\r\n");
        }
        if (StringUtils.isNotEmpty(jsonLength)) {
            responseHeadStr.append("jsonLength: ").append(jsonLength).append("\r\n");
        }
        if (StringUtils.isNotEmpty(fileDataLength)) {
            responseHeadStr.append("fileDataLength: ").append(fileDataLength).append("\r\n");
        }
        responseHeadStr.append("\r\n");
        try {
            byte[] responseHeadBytes = responseHeadStr.toString().getBytes("UTF-8");
            if (responseBodyBytes == null) {
                ret = responseHeadBytes;
            } else {
                ret = new byte[responseHeadStr.length() + responseBodyBytes.length];
                System.arraycopy(responseHeadBytes, 0, ret, 0, responseHeadBytes.length);
                System.arraycopy(responseBodyBytes, 0, ret, responseHeadBytes.length, responseBodyBytes.length);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return ret;
    }
}

