/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.classic.util;

import cfca.ch.qos.logback.classic.BasicConfigurator;
import cfca.ch.qos.logback.classic.Logger;
import cfca.ch.qos.logback.classic.LoggerContext;
import cfca.ch.qos.logback.classic.joran.JoranConfigurator;
import cfca.ch.qos.logback.classic.spi.Configurator;
import cfca.ch.qos.logback.classic.util.EnvUtil;
import cfca.ch.qos.logback.core.LogbackException;
import cfca.ch.qos.logback.core.joran.spi.JoranException;
import cfca.ch.qos.logback.core.util.Loader;
import cfca.ch.qos.logback.core.util.StatusListenerConfigHelper;
import cfca.logback.util.Environments;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ContextInitializer {
    public static final String ENVIRONMENT_LOGGER = "environmentLogger";
    private static final String END_WITH_XML = "xml";
    private static final String AUTOCONFIG_FILE = "logback-cfca.xml";
    private final LoggerContext loggerContext;

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
    }

    private void configureByResource(URL url) throws JoranException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        String urlString = url.toString();
        if (!urlString.endsWith(END_WITH_XML)) {
            throw new LogbackException("Unexpected filename extension of file [" + url.toString() + "]. Should be either .groovy or .xml");
        }
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(this.loggerContext);
        configurator.doConfigure(url);
    }

    private final URL findURLOfDefaultConfigurationFile() {
        ClassLoader myClassLoader = Loader.getClassLoaderOfObject(this);
        URL url = Loader.getResource(AUTOCONFIG_FILE, myClassLoader);
        return url;
    }

    public void autoConfig() throws JoranException {
        StatusListenerConfigHelper.installIfAsked(this.loggerContext);
        File file = new File(AUTOCONFIG_FILE);
        boolean fileLogbackExists = file.exists() && file.isFile();
        String hintMessage = null;
        hintMessage = fileLogbackExists ? "OKAY [configureByFile] " + this.configureByFile(file) : this.configureByResource();
        Logger envlogger = this.loggerContext.getLogger(ENVIRONMENT_LOGGER);
        if (fileLogbackExists) {
            envlogger.info("autoConfig logback-cfca.xml: {}", (Object)hintMessage);
        } else {
            envlogger.error("autoConfig logback-cfca.xml: {}", (Object)hintMessage);
        }
        StringBuilder builder = Environments.environments().build();
        builder.append("\n logback-xml-path: " + hintMessage);
        builder.append("\n");
        envlogger.info("autoConfig Finished {}", (Object)builder);
    }

    private final String configureByResource() throws JoranException {
        URL url = this.findURLOfDefaultConfigurationFile();
        String hintMessage = null;
        if (url != null) {
            this.configureByResource(url);
            hintMessage = "WARNNING: [configureByResource] " + url;
        } else {
            Configurator configurator = EnvUtil.loadFromServiceLoader(Configurator.class);
            if (configurator != null) {
                try {
                    configurator.setContext(this.loggerContext);
                    configurator.configure(this.loggerContext);
                    hintMessage = "WARNNING: [configureByServiceLoader] not logback-cfca.xml";
                }
                catch (Exception e) {
                    String className = configurator.getClass().getCanonicalName();
                    throw new LogbackException(String.format("Failed to initialize Configurator: %s using ServiceLoader", className), e);
                }
            } else {
                BasicConfigurator basicConfigurator = new BasicConfigurator();
                basicConfigurator.setContext(this.loggerContext);
                basicConfigurator.configure(this.loggerContext);
                hintMessage = "WARNNING: [configureByBasicConfigurator] not logback-cfca.xml";
            }
        }
        return hintMessage;
    }

    private final String configureByFile(File file) throws JoranException {
        String logbackFilePath = null;
        if (file != null && file.exists()) {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(this.loggerContext);
            configurator.doConfigure(file);
            logbackFilePath = file.getAbsolutePath();
        }
        return logbackFilePath;
    }

    final String configureFromJVMArgs() throws JoranException {
        String filePath = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("cfca.logback.path");
            }
        });
        String logbackFilePath = null;
        if (filePath != null && filePath.trim().length() > 0) {
            File file = new File(filePath);
            this.configureByFile(file);
            logbackFilePath = "-Dcfca.logback.path=" + file.getAbsolutePath();
        }
        return logbackFilePath;
    }
}

