/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout.renderer;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.layout.layout.LayoutArea;
import cfca.sadk.com.itextpdf.layout.layout.LayoutContext;
import cfca.sadk.com.itextpdf.layout.layout.LayoutResult;
import cfca.sadk.com.itextpdf.layout.layout.PositionedLayoutContext;
import cfca.sadk.com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import cfca.sadk.com.itextpdf.layout.margincollapse.MarginsCollapseInfo;
import cfca.sadk.com.itextpdf.layout.renderer.AbstractRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.FloatingHelper;
import cfca.sadk.com.itextpdf.layout.renderer.IRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.ImageRenderer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RootRenderer
extends AbstractRenderer {
    protected boolean immediateFlush = true;
    protected LayoutArea currentArea;
    protected int currentPageNumber;
    protected List<IRenderer> waitingDrawingElements = new ArrayList<IRenderer>();
    private IRenderer keepWithNextHangingRenderer;
    private LayoutResult keepWithNextHangingRendererLayoutResult;
    private MarginsCollapseHandler marginsCollapseHandler;
    private LayoutArea initialCurrentArea;
    private List<Rectangle> floatRendererAreas;
    private List<IRenderer> waitingNextPageRenderers = new ArrayList<IRenderer>();

    @Override
    public void addChild(IRenderer renderer) {
        int i;
        int numberOfChildRenderers = this.childRenderers.size();
        int numberOfPositionedChildRenderers = this.positionedRenderers.size();
        super.addChild(renderer);
        ArrayList addedRenderers = new ArrayList(1);
        ArrayList addedPositionedRenderers = new ArrayList(1);
        while (this.childRenderers.size() > numberOfChildRenderers) {
            addedRenderers.add(this.childRenderers.get(numberOfChildRenderers));
            this.childRenderers.remove(numberOfChildRenderers);
        }
        while (this.positionedRenderers.size() > numberOfPositionedChildRenderers) {
            addedPositionedRenderers.add(this.positionedRenderers.get(numberOfPositionedChildRenderers));
            this.positionedRenderers.remove(numberOfPositionedChildRenderers);
        }
        boolean marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        if (this.currentArea == null) {
            this.updateCurrentAndInitialArea(null);
            if (marginsCollapsingEnabled) {
                this.marginsCollapseHandler = new MarginsCollapseHandler(this, null);
            }
        }
        for (i = 0; this.currentArea != null && i < addedRenderers.size(); ++i) {
            Logger logger;
            renderer = (IRenderer)addedRenderers.get(i);
            this.processWaitingKeepWithNextElement(renderer);
            ArrayList<IRenderer> resultRenderers = new ArrayList<IRenderer>();
            LayoutResult result = null;
            LayoutArea storedArea = null;
            LayoutArea nextStoredArea = null;
            MarginsCollapseInfo childMarginsInfo = null;
            if (marginsCollapsingEnabled && this.currentArea != null && renderer != null) {
                childMarginsInfo = this.marginsCollapseHandler.startChildMarginsHandling(renderer, this.currentArea.getBBox());
            }
            boolean rendererIsFloat = FloatingHelper.isRendererFloating(renderer);
            while (this.currentArea != null && renderer != null && (result = renderer.setParent(this).layout(new LayoutContext(this.currentArea.clone(), childMarginsInfo, this.floatRendererAreas))).getStatus() != 1) {
                if (result.getStatus() == 2) {
                    if (rendererIsFloat) {
                        this.waitingNextPageRenderers.add(result.getOverflowRenderer());
                        break;
                    }
                    if (result.getOverflowRenderer() instanceof ImageRenderer) {
                        ((ImageRenderer)result.getOverflowRenderer()).autoScale(this.currentArea);
                    } else {
                        this.processRenderer(result.getSplitRenderer(), resultRenderers);
                        if (nextStoredArea != null) {
                            this.currentArea = nextStoredArea;
                            this.currentPageNumber = nextStoredArea.getPageNumber();
                            nextStoredArea = null;
                        } else {
                            this.updateCurrentAndInitialArea(result);
                        }
                    }
                } else if (result.getStatus() == 3) {
                    if (result.getOverflowRenderer() instanceof ImageRenderer) {
                        if (this.currentArea.getBBox().getHeight() < ((ImageRenderer)result.getOverflowRenderer()).getOccupiedArea().getBBox().getHeight() && !this.currentArea.isEmptyArea()) {
                            if (rendererIsFloat) {
                                this.waitingNextPageRenderers.add(result.getOverflowRenderer());
                                break;
                            }
                            this.updateCurrentAndInitialArea(result);
                        } else {
                            ((ImageRenderer)result.getOverflowRenderer()).autoScale(this.currentArea);
                            result.getOverflowRenderer().setProperty(26, true);
                            logger = LoggerFactory.getLogger(RootRenderer.class);
                            logger.warn(MessageFormatUtil.format("Element does not fit current area. {0}", ""));
                        }
                    } else if (this.currentArea.isEmptyArea() && result.getAreaBreak() == null) {
                        if (Boolean.TRUE.equals(result.getOverflowRenderer().getModelElement().getProperty(32))) {
                            result.getOverflowRenderer().getModelElement().setProperty(32, false);
                            logger = LoggerFactory.getLogger(RootRenderer.class);
                            logger.warn(MessageFormatUtil.format("Element does not fit current area. {0}", "KeepTogether property will be ignored."));
                            if (storedArea != null) {
                                nextStoredArea = this.currentArea;
                                this.currentArea = storedArea;
                                this.currentPageNumber = storedArea.getPageNumber();
                            }
                            storedArea = this.currentArea;
                        } else if (null != result.getCauseOfNothing() && Boolean.TRUE.equals(result.getCauseOfNothing().getProperty(32))) {
                            IRenderer theDeepestKeptTogether = result.getCauseOfNothing();
                            while (null == theDeepestKeptTogether.getModelElement() || null == theDeepestKeptTogether.getModelElement().getOwnProperty(32)) {
                                theDeepestKeptTogether = ((AbstractRenderer)theDeepestKeptTogether).parent;
                            }
                            theDeepestKeptTogether.getModelElement().setProperty(32, false);
                            Logger logger2 = LoggerFactory.getLogger(RootRenderer.class);
                            logger2.warn(MessageFormatUtil.format("Element does not fit current area. {0}", "KeepTogether property of inner element will be ignored."));
                        } else {
                            result.getOverflowRenderer().setProperty(26, true);
                            logger = LoggerFactory.getLogger(RootRenderer.class);
                            logger.warn(MessageFormatUtil.format("Element does not fit current area. {0}", ""));
                        }
                    } else {
                        storedArea = this.currentArea;
                        if (nextStoredArea != null) {
                            this.currentArea = nextStoredArea;
                            this.currentPageNumber = nextStoredArea.getPageNumber();
                            nextStoredArea = null;
                        } else {
                            if (rendererIsFloat) {
                                this.waitingNextPageRenderers.add(result.getOverflowRenderer());
                                break;
                            }
                            this.updateCurrentAndInitialArea(result);
                        }
                    }
                }
                renderer = result.getOverflowRenderer();
                if (!marginsCollapsingEnabled) continue;
                this.marginsCollapseHandler.endChildMarginsHandling(this.currentArea.getBBox());
                this.marginsCollapseHandler = new MarginsCollapseHandler(this, null);
                childMarginsInfo = this.marginsCollapseHandler.startChildMarginsHandling(renderer, this.currentArea.getBBox());
            }
            if (marginsCollapsingEnabled) {
                this.marginsCollapseHandler.endChildMarginsHandling(this.currentArea.getBBox());
            }
            if (null != result && null != result.getSplitRenderer()) {
                renderer = result.getSplitRenderer();
            }
            if (renderer == null || result == null) continue;
            if (Boolean.TRUE.equals(renderer.getProperty(81))) {
                if (Boolean.TRUE.equals(renderer.getProperty(26))) {
                    logger = LoggerFactory.getLogger(RootRenderer.class);
                    logger.warn("Element was placed in a forced way. Keep with next property will be ignored");
                    this.shrinkCurrentAreaAndProcessRenderer(renderer, resultRenderers, result);
                    continue;
                }
                this.keepWithNextHangingRenderer = renderer;
                this.keepWithNextHangingRendererLayoutResult = result;
                continue;
            }
            if (result.getStatus() == 3) continue;
            this.shrinkCurrentAreaAndProcessRenderer(renderer, resultRenderers, result);
        }
        for (i = 0; i < addedPositionedRenderers.size(); ++i) {
            this.positionedRenderers.add(addedPositionedRenderers.get(i));
            renderer = (IRenderer)this.positionedRenderers.get(this.positionedRenderers.size() - 1);
            Integer positionedPageNumber = (Integer)renderer.getProperty(51);
            if (positionedPageNumber == null) {
                positionedPageNumber = this.currentPageNumber;
            }
            LayoutArea layoutArea = Integer.valueOf(3).equals(renderer.getProperty(52)) && AbstractRenderer.noAbsolutePositionInfo(renderer) ? new LayoutArea(positionedPageNumber, this.currentArea.getBBox().clone()) : new LayoutArea(positionedPageNumber, this.initialCurrentArea.getBBox().clone());
            Rectangle fullBbox = layoutArea.getBBox().clone();
            this.preparePositionedRendererAndAreaForLayout(renderer, fullBbox, layoutArea.getBBox());
            renderer.layout(new PositionedLayoutContext(new LayoutArea(layoutArea.getPageNumber(), fullBbox), layoutArea));
            if (!this.immediateFlush) continue;
            this.flushSingleRenderer(renderer);
            this.positionedRenderers.remove(this.positionedRenderers.size() - 1);
        }
    }

    public void flush() {
        for (IRenderer resultRenderer : this.childRenderers) {
            this.flushSingleRenderer(resultRenderer);
        }
        for (IRenderer resultRenderer : this.positionedRenderers) {
            this.flushSingleRenderer(resultRenderer);
        }
        this.childRenderers.clear();
        this.positionedRenderers.clear();
    }

    public void close() {
        this.addAllWaitingNextPageRenderers();
        if (this.keepWithNextHangingRenderer != null) {
            this.keepWithNextHangingRenderer.setProperty(81, false);
            IRenderer rendererToBeAdded = this.keepWithNextHangingRenderer;
            this.keepWithNextHangingRenderer = null;
            this.addChild(rendererToBeAdded);
        }
        if (!this.immediateFlush) {
            this.flush();
        }
        this.flushWaitingDrawingElements();
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        throw new IllegalStateException("Layout is not supported for root renderers.");
    }

    public LayoutArea getCurrentArea() {
        if (this.currentArea == null) {
            this.updateCurrentAndInitialArea(null);
        }
        return this.currentArea;
    }

    protected abstract void flushSingleRenderer(IRenderer var1);

    protected abstract LayoutArea updateCurrentArea(LayoutResult var1);

    protected void flushWaitingDrawingElements() {
        for (int i = 0; i < this.waitingDrawingElements.size(); ++i) {
            IRenderer waitingDrawingElement = this.waitingDrawingElements.get(i);
            this.flushSingleRenderer(waitingDrawingElement);
        }
        this.waitingDrawingElements.clear();
    }

    protected void shrinkCurrentAreaAndProcessRenderer(IRenderer renderer, List<IRenderer> resultRenderers, LayoutResult result) {
        if (this.currentArea != null) {
            float resultRendererHeight = result.getOccupiedArea().getBBox().getHeight();
            this.currentArea.getBBox().setHeight(this.currentArea.getBBox().getHeight() - resultRendererHeight);
            if (this.currentArea.isEmptyArea() && (resultRendererHeight > 0.0f || FloatingHelper.isRendererFloating(renderer))) {
                this.currentArea.setEmptyArea(false);
            }
            this.processRenderer(renderer, resultRenderers);
        }
        if (!this.immediateFlush) {
            this.childRenderers.addAll(resultRenderers);
        }
    }

    private void processRenderer(IRenderer renderer, List<IRenderer> resultRenderers) {
        this.alignChildHorizontally(renderer, this.currentArea.getBBox());
        if (this.immediateFlush) {
            this.flushSingleRenderer(renderer);
        } else {
            resultRenderers.add(renderer);
        }
    }

    private void processWaitingKeepWithNextElement(IRenderer renderer) {
        if (this.keepWithNextHangingRenderer != null) {
            LayoutArea rest = this.currentArea.clone();
            rest.getBBox().setHeight(rest.getBBox().getHeight() - this.keepWithNextHangingRendererLayoutResult.getOccupiedArea().getBBox().getHeight());
            boolean ableToProcessKeepWithNext = false;
            if (renderer.setParent(this).layout(new LayoutContext(rest)).getStatus() != 3) {
                this.shrinkCurrentAreaAndProcessRenderer(this.keepWithNextHangingRenderer, new ArrayList<IRenderer>(), this.keepWithNextHangingRendererLayoutResult);
                ableToProcessKeepWithNext = true;
            } else {
                int i;
                float originalElementHeight = this.keepWithNextHangingRendererLayoutResult.getOccupiedArea().getBBox().getHeight();
                ArrayList<Float> trySplitHeightPoints = new ArrayList<Float>();
                float delta = 35.0f;
                for (i = 1; i <= 5 && originalElementHeight - delta * (float)i > originalElementHeight / 2.0f; ++i) {
                    trySplitHeightPoints.add(Float.valueOf(originalElementHeight - delta * (float)i));
                }
                for (i = 0; i < trySplitHeightPoints.size() && !ableToProcessKeepWithNext; ++i) {
                    float curElementSplitHeight = ((Float)trySplitHeightPoints.get(i)).floatValue();
                    LayoutArea firstElementSplitLayoutArea = this.currentArea.clone();
                    firstElementSplitLayoutArea.getBBox().setHeight(curElementSplitHeight).moveUp(this.currentArea.getBBox().getHeight() - curElementSplitHeight);
                    LayoutResult firstElementSplitLayoutResult = this.keepWithNextHangingRenderer.setParent(this).layout(new LayoutContext(firstElementSplitLayoutArea.clone()));
                    if (firstElementSplitLayoutResult.getStatus() != 2) continue;
                    LayoutArea storedArea = this.currentArea;
                    this.updateCurrentAndInitialArea(firstElementSplitLayoutResult);
                    LayoutResult firstElementOverflowLayoutResult = firstElementSplitLayoutResult.getOverflowRenderer().layout(new LayoutContext(this.currentArea.clone()));
                    if (firstElementOverflowLayoutResult.getStatus() == 1) {
                        LayoutArea secondElementLayoutArea = this.currentArea.clone();
                        secondElementLayoutArea.getBBox().setHeight(secondElementLayoutArea.getBBox().getHeight() - firstElementOverflowLayoutResult.getOccupiedArea().getBBox().getHeight());
                        LayoutResult secondElementLayoutResult = renderer.setParent(this).layout(new LayoutContext(secondElementLayoutArea));
                        if (secondElementLayoutResult.getStatus() != 3) {
                            ableToProcessKeepWithNext = true;
                            this.currentArea = firstElementSplitLayoutArea;
                            this.currentPageNumber = firstElementSplitLayoutArea.getPageNumber();
                            this.shrinkCurrentAreaAndProcessRenderer(firstElementSplitLayoutResult.getSplitRenderer(), new ArrayList<IRenderer>(), firstElementSplitLayoutResult);
                            this.updateCurrentAndInitialArea(firstElementSplitLayoutResult);
                            this.shrinkCurrentAreaAndProcessRenderer(firstElementSplitLayoutResult.getOverflowRenderer(), new ArrayList<IRenderer>(), firstElementOverflowLayoutResult);
                        }
                    }
                    if (ableToProcessKeepWithNext) continue;
                    this.currentArea = storedArea;
                    this.currentPageNumber = storedArea.getPageNumber();
                }
            }
            if (!ableToProcessKeepWithNext && !this.currentArea.isEmptyArea()) {
                LayoutArea storedArea = this.currentArea;
                this.updateCurrentAndInitialArea(null);
                LayoutResult firstElementLayoutResult = this.keepWithNextHangingRenderer.setParent(this).layout(new LayoutContext(this.currentArea.clone()));
                if (firstElementLayoutResult.getStatus() == 1) {
                    LayoutArea secondElementLayoutArea = this.currentArea.clone();
                    secondElementLayoutArea.getBBox().setHeight(secondElementLayoutArea.getBBox().getHeight() - firstElementLayoutResult.getOccupiedArea().getBBox().getHeight());
                    LayoutResult secondElementLayoutResult = renderer.setParent(this).layout(new LayoutContext(secondElementLayoutArea));
                    if (secondElementLayoutResult.getStatus() != 3) {
                        ableToProcessKeepWithNext = true;
                        this.shrinkCurrentAreaAndProcessRenderer(this.keepWithNextHangingRenderer, new ArrayList<IRenderer>(), this.keepWithNextHangingRendererLayoutResult);
                    }
                }
                if (!ableToProcessKeepWithNext) {
                    this.currentArea = storedArea;
                    this.currentPageNumber = storedArea.getPageNumber();
                }
            }
            if (!ableToProcessKeepWithNext) {
                Logger logger = LoggerFactory.getLogger(RootRenderer.class);
                logger.warn("The renderer was not able to process keep with next property properly");
                this.shrinkCurrentAreaAndProcessRenderer(this.keepWithNextHangingRenderer, new ArrayList<IRenderer>(), this.keepWithNextHangingRendererLayoutResult);
            }
            this.keepWithNextHangingRenderer = null;
            this.keepWithNextHangingRendererLayoutResult = null;
        }
    }

    private void updateCurrentAndInitialArea(LayoutResult overflowResult) {
        this.floatRendererAreas = new ArrayList<Rectangle>();
        this.updateCurrentArea(overflowResult);
        this.initialCurrentArea = this.currentArea == null ? null : this.currentArea.clone();
        this.addWaitingNextPageRenderers();
    }

    private void addAllWaitingNextPageRenderers() {
        boolean marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        while (!this.waitingNextPageRenderers.isEmpty()) {
            if (marginsCollapsingEnabled) {
                this.marginsCollapseHandler = new MarginsCollapseHandler(this, null);
            }
            this.updateCurrentAndInitialArea(null);
        }
    }

    private void addWaitingNextPageRenderers() {
        ArrayList<IRenderer> waitingFloatRenderers = new ArrayList<IRenderer>(this.waitingNextPageRenderers);
        this.waitingNextPageRenderers.clear();
        for (IRenderer renderer : waitingFloatRenderers) {
            this.addChild(renderer);
        }
    }
}

