/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.generators;

import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.KeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import cfca.sadk.org.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;

public final class SM2KeyPairGenerator
extends ECKeyPairGenerator {
    private final int mBitlength = 249;
    private ECDomainParameters params;
    private SecureRandom random;

    public final void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    public final AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        BigInteger n = this.params.getN();
        ECPoint G = this.params.getG();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        ECPoint Q = null;
        while ((d = new BigInteger(nBitLength, this.random)).bitLength() < 249 || d.compareTo(TWO) < 0 || d.compareTo(n) > 0 || WNafUtil.getNafWeight(d) < minWeight || (Q = multiplier.multiply(G, d).normalize()).getXCoord().bitLength() < 249 || Q.getYCoord().bitLength() < 249) {
        }
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }

    public static final KeyPair SM2GenerateKeyPair() {
        SM2KeyPairGenerator gen = new SM2KeyPairGenerator();
        gen.init(new ECKeyGenerationParameters(SM2Params.sm2DomainParameters, new SecureRandom()));
        AsymmetricCipherKeyPair keypair = gen.generateKeyPair();
        ECPublicKeyParameters pubParameters = (ECPublicKeyParameters)keypair.getPublic();
        ECPrivateKeyParameters pvkParameters = (ECPrivateKeyParameters)keypair.getPrivate();
        GMTPublicKey pubKey = new GMTPublicKey(pubParameters);
        GMTPrivateKey priKey = new GMTPrivateKey(pvkParameters, pubParameters);
        return new KeyPair(pubKey, priKey);
    }
}

