/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class RSASignature
extends SignatureSpi {
    private final Signature rawRsa = JSSEJCE.getSignature("NONEwithRSA");
    private MessageDigest md5 = JSSEJCE.getMessageDigest("MD5");
    private MessageDigest sha = JSSEJCE.getMessageDigest("SHA1");
    private boolean isReset = true;

    private void reset() {
        if (!this.isReset) {
            this.md5.reset();
            this.sha.reset();
            this.isReset = true;
        }
    }

    private static void checkNull(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSASignature.checkNull(publicKey);
        this.reset();
        this.rawRsa.initVerify(publicKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        RSASignature.checkNull(privateKey);
        this.reset();
        this.rawRsa.initSign(privateKey, random);
    }

    @Override
    protected void engineUpdate(byte b) {
        this.isReset = false;
        this.md5.update(b);
        this.sha.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        this.isReset = false;
        this.md5.update(b, off, len);
        this.sha.update(b, off, len);
    }

    private byte[] getDigest() throws SignatureException {
        try {
            byte[] data = new byte[36];
            this.md5.digest(data, 0, 16);
            this.sha.digest(data, 16, 20);
            this.isReset = true;
            return data;
        }
        catch (DigestException e) {
            throw new SignatureException(e);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        this.rawRsa.update(this.getDigest());
        return this.rawRsa.sign();
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.engineVerify(sigBytes, 0, sigBytes.length);
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes, int offset, int length) throws SignatureException {
        this.rawRsa.update(this.getDigest());
        return this.rawRsa.verify(sigBytes, offset, length);
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        if (!param.equals("hashes")) {
            throw new InvalidParameterException("Parameter not supported: " + param);
        }
        if (!(value instanceof MessageDigest[])) {
            throw new InvalidParameterException("value must be MessageDigest[]");
        }
        MessageDigest[] digests = (MessageDigest[])value;
        this.md5 = digests[0];
        this.sha = digests[1];
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("Parameters not supported");
    }
}

