/*
 * Decompiled with CFR 0.152.
 */
package cfca.integration.uarc.graphics;

import cfca.integration.uarc.graphics.UArcShape;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;

public class UArcEllipse
extends UArcShape {
    private int width;
    private int height;
    private float stroke;
    private Color color;
    private float alpha;
    private int x;
    private int y;

    public UArcEllipse(int x, int y, int width, int height, float stroke, Color color, float alpha) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.stroke = stroke;
        this.color = color;
        this.alpha = alpha;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getStroke() {
        return this.stroke;
    }

    public Color getColor() {
        return this.color;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void draw() {
        BasicStroke oldStroke = (BasicStroke)this.g2d.getStroke();
        this.g2d.setStroke(new BasicStroke(this.stroke));
        Object oldRenderingHint = this.g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = (Color)this.g2d.getPaint();
        this.g2d.setPaint(this.color);
        AlphaComposite newComposite = AlphaComposite.getInstance(3, this.alpha);
        this.g2d.setComposite(newComposite);
        Ellipse2D.Double ellipse2d = new Ellipse2D.Double(this.x, this.y, this.width, this.height);
        this.g2d.draw(ellipse2d);
        this.g2d.setStroke(oldStroke);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldRenderingHint);
        this.g2d.setPaint(oldColor);
        this.g2d.setComposite(AlphaComposite.getInstance(3));
    }
}

