/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class ByteBufferInputStream
extends InputStream {
    ByteBuffer buffer;

    ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            throw new IOException("read on a closed InputStream");
        }
        if (this.buffer.remaining() == 0) {
            return -1;
        }
        return this.buffer.get();
    }

    @Override
    public int read(byte[] out) throws IOException {
        if (this.buffer == null) {
            throw new IOException("read on a closed InputStream");
        }
        return this.read(out, 0, out.length);
    }

    @Override
    public int read(byte[] out, int off, int len) throws IOException {
        if (this.buffer == null) {
            throw new IOException("read on a closed InputStream");
        }
        if (out == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > out.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int length = Math.min(this.buffer.remaining(), len);
        if (length == 0) {
            return -1;
        }
        this.buffer.get(out, off, length);
        return length;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.buffer == null) {
            throw new IOException("skip on a closed InputStream");
        }
        if (n <= 0L) {
            return 0L;
        }
        int nInt = (int)n;
        int skip = Math.min(this.buffer.remaining(), nInt);
        this.buffer.position(this.buffer.position() + skip);
        return nInt;
    }

    @Override
    public int available() throws IOException {
        if (this.buffer == null) {
            throw new IOException("available on a closed InputStream");
        }
        return this.buffer.remaining();
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

