/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.asn1;

import cfca.sadk.ofd.base.asn1.SESeal;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1GeneralizedTime;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERIA5String;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.io.IOException;
import java.util.Enumeration;

public class TBS_Sign
extends ASN1Object
implements PKCSObjectIdentifiers {
    private ASN1Integer version;
    private SESeal eseal;
    private DERBitString timeInfo;
    private ASN1GeneralizedTime gtimeInfo;
    private DERBitString dataHash;
    private DERIA5String propertyInfo;
    private int timeInfoType = 2;
    private ASN1OctetString cert;
    private ASN1ObjectIdentifier signatureAlgorithm;
    ASN1Encodable ext = null;

    public static TBS_Sign getInstance(Object o) {
        if (o instanceof TBS_Sign) {
            return (TBS_Sign)((Object)o);
        }
        if (o != null) {
            return new TBS_Sign(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public TBS_Sign(ASN1Integer version, SESeal eseal, DERBitString timeInfo, DERBitString dataHash, DERIA5String propertyInfo) {
        this.version = version;
        this.eseal = eseal;
        this.timeInfo = timeInfo;
        this.dataHash = dataHash;
        this.propertyInfo = propertyInfo;
    }

    public TBS_Sign(ASN1Sequence instance) {
        Enumeration e = instance.getObjects();
        this.version = ASN1Integer.getInstance(e.nextElement());
        this.eseal = SESeal.getInstance(e.nextElement());
        Object timeElement = e.nextElement();
        if (timeElement instanceof DERBitString) {
            this.timeInfo = DERBitString.getInstance(timeElement);
            this.timeInfoType = 1;
        } else if (timeElement instanceof ASN1GeneralizedTime) {
            this.gtimeInfo = ASN1GeneralizedTime.getInstance(timeElement);
            this.timeInfoType = 2;
        }
        this.dataHash = DERBitString.getInstance(e.nextElement());
        this.propertyInfo = DERIA5String.getInstance(e.nextElement());
        if (e.hasMoreElements()) {
            Object moreElement = e.nextElement();
            if (moreElement instanceof ASN1OctetString) {
                this.cert = ASN1OctetString.getInstance(moreElement);
                this.signatureAlgorithm = ASN1ObjectIdentifier.getInstance(e.nextElement());
            } else {
                this.ext = (ASN1Encodable)moreElement;
            }
        }
    }

    public TBS_Sign(ASN1Integer version, SESeal eseal, ASN1GeneralizedTime timeInfo, DERBitString dataHash, DERIA5String propertyInfo, ASN1OctetString cert, ASN1ObjectIdentifier signatureAlgorithm) {
        this.version = version;
        this.eseal = eseal;
        this.gtimeInfo = timeInfo;
        this.dataHash = dataHash;
        this.propertyInfo = propertyInfo;
    }

    public TBS_Sign(ASN1Integer version, SESeal eseal, DERBitString timeInfo, DERBitString dataHash, DERIA5String propertyInfo, ASN1OctetString cert, ASN1ObjectIdentifier signatureAlgorithm) {
        this.version = version;
        this.eseal = eseal;
        this.timeInfo = timeInfo;
        this.dataHash = dataHash;
        this.propertyInfo = propertyInfo;
        this.cert = cert;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public SESeal getEseal() {
        return this.eseal;
    }

    public byte[] getTimeInfoData() throws IOException {
        if (this.timeInfo != null) {
            return this.timeInfo.getBytes();
        }
        if (this.gtimeInfo != null) {
            return this.gtimeInfo.getEncoded();
        }
        return null;
    }

    public int getTimeInfoType() {
        return this.timeInfoType;
    }

    public DERBitString getDataHash() {
        return this.dataHash;
    }

    public DERIA5String getPropertyInfo() {
        return this.propertyInfo;
    }

    public void setEseal(SESeal eseal) {
        this.eseal = eseal;
    }

    public DERBitString getTimeInfo() {
        return this.timeInfo;
    }

    public void setTimeInfo(DERBitString timeInfo) {
        this.timeInfo = timeInfo;
    }

    public void setVersion(ASN1Integer version) {
        this.version = version;
    }

    public void setDataHash(DERBitString dataHash) {
        this.dataHash = dataHash;
    }

    public void setPropertyInfo(DERIA5String propertyInfo) {
        this.propertyInfo = propertyInfo;
    }

    public void setCert(ASN1OctetString cert) {
        this.cert = cert;
    }

    public void setSignatureAlgorithm(ASN1ObjectIdentifier signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public ASN1OctetString getCert() {
        return this.cert;
    }

    public ASN1ObjectIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.eseal);
        if (this.timeInfo != null) {
            v.add((ASN1Encodable)this.timeInfo);
        } else if (this.gtimeInfo != null) {
            v.add((ASN1Encodable)this.gtimeInfo);
        }
        v.add((ASN1Encodable)this.dataHash);
        v.add((ASN1Encodable)this.propertyInfo);
        if (this.cert != null) {
            v.add((ASN1Encodable)this.cert);
        }
        if (this.signatureAlgorithm != null) {
            v.add((ASN1Encodable)this.signatureAlgorithm);
        }
        if (this.ext != null) {
            v.add(this.ext);
        }
        return new DERSequence(v);
    }
}

