/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import java.util.List;

public class KMPUtil {
    public static int kmpList(String source, String keyword, int[] next, List<Integer> positions) {
        int j = 0;
        for (int i = 0; i < source.length(); ++i) {
            char nextChar = source.charAt(i);
            while (j > 0 && nextChar != keyword.charAt(j)) {
                j = next[j - 1];
            }
            if (nextChar == keyword.charAt(j)) {
                ++j;
            }
            if (j != keyword.length()) continue;
            int position = i - j + 1;
            positions.add(position);
            int endFlag = KMPUtil.kmpList(source.substring(position + next.length), keyword, next, positions);
            if (endFlag != -1) continue;
            return -1;
        }
        return -1;
    }

    public static int kmp(String source, String keyword, int[] next) {
        int j = 0;
        for (int i = 0; i < source.length(); ++i) {
            char nextChar = source.charAt(i);
            while (j > 0 && nextChar != keyword.charAt(j)) {
                j = next[j - 1];
            }
            if (nextChar == keyword.charAt(j)) {
                ++j;
            }
            if (j != keyword.length()) continue;
            return i - j + 1;
        }
        return -1;
    }

    public static int kmp(byte[] source, byte[] keyword, int[] next) {
        int j = 0;
        for (int i = 0; i < source.length; ++i) {
            byte nextChar = source[i];
            while (j > 0 && nextChar != keyword[j]) {
                j = next[j - 1];
            }
            if (nextChar == keyword[j]) {
                ++j;
            }
            if (j != keyword.length) continue;
            return i - j + 1;
        }
        return -1;
    }

    public static int[] kmpnext(String keyword) {
        int[] next = new int[keyword.length()];
        next[0] = 0;
        int j = 0;
        for (int i = 1; i < keyword.length(); ++i) {
            char nextChar = keyword.charAt(i);
            while (j > 0 && keyword.charAt(j) != nextChar) {
                j = next[j - 1];
            }
            if (nextChar == keyword.charAt(j)) {
                // empty if block
            }
            next[i] = ++j;
        }
        return next;
    }

    public static int[] kmpnext(byte[] keyword) {
        int[] next = new int[keyword.length];
        next[0] = 0;
        int j = 0;
        for (int i = 1; i < keyword.length; ++i) {
            byte nextChar = keyword[i];
            while (j > 0 && keyword[j] != nextChar) {
                j = next[j - 1];
            }
            if (nextChar == keyword[j]) {
                // empty if block
            }
            next[i] = ++j;
        }
        return next;
    }
}

