/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util.validity;

import cfca.paperless.base.BaseConstants;
import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.ProofHashUtil;
import cfca.paperless.base.util.validity.ParamCheckUtil;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidityUtil {
    public static final Logger sysLog = LoggerFactory.getLogger(ValidityUtil.class);
    private static final String NULL_STR = "null";
    private static final String PDF_FILE_FLAG = "%PDF";
    private static byte[] pdfFlagBytes = null;
    private static final String JPEG_TAG = "FFD8FF";
    private static final String PNG_TAG = "89504E47";
    private static final String GIF_TAG = "47494638";
    private static final String TIFF_TAG = "49492A00";
    private static final String BMP_TAG = "424D";

    public static int checkDpi(String content, String message, int defaultValue) throws CodeException {
        if (StringUtils.isEmpty((String)content) || NULL_STR.equals(content)) {
            return defaultValue;
        }
        int result = 0;
        try {
            result = Integer.parseInt(content);
        }
        catch (Exception e) {
            throw new CodeException("600703", "\u6570\u636e\u6709\u8bef\uff0c" + e.getMessage(), (Throwable)e);
        }
        if (result <= 0) {
            throw new CodeException("600705", message);
        }
        if (result > 500) {
            throw new CodeException("600703", message);
        }
        return result;
    }

    public static void checkEmpty(String content, String message) throws CodeException {
        if (ParamCheckUtil.isEmpty(content) || NULL_STR.equals(content)) {
            throw new CodeException("600401", message);
        }
    }

    public static void checkNumericAndNotEmpty(String content, String message) throws CodeException {
        if (ParamCheckUtil.isEmpty(content)) {
            throw new CodeException("600401", message);
        }
        if (!ParamCheckUtil.isNumeric(content)) {
            throw new CodeException("600703", message);
        }
    }

    public static String checkNumeric(String content, String message, String defaultValue) throws CodeException {
        if (ParamCheckUtil.isEmpty(content)) {
            return defaultValue;
        }
        if (!ParamCheckUtil.isNumeric(content)) {
            throw new CodeException("600703", message);
        }
        return content;
    }

    public static int checkInteger(String content, String message, int defaultValue) throws CodeException {
        if (ParamCheckUtil.isNotEmpty(content)) {
            try {
                return Integer.parseInt(content);
            }
            catch (Exception e) {
                throw new CodeException("600703", message, (Throwable)e);
            }
        }
        return defaultValue;
    }

    public static int checkIntegerAndNotEmpty(String content, String message) throws CodeException {
        if (ParamCheckUtil.isEmpty(content)) {
            throw new CodeException("600401", message);
        }
        try {
            return Integer.parseInt(content);
        }
        catch (Exception e) {
            throw new CodeException("600703", message, (Throwable)e);
        }
    }

    public static float checkFloat(String content, String message, float defaultValue) throws CodeException {
        if (ParamCheckUtil.isNotEmpty(content) && !NULL_STR.equals(content)) {
            try {
                return Float.parseFloat(content);
            }
            catch (Exception e) {
                throw new CodeException("600703", message, (Throwable)e);
            }
        }
        return defaultValue;
    }

    public static float checkFloatPositive(String content, String message, float defaultValue) throws CodeException {
        if (ParamCheckUtil.isNotEmpty(content) && !NULL_STR.equals(content)) {
            float contentFloat = 0.0f;
            try {
                contentFloat = Float.parseFloat(content);
            }
            catch (Exception e) {
                throw new CodeException("600703", message, (Throwable)e);
            }
            if (contentFloat < 0.0f) {
                throw new CodeException("600705", message);
            }
            return contentFloat;
        }
        return defaultValue;
    }

    public static float checkFloatPositiveAndNotEmpty(String content, String message) throws CodeException {
        if (ParamCheckUtil.isNotEmpty(content) && !NULL_STR.equals(content)) {
            float contentFloat = 0.0f;
            try {
                contentFloat = Float.parseFloat(content);
            }
            catch (Exception e) {
                throw new CodeException("600703", message, (Throwable)e);
            }
            if (contentFloat < 0.0f) {
                throw new CodeException("600705", message);
            }
            return contentFloat;
        }
        throw new CodeException("600401", message);
    }

    public static float checkFloatRange(String content, String message, float defaultValue, float min, float max) throws CodeException {
        if (ParamCheckUtil.isNotEmpty(content) && !NULL_STR.equals(content)) {
            float contentFloat = 0.0f;
            try {
                contentFloat = Float.parseFloat(content);
            }
            catch (Exception e) {
                throw new CodeException("600703", message, (Throwable)e);
            }
            if (contentFloat < min || contentFloat > max) {
                throw new CodeException("600605", message + ":" + min + "-" + max);
            }
            return contentFloat;
        }
        return defaultValue;
    }

    public static float checkFloatAndNotEmpty(String content, String message) throws CodeException {
        if (ParamCheckUtil.isEmpty(content) || NULL_STR.equals(content)) {
            throw new CodeException("600401", message);
        }
        try {
            return Float.parseFloat(content);
        }
        catch (Exception e) {
            throw new CodeException("600703", message, (Throwable)e);
        }
    }

    public static float checkFloatRangeAndNotEmpty(String content, String message, float min, float max) throws CodeException {
        if (ParamCheckUtil.isEmpty(content) || NULL_STR.equals(content)) {
            throw new CodeException("600401", message);
        }
        float contentFloat = 0.0f;
        try {
            contentFloat = Float.parseFloat(content);
        }
        catch (Exception e) {
            throw new CodeException("600703", message, (Throwable)e);
        }
        if (contentFloat < min || contentFloat > max) {
            throw new CodeException("600605", message + " ," + min + " -" + max);
        }
        return contentFloat;
    }

    public static int checkIntegerPositiveAndNotEmpty(String content, String message) throws CodeException {
        if (ParamCheckUtil.isEmpty(content) || NULL_STR.equals(content.trim())) {
            throw new CodeException("600401", message);
        }
        int result = 0;
        try {
            result = Integer.parseInt(content);
        }
        catch (Exception e) {
            throw new CodeException("600703", message, (Throwable)e);
        }
        if (result <= 0) {
            throw new CodeException("600704", message);
        }
        return result;
    }

    public static int checkIntegerNotNegativeAndNotEmpty(String content, String message) throws CodeException {
        if (ParamCheckUtil.isEmpty(content) || NULL_STR.equals(content)) {
            throw new CodeException("600401", message);
        }
        int result = 0;
        try {
            result = Integer.parseInt(content);
        }
        catch (Exception e) {
            throw new CodeException("600703", message, (Throwable)e);
        }
        if (result < 0) {
            throw new CodeException("600705", message);
        }
        return result;
    }

    public static int checkPositive(String content, String message, int defaultValue) throws CodeException {
        if (ParamCheckUtil.isEmpty(content) || NULL_STR.equals(content)) {
            return defaultValue;
        }
        int result = 0;
        try {
            result = Integer.parseInt(content);
        }
        catch (Exception e) {
            throw new CodeException("600703", message, (Throwable)e);
        }
        if (result == defaultValue) {
            return defaultValue;
        }
        if (result <= 0) {
            throw new CodeException("600705", message);
        }
        return result;
    }

    public static int checkNotNegative(String content, String message, int defaultValue) throws CodeException {
        if (ParamCheckUtil.isEmpty(content) || NULL_STR.equals(content)) {
            return defaultValue;
        }
        int result = 0;
        try {
            result = Integer.parseInt(content);
        }
        catch (Exception e) {
            throw new CodeException("600703", message, (Throwable)e);
        }
        if (result < 0) {
            throw new CodeException("600705", message);
        }
        return result;
    }

    public static int checkNotNegativeRangeAndNotEmpty(String content, String message, int min) throws CodeException {
        if (ParamCheckUtil.isEmpty(content) || NULL_STR.equals(content)) {
            throw new CodeException("600401", message);
        }
        if (!ParamCheckUtil.isPositiveInteger(content) && !"0".equals(content)) {
            throw new CodeException("600705", message);
        }
        int contentInt = Integer.parseInt(content);
        if (contentInt < min) {
            throw new CodeException("600605", message + "(min: " + min);
        }
        return contentInt;
    }

    public static int checkPositiveRangeAndNotEmpty(String content, String message, int min, int max) throws CodeException {
        if (ParamCheckUtil.isEmpty(content) || NULL_STR.equals(content)) {
            throw new CodeException("600401", message);
        }
        if (!ParamCheckUtil.isPositiveInteger(content)) {
            throw new CodeException("600704", message);
        }
        int contentInt = Integer.parseInt(content);
        if (contentInt < min || contentInt > max) {
            throw new CodeException("600605", new String[]{message, min + "", max + ""});
        }
        return contentInt;
    }

    public static String checkKeywordPositionIndex(String keywordPositionIndex, String message, int keywordPositionCount) throws CodeException {
        StringBuffer rs = new StringBuffer();
        String integerRegex = "^[0-9]+$";
        String rangeRegex = "^[1-9]+[\\-]?[1-9]+$";
        String multiRegex = "^[1-9]+[1-9,]+[1-9]+$";
        if (Pattern.matches(integerRegex, keywordPositionIndex)) {
            int keywordPosition = Integer.parseInt(keywordPositionIndex);
            rs = keywordPosition > keywordPositionCount ? new StringBuffer(String.valueOf(keywordPositionCount)) : new StringBuffer(keywordPositionIndex);
        } else if (Pattern.matches(rangeRegex, keywordPositionIndex)) {
            int end;
            String[] iArr = keywordPositionIndex.split("-");
            int start = Integer.parseInt(iArr[0]);
            if (start > (end = Integer.parseInt(iArr[1]))) {
                throw new CodeException("600605", message + ":" + keywordPositionIndex);
            }
            if (end > keywordPositionCount) {
                end = keywordPositionCount;
            }
            if (start == end) {
                rs = new StringBuffer(String.valueOf(start));
            } else if (start < end) {
                rs = new StringBuffer(String.valueOf(start));
                for (int index = start + 1; index < end; ++index) {
                    rs.append("," + String.valueOf(index));
                }
                rs.append("," + String.valueOf(end));
            }
        } else if (Pattern.matches(multiRegex, keywordPositionIndex)) {
            String[] multiStrings;
            rs = new StringBuffer(keywordPositionIndex);
            for (String str : multiStrings = rs.toString().split(",")) {
                int pageNo = Integer.parseInt(str);
                if (pageNo <= keywordPositionCount) continue;
                throw new CodeException("600605", "\u5173\u952e\u5b57\u4f4d\u7f6e\u7d22\u5f15\u5927\u4e8e\u5173\u952e\u5b57\u603b\u6570\uff1a" + keywordPositionCount);
            }
        } else {
            rs = new StringBuffer("0");
        }
        return rs.toString();
    }

    public static PdfReader checkPdf(byte[] pdf) throws CodeException {
        if (null == pdf || pdf.length == 0) {
            throw new CodeException("600401", "pdf is null ");
        }
        try {
            return new PdfReader(pdf);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg.indexOf("bad.user.password") >= 0) {
                throw new CodeException("600401", " pdf has password ", (Throwable)e);
            }
            if (msg.contains("No message found for pdf.header.not.found")) {
                throw new CodeException("600803", e);
            }
            if (msg.contains("PDF header signature not found.")) {
                throw new CodeException("600803", e);
            }
            throw new CodeException("600000", e);
        }
    }

    public static void checkIsPdfFile(byte[] pdf) throws CodeException {
        if (null == pdf || pdf.length < pdfFlagBytes.length) {
            throw new CodeException("600401", "pdf is null ");
        }
        for (int i = 0; i < pdfFlagBytes.length; ++i) {
            if (pdfFlagBytes[i] == pdf[i]) continue;
            sysLog.error("the file is not pdf format:" + new String(pdf, 0, pdfFlagBytes.length, BaseConstants.CHARSET_DEFAULT_CHARSET));
            throw new CodeException("600803", "the file is not pdf format");
        }
    }

    public static boolean checkIsImage(byte[] iamge) throws CodeException {
        byte[] header = new byte[4];
        System.arraycopy(iamge, 0, header, 0, 4);
        String headerStr = ProofHashUtil.bytes2hex(header);
        boolean isImage = false;
        if (headerStr != null) {
            if (headerStr.startsWith(JPEG_TAG)) {
                isImage = true;
            } else if (headerStr.startsWith(PNG_TAG)) {
                isImage = true;
            } else if (headerStr.startsWith(GIF_TAG)) {
                isImage = true;
            } else if (headerStr.startsWith(TIFF_TAG)) {
                isImage = true;
            } else if (headerStr.startsWith(BMP_TAG)) {
                isImage = true;
            }
        }
        return isImage;
    }

    public static void main(String[] args) throws CodeException {
        System.out.println(ValidityUtil.checkKeywordPositionIndex("1,1,5", "", 5));
    }

    static {
        try {
            pdfFlagBytes = PDF_FILE_FLAG.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

