/*
 * Decompiled with CFR 0.152.
 */
package cfca.integration.uarc.graphics;

import cfca.integration.uarc.fn.CoordTransformer;
import cfca.integration.uarc.fn.EllipseFunction;
import cfca.integration.uarc.graphics.UArcEllipse;
import cfca.integration.uarc.graphics.UArcRectangle;
import cfca.integration.uarc.graphics.UArcShape;
import java.awt.AlphaComposite;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class UArcImage
extends UArcShape {
    private UArcEllipse uae;
    private int width;
    private int height;
    private double theta;
    private float alpha;
    private Image bi;
    private double slide;
    private double startAngle;
    private double arcAngle;
    private int n;
    private boolean rounding;
    private boolean horizontal;
    private BufferedImage[] arrBI;
    private int[] arrWidth;
    private int[] arrHeight;
    private UArcRectangle uar;
    private boolean center;
    private int gap;
    private int leftgap;

    public UArcImage(UArcEllipse uae, BufferedImage bi, int width, int height, boolean rounding, double slide, double startAngle, double arcAngle, int n, boolean horizontal, double theta, float alpha) {
        this.uae = uae;
        this.bi = bi;
        this.width = width;
        this.height = height;
        this.slide = slide;
        this.startAngle = startAngle;
        this.arcAngle = arcAngle;
        this.n = n;
        this.horizontal = horizontal;
        this.theta = theta;
        this.alpha = alpha;
        this.rounding = rounding;
    }

    public UArcImage(UArcEllipse uae, BufferedImage[] arrBI, int[] arrWidth, int[] arrHeight, boolean rounding, double slide, double startAngle, double arcAngle, int n, boolean horizontal, double theta, float alpha) {
        this.uae = uae;
        this.arrBI = arrBI;
        this.arrWidth = arrWidth;
        this.arrHeight = arrHeight;
        this.rounding = rounding;
        this.slide = slide;
        this.startAngle = startAngle;
        this.arcAngle = arcAngle;
        this.n = n;
        this.horizontal = horizontal;
        this.theta = theta;
        this.alpha = alpha;
    }

    public UArcImage(UArcRectangle uar, BufferedImage[] arrBI, int[] arrWidth, int[] arrHeight, boolean center, double slide, double theta, float alpha, int gap, int leftgap) {
        this.uar = uar;
        this.arrBI = arrBI;
        this.arrWidth = arrWidth;
        this.arrHeight = arrHeight;
        this.center = center;
        this.slide = slide;
        this.theta = theta;
        this.alpha = alpha;
        this.gap = gap;
        this.leftgap = leftgap;
    }

    public void draw() {
        if (this.uae != null && this.bi != null) {
            EllipseFunction.UArcPoints uaps;
            int x = this.uae.getX();
            int y = this.uae.getY();
            int a = this.uae.getWidth() / 2;
            int b = this.uae.getHeight() / 2;
            if (Double.isNaN(this.slide)) {
                uaps = new EllipseFunction.UArcPoints(1);
                EllipseFunction.UArcPoint arcPoint = new EllipseFunction.UArcPoint();
                arcPoint.x0 = 0.0;
                arcPoint.y0 = 0.0;
                arcPoint.normal0 = 1.5707963267948966;
                uaps.add(arcPoint);
            } else {
                EllipseFunction ellipseFn = new EllipseFunction(a, b);
                double arcLength = ellipseFn.getArcLength(this.startAngle, this.arcAngle);
                double[] angles = ellipseFn.getAngles(arcLength, this.startAngle, this.arcAngle, this.n);
                uaps = ellipseFn.getCenterPoints(angles, this.slide, this.rounding);
            }
            int[][] arrPts = uaps.toArrayXY();
            double[] arrNorm = uaps.toArrayNormal();
            this.draw(arrPts, arrNorm, this.horizontal, this.theta, x, y, a, b, this.alpha);
        } else if (this.uae != null && this.arrBI != null) {
            int x = this.uae.getX();
            int y = this.uae.getY();
            int a = this.uae.getWidth() / 2;
            int b = this.uae.getHeight() / 2;
            EllipseFunction ellipseFn = new EllipseFunction(a, b);
            double arcLength = ellipseFn.getArcLength(this.startAngle, this.arcAngle);
            double[] angles = ellipseFn.getAngles(arcLength, this.startAngle, this.arcAngle, this.n);
            EllipseFunction.UArcPoints uaps = ellipseFn.getCenterPoints(angles, this.slide, this.rounding);
            int[][] arrPts = uaps.toArrayXY();
            double[] arrNorm = uaps.toArrayNormal();
            this.draw0(arrPts, arrNorm, this.horizontal, this.theta, x, y, a, b, this.alpha);
        } else if (this.uar != null && this.arrBI != null) {
            double tmpslide = -this.slide;
            int x = this.uar.getX();
            int y = this.uar.getY();
            int width = this.uar.getWidth();
            int len = this.arrBI.length;
            EllipseFunction.UArcPoints uaps = new EllipseFunction.UArcPoints(len);
            int fontsize = 0;
            if (this.center) {
                int p0x = x + width / 2;
                int p0y = (int)((double)y + tmpslide);
                if (len % 2 == 0) {
                    EllipseFunction.UArcPoint uap;
                    int i;
                    int len0 = len / 2;
                    for (i = len0 - 1; i >= 0; --i) {
                        fontsize = this.arrWidth[i];
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p0x + this.gap / 2 - (fontsize + this.gap) * (len0 - i);
                        uap.y0 = p0y;
                        uaps.add(0, uap);
                    }
                    for (i = len0; i < len; ++i) {
                        fontsize = this.arrWidth[i];
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p0x + this.gap / 2 + (fontsize + this.gap) * (i - len0);
                        uap.y0 = p0y;
                        uaps.add(uap);
                    }
                } else {
                    EllipseFunction.UArcPoint uap;
                    int i;
                    int len0 = len / 2;
                    for (i = len0 - 1; i >= 0; --i) {
                        fontsize = this.arrWidth[i];
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p0x - fontsize / 2 - (fontsize + this.gap) * (len0 - i);
                        uap.y0 = p0y;
                        uaps.add(0, uap);
                    }
                    uap = new EllipseFunction.UArcPoint();
                    fontsize = this.arrWidth[len0];
                    uap.x0 = p0x - fontsize / 2;
                    uap.y0 = p0y;
                    uaps.add(uap);
                    for (i = len0 + 1; i < len; ++i) {
                        fontsize = this.arrWidth[i];
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p0x + fontsize / 2 + this.gap + (fontsize + this.gap) * (i - 1 - len0);
                        uap.y0 = p0y;
                        uaps.add(uap);
                    }
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    fontsize = this.arrWidth[i];
                    EllipseFunction.UArcPoint uap = new EllipseFunction.UArcPoint();
                    uap.x0 = x + this.leftgap + (fontsize + this.gap) * i;
                    uap.y0 = (double)y + tmpslide;
                    uaps.add(uap);
                }
            }
            int[][] arrPts = uaps.toArrayXY();
            this.draw1(arrPts, this.arrWidth);
        }
    }

    private void draw1(int[][] arrPts, int[] arrWidth) {
        int n = arrPts[0].length;
        this.g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        for (int i = 0; i < n; ++i) {
            int rx = arrPts[0][i] + arrWidth[i] / 2;
            int ry = arrPts[1][i] - arrWidth[i] / 2;
            this.g2d.rotate(-this.theta, rx, ry);
            int x2 = arrPts[0][i];
            this.g2d.drawImage(this.arrBI[i].getScaledInstance(arrWidth[i], this.arrHeight[i], 4), x2, arrPts[1][i], null);
            this.g2d.rotate(this.theta, rx, ry);
        }
        this.g2d.setComposite(AlphaComposite.getInstance(3));
    }

    private void draw0(int[][] arrPts, double[] arrNorm, boolean horizontal, double theta, int x, int y, int a, int b, float alpha) {
        int n = arrPts[0].length;
        CoordTransformer ctf = new CoordTransformer(-a - x, b + y, 0.0);
        int[][] newArrPts = ctf.translateFromLogicalToDevice(arrPts);
        for (int i = 0; i < n; ++i) {
            int x0 = arrPts[0][i];
            int y0 = arrPts[1][i];
            int x1 = newArrPts[0][i];
            int y1 = newArrPts[1][i];
            double normal = arrNorm[i];
            int x2 = x1 - this.arrWidth[i] / 2;
            int y2 = y1 - this.arrHeight[i] / 2;
            if (horizontal) {
                normal = 0.0;
            } else if (this.rounding) {
                if (x0 == 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 == 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 == 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 > 0 && y0 == 0) {
                    normal += 4.71238898038469;
                } else if (x0 > 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 > 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                }
            } else if (x0 == 0 && y0 > 0) {
                normal -= 1.5707963267948966;
            } else if (x0 == 0 && y0 < 0) {
                normal -= 1.5707963267948966;
            } else if (x0 < 0 && y0 == 0) {
                normal -= 1.5707963267948966;
            } else if (x0 > 0 && y0 == 0) {
                normal += 4.71238898038469;
            } else if (x0 <= 0 || y0 <= 0) {
                if (x0 < 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 > 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                }
            }
            AlphaComposite newComposite = AlphaComposite.getInstance(3, alpha);
            this.g2d.setComposite(newComposite);
            this.g2d.rotate(-(normal += theta), x1, y1);
            this.g2d.drawImage(this.arrBI[i].getScaledInstance(this.arrWidth[i], this.arrHeight[i], 4), x2, y2, null);
            this.g2d.rotate(normal, x1, y1);
            this.g2d.setComposite(AlphaComposite.getInstance(3));
        }
    }

    private void draw(int[][] arrPts, double[] arrNorm, boolean horizontal, double theta, int x, int y, int a, int b, float alpha) {
        int n = arrPts[0].length;
        CoordTransformer ctf = new CoordTransformer(-a - x, b + y, 0.0);
        int[][] newArrPts = ctf.translateFromLogicalToDevice(arrPts);
        for (int i = 0; i < n; ++i) {
            int x0 = arrPts[0][i];
            int y0 = arrPts[1][i];
            int x1 = newArrPts[0][i];
            int y1 = newArrPts[1][i];
            double normal = arrNorm[i];
            int x2 = x1 - this.width / 2;
            int y2 = y1 - this.height / 2;
            if (horizontal) {
                normal = 0.0;
            } else if (this.rounding) {
                if (x0 == 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 == 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 == 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 > 0 && y0 == 0) {
                    normal += 4.71238898038469;
                } else if (x0 <= 0 || y0 <= 0) {
                    if (x0 < 0 && y0 > 0) {
                        normal -= 1.5707963267948966;
                    } else if (x0 < 0 && y0 < 0) {
                        normal -= 1.5707963267948966;
                    } else if (x0 > 0 && y0 < 0) {
                        normal -= 1.5707963267948966;
                    }
                }
            } else if (x0 == 0 && y0 > 0) {
                normal -= 1.5707963267948966;
            } else if (x0 == 0 && y0 < 0) {
                normal -= 1.5707963267948966;
            } else if (x0 < 0 && y0 == 0) {
                normal -= 1.5707963267948966;
            } else if (x0 > 0 && y0 == 0) {
                normal += 4.71238898038469;
            } else if (x0 <= 0 || y0 <= 0) {
                if (x0 < 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 > 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                }
            }
            AlphaComposite newComposite = AlphaComposite.getInstance(3, alpha);
            this.g2d.setComposite(newComposite);
            this.g2d.rotate(-(normal += theta), x1, y1);
            this.g2d.drawImage(this.bi.getScaledInstance(this.width, this.height, 4), x2, y2, null);
            this.g2d.rotate(normal, x1, y1);
            this.g2d.setComposite(AlphaComposite.getInstance(3));
        }
    }
}

