/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.parser;

import cfca.com.itextpdf.text.pdf.parser.ImageRenderInfo;
import cfca.com.itextpdf.text.pdf.parser.RenderFilter;
import cfca.com.itextpdf.text.pdf.parser.RenderListener;
import cfca.com.itextpdf.text.pdf.parser.TextRenderInfo;

public class FilteredRenderListener
implements RenderListener {
    private final RenderListener delegate;
    private final RenderFilter[] filters;

    public FilteredRenderListener(RenderListener delegate, RenderFilter ... filters) {
        this.delegate = delegate;
        this.filters = filters;
    }

    public void renderText(TextRenderInfo renderInfo) {
        for (RenderFilter filter : this.filters) {
            if (filter.allowText(renderInfo)) continue;
            return;
        }
        this.delegate.renderText(renderInfo);
    }

    public void beginTextBlock() {
        this.delegate.beginTextBlock();
    }

    public void endTextBlock() {
        this.delegate.endTextBlock();
    }

    public void renderImage(ImageRenderInfo renderInfo) {
        for (RenderFilter filter : this.filters) {
            if (filter.allowImage(renderInfo)) continue;
            return;
        }
        this.delegate.renderImage(renderInfo);
    }
}

