/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.seal;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.ofd.base.asn1.CertDigestObj;
import cfca.sadk.ofd.base.asn1.CertInfoList;
import cfca.sadk.ofd.base.asn1.GM0031SourceData;
import cfca.sadk.ofd.base.asn1.SES_CertList;
import cfca.sadk.ofd.base.asn1.SES_ESPropertyInfo;
import cfca.sadk.ofd.base.asn1.SES_SealInfo;
import cfca.sadk.ofd.base.asn1.SES_SignInfo;
import cfca.sadk.ofd.base.asn1.SESeal;
import cfca.sadk.ofd.base.common.FileHashUtil;
import cfca.sadk.ofd.base.common.MechanismUtil;
import cfca.sadk.ofd.base.common.ParamCheckUtil;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.ofd.OFDConstants;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.DERPrintableString;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;

public class SealCheckUtil {
    private static Logger businessLog = LoggerFactory.getLogger(SealCheckUtil.class);

    public static void checkSeal(SESeal eSseal, X509Cert signCert, Date signDate, int verifyLevel) throws SealException {
        long start = System.currentTimeMillis();
        businessLog.info("checkSeal start...");
        try {
            GM0031SourceData gmSourceData;
            ASN1ObjectIdentifier signOID;
            if (null == eSseal) {
                throw new IllegalArgumentException("eSseal is null");
            }
            if (null == signCert) {
                throw new IllegalArgumentException("signCert is null");
            }
            SES_SealInfo eSeal = eSseal.getEsealInfo();
            SES_SignInfo sealSignInfo = eSseal.getSignInfo();
            SES_ESPropertyInfo property = eSeal.getProperty();
            Date sealStartTime = property.getValidStart();
            Date sealEndTime = property.getValidEnd();
            ParamCheckUtil.checkDateValidity(sealStartTime, sealEndTime, signDate, "ESeal ");
            ASN1OctetString signerCert = eSeal.getCert();
            if (null == signerCert && null == (signerCert = eSseal.getCert()) && sealSignInfo != null) {
                signerCert = sealSignInfo.getCert();
            }
            if (null == (signOID = eSeal.getSignatureAlgorithm()) && null == (signOID = eSseal.getSignatureAlgorithm()) && sealSignInfo != null) {
                signOID = sealSignInfo.getSignatureAlgorithm();
            }
            byte[] certData = signerCert.getOctets();
            X509Cert sealCert = new X509Cert(certData);
            ParamCheckUtil.checkCertValidity(signDate, sealCert, verifyLevel);
            byte[] sealSignature = null;
            sealSignature = sealSignInfo != null ? sealSignInfo.getSignData().getBytes() : eSseal.getSignature().getBytes();
            Signature sigUtil = new Signature();
            String sigAlg = Mechanism.getSignatureAlgName((AlgorithmIdentifier)new AlgorithmIdentifier(signOID));
            byte[] sourceData = eSeal.getEncoded();
            boolean isValid = sigUtil.p1VerifyMessage(sigAlg, sourceData, sealSignature, sealCert.getPublicKey(), BCSoftLib.INSTANCE());
            if (!isValid && !(isValid = sigUtil.p1VerifyMessage(sigAlg, sourceData = (gmSourceData = new GM0031SourceData(eSeal, signOID, signerCert)).getEncoded(), sealSignature, sealCert.getPublicKey(), BCSoftLib.INSTANCE()))) {
                throw new IllegalArgumentException("SESeal signature is not valid!");
            }
            ASN1Integer certListType = property.getCertListType();
            boolean isSigner = false;
            if (certListType != null && certListType.getValue().compareTo(new BigInteger("2")) == 0) {
                SES_CertList digestList = property.getCertList();
                CertDigestObj[] certs = digestList.getCertDigestList().toCertDigestArray();
                for (int i = 0; i < certs.length; ++i) {
                    CertDigestObj digestObj = CertDigestObj.getInstance((Object)certs[i]);
                    DERPrintableString hashOID = digestObj.getObjType();
                    Mechanism digestAlg = MechanismUtil.getMechanism(hashOID);
                    byte[] certHash = FileHashUtil.calculateHash(signCert.getEncoded(), digestAlg, null);
                    if (!Arrays.equals(certHash, digestObj.getCertDigestValue().getOctets())) continue;
                    isSigner = true;
                    break;
                }
            } else {
                CertInfoList certSeq = property.getCertList().getCertInfoList();
                Certificate[] certs = certSeq.toCertificateArray();
                for (int j = 0; j < certs.length; ++j) {
                    byte[] certBytes = certs[j].getEncoded();
                    X509Cert cert = new X509Cert(certBytes);
                    if (!signCert.getSubject().equals(cert.getSubject())) continue;
                    isSigner = true;
                    break;
                }
            }
            if (!isSigner) {
                throw new IllegalArgumentException("signCert is not in the list of signerCertList,signCert DN=" + signCert.getSubject());
            }
        }
        catch (SealException e) {
            businessLog.error("checkSeal failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("checkSeal failed:", (Throwable)e);
            throw new SealException("checkSeal failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("checkSeal end...cost=" + (end - start) + " ms");
        }
    }

    public static void checkSealVersion(SESeal eSseal, int specification) throws SealException {
        BigInteger version = eSseal.getEsealInfo().getHeader().getVersion().getValue();
        int sealVersion = version.intValue();
        if (sealVersion == OFDConstants.GBVersion.intValue()) {
            boolean isTaxType;
            boolean isGBType = specification == 4 || specification == -1 && SysEnv.isGBType();
            boolean bl = isTaxType = specification == 3 || specification == -1 && SysEnv.isGBType() && SysEnv.isForTax();
            if (!isGBType && !isTaxType) {
                throw new SealException("seal's hearder version is not right Type! Seal's version=" + sealVersion);
            }
        } else if (sealVersion == OFDConstants.GMVersion.intValue()) {
            boolean isGMType;
            boolean bl = isGMType = specification == 1 || specification == -1 && SysEnv.isGM0031();
            if (!isGMType) {
                throw new SealException("seal's hearder version is not GMType! Seal's version=" + sealVersion);
            }
        } else if (sealVersion == OFDConstants.ANKEVersion.intValue()) {
            boolean isANKE;
            boolean bl = isANKE = specification == 2 || specification == -1 && SysEnv.isAnKeType();
            if (!isANKE) {
                throw new SealException("seal's hearder version is not ANKEType! Seal's version=" + version);
            }
        }
    }

    public class CertListType {
        public static final String certList = "1";
        public static final String certDigestList = "2";
    }
}

