/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk;

import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.error_messages.MessageLocalization;
import cfca.com.itextpdf.text.pdf.AcroFields;
import cfca.com.itextpdf.text.pdf.PRAcroForm;
import cfca.com.itextpdf.text.pdf.PdfArray;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfIndirectReference;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfNumber;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.security.PdfPKCS7;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.sadk.cert.PdfX509Certificate;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfSealVerifier {
    private boolean isPKCS7Valid = false;
    private HashMap<String, PdfArray> coveredByteRangeMap;
    private long fileLength;
    private ArrayList<String> sigNames;
    private HashMap<String, X509Cert> sigNameCertMap;
    private HashMap<String, PdfPKCS7> sigNamePKCS7Map;
    private HashMap<String, List<AcroFields.FieldPosition>> signaturePositionMap;

    public PdfSealVerifier(byte[] sealedPdf) throws PKIException, IOException, GeneralSecurityException {
        this.isPKCS7Valid = this.verifyPKCS7(sealedPdf);
    }

    public PdfSealVerifier(PdfReader pdfReader) throws PKIException, GeneralSecurityException {
        this.isPKCS7Valid = this.verifyPKCS7(pdfReader);
    }

    public PdfSealVerifier() {
    }

    public HashMap<String, PdfArray> getCoveredByteRangeMap() {
        return this.coveredByteRangeMap;
    }

    public PdfArray getUncoveredByteRange() {
        long[] uncoveredByteRange = new long[2];
        long maxPos = 0L;
        String sigName = null;
        for (String name : this.coveredByteRangeMap.keySet()) {
            PdfArray tmpByteArray = this.coveredByteRangeMap.get(name);
            long[] tmpLongArray = tmpByteArray.asLongArray();
            long coveredPos = tmpLongArray[2] + tmpLongArray[3] - 1L;
            if (maxPos >= coveredPos) continue;
            maxPos = coveredPos;
            sigName = name;
        }
        PdfArray maxByteArray = this.coveredByteRangeMap.get(sigName);
        long[] maxLongArray = maxByteArray.asLongArray();
        uncoveredByteRange[0] = maxLongArray[2] + maxLongArray[3];
        uncoveredByteRange[1] = this.fileLength - uncoveredByteRange[0];
        PdfArray uncoveredRange = new PdfArray();
        PdfNumber pdfNumber0 = new PdfNumber(uncoveredByteRange[0]);
        PdfNumber pdfNumber1 = new PdfNumber(uncoveredByteRange[1]);
        uncoveredRange.add(pdfNumber0);
        uncoveredRange.add(pdfNumber1);
        return uncoveredRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyPKCS7(PdfReader pdfReader) throws GeneralSecurityException, PKIException {
        boolean isAllPKCS7OK = true;
        boolean isAPKCS7OK = true;
        try {
            this.fileLength = pdfReader.getFileLength();
            AcroFields af = pdfReader.getAcroFields();
            ArrayList<String> names = af.getSignatureNames();
            if (names == null || names.isEmpty()) {
                boolean bl = !isAllPKCS7OK;
                return bl;
            }
            this.sigNameCertMap = new HashMap();
            this.sigNamePKCS7Map = new HashMap();
            this.sigNames = new ArrayList();
            this.coveredByteRangeMap = new HashMap();
            this.signaturePositionMap = new HashMap();
            for (String name : names) {
                PdfPKCS7 pkcs7 = af.verifySignature(name);
                List<AcroFields.FieldPosition> fieldPositionList = af.getFieldPositions(name);
                PdfArray coveredByteRange = af.getCoveredByteRange();
                X509Certificate x509Certificate = pkcs7.getSigningCertificate();
                X509Cert x509Cert = new X509Cert(x509Certificate.getEncoded());
                this.sigNames.add(name);
                this.sigNameCertMap.put(name, x509Cert);
                this.sigNamePKCS7Map.put(name, pkcs7);
                this.coveredByteRangeMap.put(name, coveredByteRange);
                this.signaturePositionMap.put(name, fieldPositionList);
                isAPKCS7OK = pkcs7.verify();
                if (isAllPKCS7OK = isAllPKCS7OK && isAPKCS7OK) continue;
                break;
            }
        }
        finally {
            if (null != pdfReader) {
                pdfReader.close();
            }
        }
        this.isPKCS7Valid = isAllPKCS7OK;
        return isAllPKCS7OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyPKCS7(byte[] sealedPdfData) throws PKIException, IOException, GeneralSecurityException {
        boolean isAllPKCS7OK = true;
        boolean isAPKCS7OK = true;
        PdfReader pdfReader = null;
        try {
            pdfReader = new PdfReader(sealedPdfData);
            this.fileLength = pdfReader.getFileLength();
            AcroFields af = pdfReader.getAcroFields();
            ArrayList<String> names = af.getSignatureNames();
            if (names == null || names.isEmpty()) {
                boolean bl = !isAllPKCS7OK;
                return bl;
            }
            this.sigNameCertMap = new HashMap();
            this.sigNamePKCS7Map = new HashMap();
            this.sigNames = new ArrayList();
            this.coveredByteRangeMap = new HashMap();
            this.signaturePositionMap = new HashMap();
            for (String name : names) {
                PdfPKCS7 pkcs7 = af.verifySignature(name);
                List<AcroFields.FieldPosition> fieldPositionList = af.getFieldPositions(name);
                PdfArray coveredByteRange = af.getCoveredByteRange();
                X509Certificate x509Certificate = pkcs7.getSigningCertificate();
                X509Cert x509Cert = new X509Cert(x509Certificate.getEncoded());
                this.sigNames.add(name);
                this.sigNameCertMap.put(name, x509Cert);
                this.sigNamePKCS7Map.put(name, pkcs7);
                this.coveredByteRangeMap.put(name, coveredByteRange);
                this.signaturePositionMap.put(name, fieldPositionList);
                isAPKCS7OK = pkcs7.verify();
                if (isAllPKCS7OK = isAllPKCS7OK && isAPKCS7OK) continue;
                break;
            }
        }
        finally {
            if (null != pdfReader) {
                pdfReader.close();
            }
        }
        this.isPKCS7Valid = isAllPKCS7OK;
        return isAllPKCS7OK;
    }

    public HashMap<String, X509Cert> getSigNameCertMap() throws DocumentException {
        if (!this.isPKCS7Valid) {
            throw new DocumentException("the sealed pdf is tampered or has not been verified!");
        }
        return this.sigNameCertMap;
    }

    public boolean isPKCS7Valid() {
        return this.isPKCS7Valid;
    }

    public HashMap<String, X509Cert> getSigNameCertMap(String field) throws DocumentException {
        if (!this.isPKCS7Valid) {
            throw new DocumentException("the sealed pdf is tampered or has not been verified!");
        }
        HashMap<String, X509Cert> tmpSigNameCertMap = new HashMap<String, X509Cert>();
        ArrayList<String> tmpFields = this.getSigNames(field);
        int sizeOftmpFields = tmpFields.size();
        for (int i = 0; i < sizeOftmpFields; ++i) {
            String aTmpfield = tmpFields.get(i);
            X509Cert aCert = this.sigNameCertMap.get(aTmpfield);
            tmpSigNameCertMap.put(aTmpfield, aCert);
        }
        return tmpSigNameCertMap;
    }

    public HashMap<String, PdfPKCS7> getSigNamePKCS7Map() throws DocumentException {
        if (!this.isPKCS7Valid) {
            throw new DocumentException("the sealed pdf is tampered or has not been verified!");
        }
        return this.sigNamePKCS7Map;
    }

    public HashMap<String, PdfPKCS7> getSigNamePKCS7Map(String field) throws DocumentException {
        if (!this.isPKCS7Valid) {
            throw new DocumentException("the sealed pdf is tampered or has not been verified!");
        }
        HashMap<String, PdfPKCS7> tmpSigNamePKCS7Map = new HashMap<String, PdfPKCS7>();
        ArrayList<String> tmpFields = this.getSigNames(field);
        int sizeOftmpFields = tmpFields.size();
        for (int i = 0; i < sizeOftmpFields; ++i) {
            String aTmpfield = tmpFields.get(i);
            PdfPKCS7 pdfPKCS7 = this.sigNamePKCS7Map.get(aTmpfield);
            tmpSigNamePKCS7Map.put(aTmpfield, pdfPKCS7);
        }
        return tmpSigNamePKCS7Map;
    }

    public HashMap<String, List<AcroFields.FieldPosition>> getSignaturePositionMap() throws DocumentException {
        if (!this.isPKCS7Valid) {
            throw new DocumentException("the sealed pdf is tampered or has not been verified!");
        }
        return this.signaturePositionMap;
    }

    public ArrayList<String> getSigNames() throws DocumentException {
        if (!this.isPKCS7Valid) {
            throw new DocumentException("the sealed pdf is tampered or has not been verified!");
        }
        return this.sigNames;
    }

    public ArrayList<String> getSigNames(String field) throws DocumentException {
        ArrayList<String> sigNamesWithSpecField = new ArrayList<String>();
        if (!this.isPKCS7Valid) {
            throw new DocumentException("the sealed pdf is tampered or has not been verified!");
        }
        int sizeOfSigNames = this.sigNames.size();
        for (int i = 0; i < sizeOfSigNames; ++i) {
            String tmpField = this.sigNames.get(i);
            if (!tmpField.contains(field)) continue;
            sigNamesWithSpecField.add(tmpField);
        }
        if (sigNamesWithSpecField.isEmpty()) {
            throw new DocumentException("No specific field Signature/Seal found!");
        }
        return sigNamesWithSpecField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyPKCS7(PdfReader pdfReader, PreProceedingWithVerifyingPKCS7 preVerifyingPKCS7) throws PKIException, GeneralSecurityException {
        this.isPKCS7Valid = true;
        AcroFields af = pdfReader.getAcroFields();
        if (null == af) {
            throw new GeneralSecurityException("no acrofield exist in document");
        }
        ArrayList<String> names = af.getSignatureNames();
        int signatureOrder = 0;
        int size = names.size();
        if (size == 0) {
            throw new GeneralSecurityException("no signature found in pdf!");
        }
        int certificationLevel = 0;
        try {
            this.fileLength = pdfReader.getFileLength();
            PdfDictionary catalogDict = pdfReader.getCatalog();
            PdfDictionary permsDict = catalogDict.getAsDict(PdfName.PERMS);
            if (permsDict != null) {
                PdfIndirectReference docMDPRef = permsDict.getAsIndirectObject(PdfName.DOCMDP);
                PdfDictionary docMDPDict = (PdfDictionary)PdfReader.getPdfObjectRelease(docMDPRef);
                PdfArray referenceArray = docMDPDict.getAsArray(PdfName.REFERENCE);
                PdfDictionary referenceDict = referenceArray.getAsDict(0);
                PdfDictionary transformparamsDict = referenceDict.getAsDict(PdfName.TRANSFORMPARAMS);
                PdfNumber pNumber = transformparamsDict.getAsNumber(PdfName.P);
                certificationLevel = pNumber.intValue();
            }
            long[] nonSigAnnotOffsetArray = null;
            long[] sigAnnotOffsetArray = null;
            if (certificationLevel == 0) {
                long[] replicaXref = pdfReader.getReplicaXref();
                PRAcroForm acroForm = pdfReader.getAcroForm();
                PdfArray acroFormArray = (PdfArray)PdfReader.getPdfObjectRelease(acroForm.get(PdfName.FIELDS));
                int acroFormSize = acroFormArray.size();
                nonSigAnnotOffsetArray = new long[acroFormSize];
                sigAnnotOffsetArray = new long[acroFormSize];
                int nonSigIdx = 0;
                int sigIdx = 0;
                for (int i = 0; i < acroFormSize; ++i) {
                    long offset;
                    int index;
                    int number;
                    PdfIndirectReference acroRef = acroFormArray.getAsIndirectObject(i);
                    PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObjectRelease(acroRef);
                    PdfName type = annot.getAsName(PdfName.TYPE);
                    PdfName subType = annot.getAsName(PdfName.SUBTYPE);
                    PdfName fieldType = annot.getAsName(PdfName.FT);
                    if (PdfName.ANNOT.equals(type) && PdfName.WIDGET.equals(subType) && (PdfName.TX.equals(fieldType) || PdfName.BTN.equals(fieldType) || PdfName.CH.equals(fieldType))) {
                        number = acroRef.getNumber();
                        index = number * 2;
                        offset = replicaXref[index];
                        nonSigAnnotOffsetArray[nonSigIdx++] = offset;
                        continue;
                    }
                    if (!PdfName.ANNOT.equals(type) || !PdfName.WIDGET.equals(subType) || !PdfName.SIG.equals(fieldType)) continue;
                    number = acroRef.getNumber();
                    index = number * 2;
                    offset = replicaXref[index];
                    sigAnnotOffsetArray[sigIdx++] = offset;
                }
            }
            boolean isOnlyOneSignature = size == 1;
            block12: for (String name : names) {
                ++signatureOrder;
                PdfPKCS7 pkcs7 = af.verifySignature(name);
                List<AcroFields.FieldPosition> fieldPositionList = af.getFieldPositions(name);
                PdfArray coveredByteRange = af.getCoveredByteRange();
                X509Certificate x509Certificate = pkcs7.getSigningCertificate();
                X509Cert x509Cert = new X509Cert(x509Certificate.getEncoded());
                boolean tmpCoveredValid = pkcs7.verify();
                String signatureName = name;
                PdfX509Certificate pdfX509Certificate = new PdfX509Certificate(x509Cert);
                PdfPKCS7 pdfPKCS7 = pkcs7;
                PdfArray coveredArray = coveredByteRange;
                boolean coveredValid = tmpCoveredValid;
                boolean shouldValid = tmpCoveredValid;
                String promptMessage = "";
                switch (certificationLevel) {
                    case 0: {
                        long length;
                        long start;
                        long coveredEnd;
                        if (shouldValid) {
                            long start2 = coveredByteRange.getAsNumber(2).longValue();
                            long length2 = coveredByteRange.getAsNumber(3).longValue();
                            coveredEnd = start2 + length2;
                            int lengthOfArray = nonSigAnnotOffsetArray.length;
                            boolean isAcroFieldOutOfRange = false;
                            for (int i = 0; i < lengthOfArray; ++i) {
                                if (coveredEnd >= nonSigAnnotOffsetArray[i]) continue;
                                isAcroFieldOutOfRange = true;
                                break;
                            }
                            if (isAcroFieldOutOfRange) {
                                shouldValid = false;
                            }
                        }
                        boolean bl = this.isPKCS7Valid = this.isPKCS7Valid && shouldValid;
                        promptMessage = shouldValid ? (this.fileLength > (coveredEnd = (start = coveredArray.getAsNumber(2).longValue()) + (length = coveredArray.getAsNumber(3).longValue())) ? MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.since.the.current.document.is.verified.valid.but.that.change.is.accepted.by.verifier", new Object[0]) : MessageLocalization.getComposedMessage("Pdf.Document.has.not.been.changed.since.the.current.document.is.verified.valid", new Object[0])) : MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.or.damaged.since.the.current.certificate.is.applied", new Object[0]);
                        boolean proceedingWithVerifyingPKCS7 = preVerifyingPKCS7.proceedingWithVerifyingPKCS7(certificationLevel, signatureName, pdfX509Certificate, pdfPKCS7, fieldPositionList, coveredArray, promptMessage, signatureOrder, coveredValid, shouldValid);
                        if (proceedingWithVerifyingPKCS7) continue block12;
                        boolean bl2 = this.isPKCS7Valid;
                        return bl2;
                    }
                    case 1: {
                        if (isOnlyOneSignature) {
                            long length;
                            long start = coveredArray.getAsNumber(2).longValue();
                            if (this.fileLength > start + (length = coveredArray.getAsNumber(3).longValue())) {
                                shouldValid = false;
                            }
                            promptMessage = shouldValid ? MessageLocalization.getComposedMessage("Pdf.Document.has.not.been.changed.since.the.current.document.is.verified.valid", new Object[0]) : MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.or.damaged.since.the.current.certificate.is.applied", new Object[0]);
                        } else if (size > signatureOrder) {
                            shouldValid = false;
                            promptMessage = MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.or.damaged.since.the.current.certificate.is.applied", new Object[0]);
                        } else {
                            long length;
                            long start = coveredArray.getAsNumber(2).longValue();
                            if (this.fileLength > start + (length = coveredArray.getAsNumber(3).longValue())) {
                                shouldValid = false;
                            }
                            promptMessage = shouldValid ? MessageLocalization.getComposedMessage("Pdf.Document.has.not.been.changed.since.the.current.document.is.verified.valid", new Object[0]) : MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.or.damaged.since.the.current.certificate.is.applied", new Object[0]);
                        }
                        this.isPKCS7Valid = this.isPKCS7Valid && shouldValid;
                        boolean proceedingWithVerifyingPKCS7 = preVerifyingPKCS7.proceedingWithVerifyingPKCS7(certificationLevel, signatureName, pdfX509Certificate, pdfPKCS7, fieldPositionList, coveredArray, promptMessage, signatureOrder, coveredValid, shouldValid);
                        if (proceedingWithVerifyingPKCS7) continue block12;
                        boolean bl = this.isPKCS7Valid;
                        return bl;
                    }
                    case 2: 
                    case 3: {
                        if (isOnlyOneSignature) {
                            long length;
                            long start = coveredArray.getAsNumber(2).longValue();
                            promptMessage = this.fileLength > start + (length = coveredArray.getAsNumber(3).longValue()) ? (shouldValid ? MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.since.the.current.document.is.verified.valid.but.that.change.is.accepted.by.verifier", new Object[0]) : MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.or.damaged.since.the.current.certificate.is.applied", new Object[0])) : (shouldValid ? MessageLocalization.getComposedMessage("Pdf.Document.has.not.been.changed.since.the.current.document.is.verified.valid", new Object[0]) : MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.or.damaged.since.the.current.certificate.is.applied", new Object[0]));
                        } else if (size > signatureOrder) {
                            shouldValid = false;
                            promptMessage = MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.or.damaged.since.the.current.certificate.is.applied", new Object[0]);
                        } else {
                            long length;
                            long start = coveredArray.getAsNumber(2).longValue();
                            promptMessage = this.fileLength > start + (length = coveredArray.getAsNumber(3).longValue()) ? (shouldValid ? MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.since.the.current.document.is.verified.valid.but.that.change.is.accepted.by.verifier", new Object[0]) : MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.or.damaged.since.the.current.certificate.is.applied", new Object[0])) : (shouldValid ? MessageLocalization.getComposedMessage("Pdf.Document.has.not.been.changed.since.the.current.document.is.verified.valid", new Object[0]) : MessageLocalization.getComposedMessage("Pdf.Document.has.been.changed.or.damaged.since.the.current.certificate.is.applied", new Object[0]));
                        }
                        this.isPKCS7Valid = this.isPKCS7Valid && shouldValid;
                        boolean proceedingWithVerifyingPKCS7 = preVerifyingPKCS7.proceedingWithVerifyingPKCS7(certificationLevel, signatureName, pdfX509Certificate, pdfPKCS7, fieldPositionList, coveredArray, promptMessage, signatureOrder, coveredValid, shouldValid);
                        if (proceedingWithVerifyingPKCS7) continue block12;
                        boolean bl = this.isPKCS7Valid;
                        return bl;
                    }
                }
                throw new GeneralSecurityException("Not support certification level: " + certificationLevel);
            }
        }
        finally {
            if (null != pdfReader) {
                pdfReader.close();
            }
        }
        return this.isPKCS7Valid;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PreProceedingWithVerifyingPKCS7 {
        public abstract boolean proceedingWithVerifyingPKCS7(int var1, String var2, PdfX509Certificate var3, PdfPKCS7 var4, List<AcroFields.FieldPosition> var5, PdfArray var6, String var7, int var8, boolean var9, boolean var10);
    }
}

