/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;

public final class RSAHelper {
    private static final Logger logger = LoggerFactory.getLogger(RSAHelper.class);
    static final String transformation = "RSA/ECB/PKCS1Padding";

    private RSAHelper() {
    }

    public static final byte[] encrypt(SecureRandom secureRandom, PublicKey encryptionKey, byte[] data) throws SecurityException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSAHelper encrypt>>>>>>Running");
            buffer.append("\n encryptionKey: ");
            buffer.append(SADKDebugger.dump((PublicKey)encryptionKey));
            buffer.append("\n data: ");
            buffer.append(SADKDebugger.dump((byte[])data));
            logger.info(buffer.toString());
        }
        byte[] result = null;
        try {
            Cipher cipher = JSSEJCE.getCipher(transformation);
            cipher.init(1, (Key)encryptionKey, secureRandom);
            result = cipher.doFinal(data);
            if (logger.isInfoEnabled()) {
                logger.info("RSAHelper encrypt<<<<<<binaryResult: " + SADKDebugger.dump((byte[])result));
            }
            return result;
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("RSAHelper encrypt<<<<<<Failure");
                buffer.append("\n encryptionKey: ");
                buffer.append(SADKDebugger.dump((PublicKey)encryptionKey));
                buffer.append("\n data: ");
                buffer.append(SADKDebugger.dump((byte[])data));
                logger.info(buffer.toString());
            }
            throw new SecurityException(e);
        }
    }

    public static final byte[] decrypt(PrivateKey encryptionKey, byte[] encryptedData) throws SecurityException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSAHelper decrypt>>>>>>Running");
            buffer.append("\n encryptionKey: ");
            buffer.append(SADKDebugger.dump((PrivateKey)encryptionKey));
            buffer.append("\n encryptedData: ");
            buffer.append(SADKDebugger.dump((byte[])encryptedData));
            logger.info(buffer.toString());
        }
        byte[] result = null;
        try {
            Cipher cipher = JSSEJCE.getCipher(transformation);
            cipher.init(2, encryptionKey);
            result = cipher.doFinal(encryptedData);
            if (logger.isInfoEnabled()) {
                logger.info("RSAHelper decrypt<<<<<<binaryResult: " + SADKDebugger.dump((byte[])result));
            }
            return result;
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("RSAHelper decrypt<<<<<<Failure");
                buffer.append("\n encryptionKey: ");
                buffer.append(SADKDebugger.dump((PrivateKey)encryptionKey));
                buffer.append("\n encryptedData: ");
                buffer.append(SADKDebugger.dump((byte[])encryptedData));
                logger.info(buffer.toString());
            }
            throw new SecurityException(e);
        }
    }
}

