/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item;

import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.CssSelector;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassDisabledSelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassEmptySelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassFirstChildSelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassFirstOfTypeSelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassLastChildSelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassLastOfTypeSelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassNotSelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassNthChildSelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassNthOfTypeSelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassRootSelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.CssPseudoElementSelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.css.selector.item.ICssSelectorItem;
import cfca.sadk.com.itextpdf.styledxmlparser.node.INode;

public abstract class CssPseudoClassSelectorItem
implements ICssSelectorItem {
    protected String arguments;
    private String pseudoClass;

    protected CssPseudoClassSelectorItem(String pseudoClass) {
        this(pseudoClass, "");
    }

    protected CssPseudoClassSelectorItem(String pseudoClass, String arguments) {
        this.pseudoClass = pseudoClass;
        this.arguments = arguments;
    }

    public static CssPseudoClassSelectorItem create(String fullSelectorString) {
        String arguments;
        String pseudoClass;
        int indexOfParentheses = fullSelectorString.indexOf(40);
        if (indexOfParentheses == -1) {
            pseudoClass = fullSelectorString;
            arguments = "";
        } else {
            pseudoClass = fullSelectorString.substring(0, indexOfParentheses);
            arguments = fullSelectorString.substring(indexOfParentheses + 1, fullSelectorString.length() - 1).trim();
        }
        return CssPseudoClassSelectorItem.create(pseudoClass, arguments);
    }

    public static CssPseudoClassSelectorItem create(String pseudoClass, String arguments) {
        if ("empty".equals(pseudoClass)) {
            return CssPseudoClassEmptySelectorItem.getInstance();
        }
        if ("first-child".equals(pseudoClass)) {
            return CssPseudoClassFirstChildSelectorItem.getInstance();
        }
        if ("first-of-type".equals(pseudoClass)) {
            return CssPseudoClassFirstOfTypeSelectorItem.getInstance();
        }
        if ("last-child".equals(pseudoClass)) {
            return CssPseudoClassLastChildSelectorItem.getInstance();
        }
        if ("last-of-type".equals(pseudoClass)) {
            return CssPseudoClassLastOfTypeSelectorItem.getInstance();
        }
        if ("nth-child".equals(pseudoClass)) {
            return new CssPseudoClassNthChildSelectorItem(arguments);
        }
        if ("nth-of-type".equals(pseudoClass)) {
            return new CssPseudoClassNthOfTypeSelectorItem(arguments);
        }
        if ("not".equals(pseudoClass)) {
            CssSelector selector = new CssSelector(arguments);
            for (ICssSelectorItem item : selector.getSelectorItems()) {
                if (!(item instanceof CssPseudoClassNotSelectorItem) && !(item instanceof CssPseudoElementSelectorItem)) continue;
                return null;
            }
            return new CssPseudoClassNotSelectorItem(selector);
        }
        if ("root".equals(pseudoClass)) {
            return CssPseudoClassRootSelectorItem.getInstance();
        }
        if ("link".equals(pseudoClass)) {
            return new AlwaysApplySelectorItem(pseudoClass, arguments);
        }
        if ("active".equals(pseudoClass) || "focus".equals(pseudoClass) || "hover".equals(pseudoClass) || "target".equals(pseudoClass) || "visited".equals(pseudoClass)) {
            return new AlwaysNotApplySelectorItem(pseudoClass, arguments);
        }
        if ("disabled".equals(pseudoClass)) {
            return CssPseudoClassDisabledSelectorItem.getInstance();
        }
        return null;
    }

    @Override
    public int getSpecificity() {
        return 1024;
    }

    @Override
    public boolean matches(INode node) {
        return false;
    }

    public String toString() {
        return ":" + this.pseudoClass + (!this.arguments.isEmpty() ? "(" + this.arguments + ")" : "");
    }

    public String getPseudoClass() {
        return this.pseudoClass;
    }

    private static class AlwaysNotApplySelectorItem
    extends CssPseudoClassSelectorItem {
        AlwaysNotApplySelectorItem(String pseudoClass, String arguments) {
            super(pseudoClass, arguments);
        }

        @Override
        public boolean matches(INode node) {
            return false;
        }
    }

    private static class AlwaysApplySelectorItem
    extends CssPseudoClassSelectorItem {
        AlwaysApplySelectorItem(String pseudoClass, String arguments) {
            super(pseudoClass, arguments);
        }

        @Override
        public boolean matches(INode node) {
            return true;
        }
    }
}

