/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.system.logging.LoggerManager;
import java.security.SecureRandom;

final class RSACardP1Decoder {
    static final int MIN_PADDING_LENGTH = 11;
    private static final int HEADER_LENGTH = 10;
    private static final byte PADDING_STARTER = 0;
    private static final byte PADDING_PRIVATEKEY_SIGN = 1;
    private static final byte PADDING_PUBLICKEY_ENCRYPT = 2;
    private static final byte PADDING_SIGN = -1;

    private RSACardP1Decoder() {
    }

    static byte[] addPKCS1Padding(byte[] message, int modulusLength, boolean isSigning) throws CryptoException {
        if (message == null || message.length == 0) {
            throw new CryptoException("RSA/ECB/PKCS1Padding addPKCS1Padding failed: param#message = null || length = 0");
        }
        if (modulusLength <= 0) {
            throw new CryptoException("RSA/ECB/PKCS1Padding addPKCS1Padding failed: param#modulusLength <=0 , modulusLength=" + modulusLength);
        }
        int maxAllowedLength = modulusLength - 11;
        if (message.length > maxAllowedLength) {
            throw new CryptoParameterException("RSA/ECB/PKCS1Padding addPKCS1Padding failed: too more data, messageLength=" + message.length + ",maxAllowedLength=" + maxAllowedLength);
        }
        byte[] blockData = new byte[modulusLength];
        int inLen = message.length;
        int inLast = blockData.length - inLen - 1;
        if (isSigning) {
            blockData[0] = 0;
            blockData[1] = 1;
            for (int i = 2; i < inLast; ++i) {
                blockData[i] = -1;
            }
        } else {
            byte[] paddingData = new byte[inLast];
            SecureRandom random = new SecureRandom();
            random.nextBytes(paddingData);
            for (int i = 2; i < inLast; ++i) {
                while (paddingData[i] == 0) {
                    paddingData[i] = (byte)random.nextInt();
                }
            }
            System.arraycopy(paddingData, 0, blockData, 0, paddingData.length);
            blockData[0] = 0;
            blockData[1] = 2;
        }
        blockData[inLast] = 0;
        System.arraycopy(message, 0, blockData, blockData.length - inLen, inLen);
        return blockData;
    }

    static byte[] delPKCS1Padding(byte[] message, int modulusLength, boolean isVerify) throws CryptoException {
        int start;
        if (message == null) {
            throw new CryptoException("RSA/ECB/PKCS1Padding delPKCS1Padding failed: param#message = null ");
        }
        if (modulusLength <= 0) {
            throw new CryptoException("RSA/ECB/PKCS1Padding delPKCS1Padding failed: param#modulusLength <=0 , modulusLength=" + modulusLength);
        }
        byte[] paddingData = RSACardP1Decoder.formatData(message, modulusLength);
        if (message[0] != 0) {
            return RSACardP1Decoder.warningAndThrowsException("RSA/ECB/PKCS1Padding delPKCS1Padding failed: unknown block type #required data[0]=0x00", paddingData);
        }
        byte type = paddingData[1];
        if (isVerify) {
            byte pad;
            if (type != 1) {
                return RSACardP1Decoder.warningAndThrowsException("RSA/ECB/PKCS1Padding delPKCS1Padding failed: unknown block type #required data[1]=0x01 for PubKey", paddingData);
            }
            for (start = 2; start < paddingData.length && (pad = paddingData[start]) != 0; ++start) {
                if (pad == -1) continue;
                return RSACardP1Decoder.warningAndThrowsException("RSA/ECB/PKCS1Padding delPKCS1Padding failed:  block padding incorrect #required padding 0xFF for type=0x01", paddingData);
            }
        } else {
            if (type != 2) {
                return RSACardP1Decoder.warningAndThrowsException("RSA/ECB/PKCS1Padding delPKCS1Padding failed: unknown block type #required data[1]=0x02 for PriKey", paddingData);
            }
            for (start = 2; start < paddingData.length && paddingData[start] != 0; ++start) {
            }
        }
        if (++start > paddingData.length) {
            return RSACardP1Decoder.warningAndThrowsException("RSA/ECB/PKCS1Padding delPKCS1Padding failed: no data in block #padding too more", paddingData);
        }
        if (start < 10) {
            return RSACardP1Decoder.warningAndThrowsException("RSA/ECB/PKCS1Padding delPKCS1Padding failed: no data in block #padding too less", paddingData);
        }
        byte[] result = new byte[paddingData.length - start];
        System.arraycopy(paddingData, start, result, 0, result.length);
        return result;
    }

    private static byte[] formatData(byte[] message, int modulusLength) throws CryptoException {
        byte[] dataoutput;
        if (message.length == modulusLength) {
            dataoutput = message;
        } else if (message.length < modulusLength) {
            dataoutput = new byte[modulusLength];
            int starter = dataoutput.length - message.length;
            System.arraycopy(message, 0, dataoutput, starter, message.length);
        } else {
            dataoutput = new byte[modulusLength];
            System.arraycopy(message, 1, dataoutput, 0, modulusLength);
        }
        return dataoutput;
    }

    private static byte[] warningAndThrowsException(String warning, byte[] paddingData) throws CryptoException {
        String message = warning + ": " + DataHelper.dump4KPartData(paddingData);
        LoggerManager.exceptionLogger.error(message);
        throw new CryptoException(warning);
    }
}

